package org.jfrog.jade.plugins.common.naming;

/*
 * Copyright 2005-2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @author Fred Simon
 */
public interface GroupDefinition {
    /**
     * Returns the short name used for other plugins depending on the actual groupId
     * This short name should not contains '.' or '/' characters as it used in folders and IDE names.
     * @param groupId The actual groupId of a project or artifact
     * @return a unique short name
     */
    String getName(String groupId);

    /**
     * If multiple group def matches the same groupId, the selection is done by priority.
     * @return the priority level of this group definition
     */
    int getPriority();
}