/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.jade.plugins.common.ant;

import org.apache.maven.plugin.logging.Log;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;

public class AntBuildListener
implements BuildListener {
    private Log log;
    private boolean removeEmpty = false;
    private boolean cutInPieces = false;

    public AntBuildListener(Log log) {
        this.log = log;
    }

    public void buildStarted(BuildEvent event) {
        this.logInfo(event);
    }

    public void buildFinished(BuildEvent event) {
        this.logInfo(event);
    }

    public void targetStarted(BuildEvent event) {
        this.logInfo(event);
    }

    public void targetFinished(BuildEvent event) {
        this.logInfo(event);
    }

    public void taskStarted(BuildEvent event) {
        this.logInfo(event);
    }

    public void taskFinished(BuildEvent event) {
        this.logInfo(event);
    }

    public void messageLogged(BuildEvent event) {
        String formattedMessage = event.getMessage().trim();
        if (this.removeEmpty && formattedMessage.length() < 3) {
            return;
        }
        int priority = event.getPriority();
        if (this.cutInPieces) {
            int firstCharPos = -1;
            int lastCharPos = -1;
            for (int i = 0; i < formattedMessage.length(); ++i) {
                char ch = formattedMessage.charAt(i);
                if (ch > ' ') {
                    if (lastCharPos == -1) {
                        firstCharPos = i;
                    }
                    lastCharPos = i;
                }
                if (ch >= ' ' && i - firstCharPos < 80) continue;
                if (lastCharPos - firstCharPos > 3) {
                    this.insertMessage(priority, formattedMessage.subSequence(firstCharPos, lastCharPos + 1));
                }
                lastCharPos = -1;
                firstCharPos = -1;
            }
            if (lastCharPos - firstCharPos > 3) {
                this.insertMessage(priority, formattedMessage.subSequence(firstCharPos, lastCharPos + 1));
            }
        } else {
            this.insertMessage(priority, formattedMessage);
        }
    }

    public boolean isRemoveEmpty() {
        return this.removeEmpty;
    }

    public void setRemoveEmpty(boolean removeEmpty) {
        this.removeEmpty = removeEmpty;
    }

    public boolean isCutInPieces() {
        return this.cutInPieces;
    }

    public void setCutInPieces(boolean cutInPieces) {
        this.cutInPieces = cutInPieces;
    }

    public Log getLog() {
        return this.log;
    }

    private void insertMessage(int priority, CharSequence formattedMessage) {
        if (priority > 3) {
            this.log.debug(formattedMessage);
        } else if (priority == 2) {
            this.log.info(formattedMessage);
        } else if (priority < 2) {
            this.log.error(formattedMessage);
        }
    }

    private void logInfo(BuildEvent event) {
        this.log.info((CharSequence)event.getMessage());
    }
}

