/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.info.motherboard.unix;

import java.util.HashMap;
import java.util.Map;
import org.jutils.jhardware.info.motherboard.AbstractMotherboardInfo;
import org.jutils.jhardware.util.HardwareInfoUtils;

public final class UnixMotherboardInfo
extends AbstractMotherboardInfo {
    private static final String DMIPATH = "/sys/devices/virtual/dmi/id/";

    private static String getMotherboardData() {
        String fullData = "";
        if (HardwareInfoUtils.isSudo()) {
            fullData = fullData + HardwareInfoUtils.executeCommand("sudo", "dmidecode", "--type", "2");
        } else {
            fullData = fullData + "\tProduct Name: " + HardwareInfoUtils.executeCommand("cat", "/sys/devices/virtual/dmi/id/board_name");
            fullData = fullData + "\tVendor: " + HardwareInfoUtils.executeCommand("cat", "/sys/devices/virtual/dmi/id/board_vendor");
            fullData = fullData + "\tVersion: " + HardwareInfoUtils.executeCommand("cat", "/sys/devices/virtual/dmi/id/board_version");
        }
        return fullData;
    }

    @Override
    protected Map<String, String> parseInfo() {
        String[] dataStringLines;
        HashMap<String, String> motherboardDataMap = new HashMap<String, String>();
        for (String dataLine : dataStringLines = UnixMotherboardInfo.getMotherboardData().split("\\r?\\n")) {
            if (!dataLine.startsWith("\t")) continue;
            String[] dataStringInfo = dataLine.split(":");
            if (dataStringInfo.length == 2) {
                motherboardDataMap.put(dataStringInfo[0].trim(), dataStringInfo[1].trim());
                continue;
            }
            if (dataStringInfo.length != 1 || !"\tFeatures".equals(dataStringInfo[0])) continue;
            motherboardDataMap.put(dataStringInfo[0].trim(), UnixMotherboardInfo.getFeatures(dataStringLines));
        }
        return motherboardDataMap;
    }

    private static String getFeatures(String[] dataStringLines) {
        StringBuilder features = new StringBuilder();
        for (String characteristicsLine : dataStringLines) {
            if (characteristicsLine.trim().length() <= 0 || !characteristicsLine.startsWith("\t\t")) continue;
            features.append(characteristicsLine.trim()).append("\n");
        }
        return features.toString();
    }
}

