/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jhardware.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jutils.jhardware.util.HardwareInfoUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public enum DirectXInfoLoader {
    get;

    private boolean loaded = false;
    private Document directXData;

    private DirectXInfoLoader() {
        if (!this.loaded) {
            this.load();
            this.loaded = true;
        }
    }

    private void load() {
        Path tempFile;
        try {
            tempFile = Files.createTempFile("dxdata_" + System.currentTimeMillis(), ".tmp", new FileAttribute[0]);
            tempFile.toFile().deleteOnExit();
            HardwareInfoUtils.executeCommand("dxdiag", "/x", tempFile.toAbsolutePath().toString());
        }
        catch (IOException ex) {
            Logger.getLogger(DirectXInfoLoader.class.getName()).log(Level.SEVERE, "Error creating directX data", ex);
            return;
        }
        while (tempFile.toFile().length() <= 0L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Logger.getLogger(DirectXInfoLoader.class.getName()).log(Level.SEVERE, null, e);
            }
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            this.directXData = dBuilder.parse(tempFile.toFile());
            this.directXData.getDocumentElement().normalize();
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(DirectXInfoLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public List<Map<String, String>> getDisplayInfo() {
        ArrayList<Map<String, String>> displays = new ArrayList<Map<String, String>>();
        Node rootNode = this.directXData.getElementsByTagName("DisplayDevices").item(0);
        NodeList nodeList = rootNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            HashMap<String, String> display = new HashMap<String, String>();
            Node node = nodeList.item(i);
            NodeList deviceData = node.getChildNodes();
            for (int j = 0; j < deviceData.getLength(); ++j) {
                Node deviceInfo = deviceData.item(j);
                if (deviceInfo == null || deviceInfo.getNodeType() != 1) continue;
                display.put(deviceInfo.getNodeName(), deviceInfo.getTextContent());
            }
            displays.add(display);
        }
        return displays;
    }
}

