/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.DirectObject;
import org.jibx.binding.def.DirectProperty;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.MappingBase;
import org.jibx.binding.def.MappingDefinition;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.runtime.JiBXException;

public class MappingDirect
extends MappingBase {
    private final DirectObject m_mappingImpl;
    private final BoundClass m_boundClass;
    private boolean m_isGenerated;

    public MappingDirect(IContainer contain, String type, DirectObject dir) throws JiBXException {
        super(contain, type, dir);
        this.m_mappingImpl = dir;
        this.m_boundClass = BoundClass.getInstance(type, null);
    }

    public BoundClass getBoundClass() {
        return this.m_boundClass;
    }

    public String getBoundType() {
        return this.m_mappingImpl.getTargetClass().getName();
    }

    public IComponent getImplComponent() {
        return this.m_component;
    }

    public ClassFile getMarshaller() throws JiBXException {
        return this.m_mappingImpl.getMarshaller();
    }

    public ClassFile getUnmarshaller() throws JiBXException {
        return this.m_mappingImpl.getUnmarshaller();
    }

    public NameDefinition getName() {
        return this.m_mappingImpl.getName();
    }

    public String getTypeName() {
        return null;
    }

    public void addNamespace(NamespaceDefinition ns) {
        throw new IllegalStateException("Internal error: no namespace definition possible");
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isBase() {
        return false;
    }

    public void addExtension(MappingDefinition mdef) {
        throw new IllegalStateException("Internal error: no extension possible");
    }

    public IComponent buildRef(IContainer parent, IContextObj objc, String type, PropertyDefinition prop) throws JiBXException {
        return new DirectProperty(prop, this.m_mappingImpl);
    }

    public void generateCode(boolean force) throws JiBXException {
        if (!this.m_isGenerated) {
            if (this.m_boundClass.isDirectAccess()) {
                this.addIMarshallableMethod();
                this.addIUnmarshallableMethod();
            }
            this.m_isGenerated = true;
        }
    }

    public void setLinkages() throws JiBXException {
        this.m_mappingImpl.setLinkages();
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.println("mapping direct " + this.m_mappingImpl.getTargetClass().getName());
    }
}

