/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.util.ArrayList;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.ContainerElementBase;
import org.jibx.binding.model.DefinitionContext;
import org.jibx.binding.model.ElementBase;
import org.jibx.binding.model.IncludeElement;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.ModelVisitor;
import org.jibx.binding.model.NameAttributes;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.binding.model.StructureElementBase;
import org.jibx.binding.model.TemplateElement;
import org.jibx.binding.model.TemplateElementBase;
import org.jibx.binding.model.ValidationContext;
import org.jibx.binding.model.ValidationProblem;

public class RegistrationVisitor
extends ModelVisitor {
    private final ValidationContext m_context;

    public RegistrationVisitor(ValidationContext vctx) {
        this.m_context = vctx;
    }

    public void visitTree(ElementBase root) {
        this.m_context.tourTree(root, (ModelVisitor)this);
        this.m_context.tourTree(root, new ModelVisitor(){

            public boolean visit(MappingElement node) {
                node.validateExtension(RegistrationVisitor.this.m_context);
                return true;
            }

            public boolean visit(StructureElementBase node) {
                return false;
            }
        });
    }

    public boolean visit(ContainerElementBase node) {
        ValidationProblem problem;
        if (node.getLabel() != null && (problem = this.m_context.getBindingRoot().getDefinitions().addNamedStructure(node)) != null) {
            this.m_context.addProblem(problem);
        }
        return super.visit(node);
    }

    public boolean visit(TemplateElementBase node) {
        ArrayList nss;
        DefinitionContext pctx;
        if (this.m_context.getParentElement() instanceof BindingElement && (pctx = this.m_context.getParentElement().getDefinitions()) != null && (nss = pctx.getNamespaces()) != null) {
            DefinitionContext nctx = node.getDefinitions();
            if (nctx == null) {
                nctx = new DefinitionContext(pctx);
                node.setDefinitions(nctx);
            }
            for (int i = 0; i < nss.size(); ++i) {
                nctx.addNamespace((NamespaceElement)nss.get(i));
            }
        }
        return super.visit(node);
    }

    public boolean visit(IncludeElement node) {
        BindingElement contain = (BindingElement)this.m_context.getParentElement();
        BindingElement binding = node.getBinding();
        if (binding != null) {
            contain.getDefinitions().injectNamespaces(binding.getDefinitions());
        }
        return super.visit(node);
    }

    public boolean visit(MappingElement node) {
        NameAttributes name;
        DefinitionContext dctx = this.m_context.getCurrentDefinitions();
        dctx.addTemplate(node, this.m_context);
        if (!node.isAbstract() && (name = node.getNameAttributes()) != null && name.getName() != null) {
            dctx.addMappedName(name, node, this.m_context);
        }
        return super.visit(node);
    }

    public boolean visit(NamespaceElement node) {
        ValidationProblem problem = this.m_context.getCurrentDefinitions().addNamespace(node);
        if (problem != null) {
            this.m_context.addProblem(problem);
        }
        return super.visit(node);
    }

    public boolean visit(TemplateElement node) {
        this.m_context.getCurrentDefinitions().addTemplate(node, this.m_context);
        return super.visit(node);
    }
}

