/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.Writer;
import org.jibx.runtime.ICharacterEscaper;
import org.jibx.runtime.impl.XMLWriterBase;

public class GenericXMLWriter
extends XMLWriterBase {
    private Writer m_writer;
    private ICharacterEscaper m_escaper;
    private boolean m_indent;
    private int m_indentBase;
    private int m_indentPerLevel;
    private char[] m_indentSequence;

    public GenericXMLWriter(String[] stringArray) {
        super(stringArray);
    }

    public void setOutput(Writer writer, ICharacterEscaper iCharacterEscaper) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_writer = writer;
        this.m_escaper = iCharacterEscaper;
        this.reset();
    }

    public void setIndentSpaces(int n, String string, char c) {
        if (n >= 0) {
            if (string == null) {
                string = "\n";
            }
            this.m_indent = true;
            this.m_indentBase = string.length();
            this.m_indentPerLevel = n;
            int n2 = string.length() + n * 10;
            this.m_indentSequence = new char[n2];
            for (int i = 0; i < n2; ++i) {
                this.m_indentSequence[i] = i < string.length() ? string.charAt(i) : c;
            }
        } else {
            this.m_indent = false;
        }
    }

    protected void writeMarkup(String string) throws IOException {
        this.m_writer.write(string);
    }

    protected void writeMarkup(char c) throws IOException {
        this.m_writer.write(c);
    }

    protected void defineNamespace(int n, String string) {
    }

    protected void undefineNamespace(int n) {
    }

    protected void writePrefix(int n) throws IOException {
        try {
            String string = this.getNamespacePrefix(n);
            if (string.length() > 0) {
                this.m_writer.write(string);
                this.m_writer.write(58);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("Namespace URI has not been declared.");
        }
    }

    protected void writeAttributeText(String string) throws IOException {
        this.m_escaper.writeAttribute(string, this.m_writer);
    }

    public void writeTextContent(String string) throws IOException {
        this.m_escaper.writeContent(string, this.m_writer);
        this.m_contentSeen = true;
        this.m_textSeen = true;
    }

    public void writeCData(String string) throws IOException {
        this.m_escaper.writeCData(string, this.m_writer);
        this.m_contentSeen = true;
        this.m_textSeen = true;
    }

    public void indent(int n) throws IOException {
        if (this.m_indent) {
            int n2 = this.m_indentBase + (this.getNestingDepth() + n) * this.m_indentPerLevel;
            if (n2 > this.m_indentSequence.length) {
                int n3 = Math.max(n2, this.m_indentSequence.length * 2 - this.m_indentBase);
                char[] cArray = new char[n3];
                System.arraycopy(this.m_indentSequence, 0, cArray, 0, this.m_indentSequence.length);
                for (int i = this.m_indentSequence.length; i < n3; ++i) {
                    cArray[i] = cArray[this.m_indentBase];
                }
                this.m_indentSequence = cArray;
            }
            this.m_writer.write(this.m_indentSequence, 0, n2);
        }
    }

    public void indent() throws IOException {
        this.indent(0);
    }

    public void flush() throws IOException {
        if (this.m_writer != null) {
            this.indent();
            this.m_writer.flush();
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.m_writer != null) {
            this.m_writer.close();
            this.m_writer = null;
        }
    }
}

