/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.BackFillHolder;
import org.jibx.runtime.impl.BackFillReference;
import org.jibx.runtime.impl.ITrackSourceImpl;
import org.jibx.runtime.impl.IXMLReaderFactory;

public class UnmarshallingContext
implements IUnmarshallingContext {
    private static final int INITIAL_STACK_SIZE = 20;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final IXMLReaderFactory s_readerFactory;
    private IBindingFactory m_factory;
    private IXMLReader m_reader;
    protected String[] m_unmarshallerClasses;
    protected IUnmarshaller[] m_unmarshallers;
    protected String[] m_namespaces;
    protected String[] m_names;
    protected int m_globalCount;
    protected HashMap[] m_idMaps;
    protected String[] m_idClasses;
    protected int m_stackDepth;
    protected Object[] m_objectStack;
    protected HashMap m_unmarshalMap;
    protected Integer[] m_indexes;
    protected String m_idref;
    protected Object m_userContext;
    static /* synthetic */ Class class$org$jibx$runtime$impl$UnmarshallingContext;
    static /* synthetic */ Class class$org$jibx$runtime$impl$IXMLReaderFactory;

    private static IXMLReaderFactory createReaderFactory(String cname) {
        Class<?> clas = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                clas = loader.loadClass(cname);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clas == null) {
            try {
                loader = (class$org$jibx$runtime$impl$UnmarshallingContext == null ? (class$org$jibx$runtime$impl$UnmarshallingContext = UnmarshallingContext.class$("org.jibx.runtime.impl.UnmarshallingContext")) : class$org$jibx$runtime$impl$UnmarshallingContext).getClassLoader();
                clas = loader.loadClass(cname);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to specified parser factory class " + cname);
            }
        }
        if (!(class$org$jibx$runtime$impl$IXMLReaderFactory == null ? (class$org$jibx$runtime$impl$IXMLReaderFactory = UnmarshallingContext.class$("org.jibx.runtime.impl.IXMLReaderFactory")) : class$org$jibx$runtime$impl$IXMLReaderFactory).isAssignableFrom(clas)) {
            throw new RuntimeException("Specified parser factory class " + cname + " does not implement IXMLReaderFactory interface");
        }
        try {
            Method meth = clas.getMethod("getInstance", null);
            return (IXMLReaderFactory)meth.invoke(null, null);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Specified parser factory class " + cname + " does not define static getInstance() method");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error on parser factory class " + cname + " getInstance() method call: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error on parser factory class " + cname + " getInstance() method call: " + e.getMessage());
        }
    }

    public UnmarshallingContext(int nmap, String[] umcs, String[] nss, String[] names, String[] idcs, IBindingFactory ifact) {
        this.m_globalCount = nss.length;
        this.m_unmarshallerClasses = new String[nmap];
        System.arraycopy(umcs, 0, this.m_unmarshallerClasses, 0, umcs.length);
        this.m_unmarshallers = new IUnmarshaller[nmap];
        this.m_namespaces = new String[nmap];
        System.arraycopy(nss, 0, this.m_namespaces, 0, nss.length);
        this.m_names = new String[nmap];
        System.arraycopy(names, 0, this.m_names, 0, names.length);
        this.m_idClasses = idcs;
        int size = idcs == null ? 1 : idcs.length;
        this.m_idMaps = new HashMap[size];
        this.m_objectStack = new Object[20];
        this.m_factory = ifact;
    }

    public UnmarshallingContext() {
        this(0, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, null);
    }

    public static String buildNameString(String ns, String name) {
        if (ns == null || "".equals(ns)) {
            return "\"" + name + "\"";
        }
        return "\"{" + ns + "}" + name + "\"";
    }

    public String currentNameString() {
        return UnmarshallingContext.buildNameString(this.m_reader.getNamespace(), this.m_reader.getName());
    }

    public String buildPositionString() {
        return this.m_reader.buildPositionString();
    }

    public void throwStartTagNameError(String ns, String name) throws JiBXException {
        throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, name) + " start tag, found " + this.currentNameString() + " start tag " + this.buildPositionString());
    }

    public void throwEndTagNameError(String ns, String name) throws JiBXException {
        throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, name) + " end tag, found " + this.currentNameString() + " end tag " + this.buildPositionString());
    }

    public void throwNameException(String msg, String ns, String name) throws JiBXException {
        throw new JiBXException(msg + UnmarshallingContext.buildNameString(ns, name) + this.buildPositionString());
    }

    private void advance() throws JiBXException {
        this.m_reader.nextToken();
    }

    private boolean verifyNamespace(String ns) {
        if (ns == null || "".equals(ns)) {
            return this.m_reader.getNamespace().length() == 0;
        }
        return ns.equals(this.m_reader.getNamespace());
    }

    private String getAttributeValue(String ns, String name) {
        return this.m_reader.getAttributeValue(ns, name);
    }

    public void setDocument(InputStream ins, String name, String enc, boolean nsa) throws JiBXException {
        this.m_reader = this.m_reader == null ? s_readerFactory.createReader(ins, name, enc, nsa) : s_readerFactory.recycleReader(this.m_reader, ins, name, enc);
        this.reset();
    }

    public void setDocument(InputStream ins, String enc) throws JiBXException {
        this.setDocument(ins, null, enc, true);
    }

    public void setDocument(Reader rdr, String name, boolean nsa) throws JiBXException {
        this.m_reader = this.m_reader == null ? s_readerFactory.createReader(rdr, name, nsa) : s_readerFactory.recycleReader(this.m_reader, rdr, name);
        this.reset();
    }

    public void setDocument(Reader rdr) throws JiBXException {
        this.setDocument(rdr, null, true);
    }

    public void setDocument(InputStream ins, String name, String enc) throws JiBXException {
        this.setDocument(ins, name, enc, true);
    }

    public void setDocument(Reader rdr, String name) throws JiBXException {
        this.setDocument(rdr, name, true);
    }

    public void setDocument(IXMLReader rdr) {
        this.m_reader = rdr;
    }

    public void setFromContext(UnmarshallingContext parent) {
        this.m_factory = parent.m_factory;
        this.m_reader = parent.m_reader;
    }

    public void reset() {
        int i;
        for (i = 0; i < this.m_idMaps.length; ++i) {
            this.m_idMaps[i] = null;
        }
        for (i = this.m_globalCount; i < this.m_unmarshallers.length; ++i) {
            this.m_namespaces[i] = null;
            this.m_names[i] = null;
            this.m_unmarshallers[i] = null;
        }
        this.m_unmarshalMap = null;
        this.m_idref = null;
        for (i = 0; i < this.m_objectStack.length; ++i) {
            this.m_objectStack[i] = null;
        }
        this.m_stackDepth = 0;
        this.m_userContext = null;
    }

    public String toStart() throws JiBXException {
        if (this.m_reader.getEventType() == 2) {
            return this.m_reader.getName();
        }
        while (true) {
            this.m_reader.next();
            switch (this.m_reader.getEventType()) {
                case 2: {
                    return this.m_reader.getName();
                }
                case 3: {
                    throw new JiBXException("Expected start tag, found end tag " + this.currentNameString() + " " + this.buildPositionString());
                }
                case 1: {
                    throw new JiBXException("Expected start tag, found end of document " + this.buildPositionString());
                }
            }
        }
    }

    public String toEnd() throws JiBXException {
        if (this.m_reader.getEventType() == 3) {
            return this.m_reader.getName();
        }
        while (true) {
            this.m_reader.next();
            switch (this.m_reader.getEventType()) {
                case 2: {
                    throw new JiBXException("Expected end tag, found start tag " + this.currentNameString() + " " + this.buildPositionString());
                }
                case 3: {
                    return this.m_reader.getName();
                }
                case 1: {
                    throw new JiBXException("Expected end tag, found end of document " + this.buildPositionString());
                }
            }
        }
    }

    public int toTag() throws JiBXException {
        int type = this.m_reader.getEventType();
        while (type != 2 && type != 3) {
            type = this.m_reader.next();
        }
        return this.m_reader.getEventType();
    }

    public boolean isAt(String ns, String name) throws JiBXException {
        int type = this.m_reader.getEventType();
        while (type != 2 && type != 3) {
            type = this.m_reader.next();
        }
        return this.m_reader.getEventType() == 2 && this.m_reader.getName().equals(name) && this.verifyNamespace(ns);
    }

    public boolean hasAttribute(String ns, String name) throws JiBXException {
        if (this.m_reader.getEventType() == 2) {
            return this.getAttributeValue(ns, name) != null;
        }
        throw new JiBXException("Error parsing document " + this.buildPositionString());
    }

    public boolean hasAnyAttribute(String[] nss, String[] names) throws JiBXException {
        if (this.m_reader.getEventType() == 2) {
            for (int i = 0; i < names.length; ++i) {
                if (this.getAttributeValue(nss[i], names[i]) == null) continue;
                return true;
            }
            return false;
        }
        throw new JiBXException("Error parsing document " + this.buildPositionString());
    }

    public void checkAllowedAttributes(String[] nss, String[] names) throws JiBXException {
        if (this.m_reader.getEventType() == 2) {
            int count = this.m_reader.getAttributeCount();
            block0: for (int i = 0; i < count; ++i) {
                String name = this.m_reader.getAttributeName(i);
                String ns = this.m_reader.getAttributeNamespace(i);
                int base = 0;
                int limit = names.length - 1;
                while (base <= limit) {
                    String comp;
                    int cur = base + limit >> 1;
                    int diff = name.compareTo(names[cur]);
                    if (diff == 0 && (diff = (comp = nss[cur]) == null ? ns.compareTo("") : ns.compareTo(comp)) == 0) continue block0;
                    if (diff < 0) {
                        limit = cur - 1;
                        continue;
                    }
                    if (diff <= 0) continue;
                    base = cur + 1;
                }
                this.throwStartTagException("Illegal attribute " + UnmarshallingContext.buildNameString(ns, name));
            }
        } else {
            throw new JiBXException("Error parsing document " + this.buildPositionString());
        }
    }

    private void matchStart(String ns, String name) throws JiBXException {
        if (this.toTag() == 2) {
            if (!this.m_reader.getName().equals(name) || !this.verifyNamespace(ns)) {
                this.throwStartTagNameError(ns, name);
            }
        } else {
            throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, name) + " start tag, found " + this.currentNameString() + " end tag " + this.buildPositionString());
        }
    }

    public void parseToStartTag(String ns, String name) throws JiBXException {
        this.matchStart(ns, name);
    }

    public void parsePastStartTag(String ns, String name) throws JiBXException {
        this.matchStart(ns, name);
        this.advance();
    }

    public boolean parseIfStartTag(String ns, String name) throws JiBXException {
        if (this.isAt(ns, name)) {
            this.advance();
            return true;
        }
        return false;
    }

    public void parsePastCurrentEndTag(String ns, String name) throws JiBXException {
        int event = this.toTag();
        if (event == 3) {
            if (this.m_reader.getName().equals(name) && this.verifyNamespace(ns)) {
                this.advance();
            } else {
                this.throwEndTagNameError(ns, name);
            }
        } else {
            throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, name) + " end tag, found " + this.currentNameString() + " start tag " + this.buildPositionString());
        }
    }

    public void parsePastEndTag(String ns, String name) throws JiBXException {
        int event = this.m_reader.getEventType();
        if (event == 2) {
            this.advance();
        }
        this.parsePastCurrentEndTag(ns, name);
    }

    public boolean isStart() throws JiBXException {
        int type = this.m_reader.getEventType();
        while (type != 2 && type != 3) {
            type = this.m_reader.next();
        }
        return this.m_reader.getEventType() == 2;
    }

    public boolean isEnd() throws JiBXException {
        int type = this.m_reader.getEventType();
        while (type != 2 && type != 3) {
            type = this.m_reader.next();
        }
        return this.m_reader.getEventType() == 3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String accumulateText() throws JiBXException {
        String text = null;
        StringBuffer buff = null;
        block5: while (true) {
            switch (this.m_reader.getEventType()) {
                case 6: {
                    if (this.m_reader.getText() == null) {
                        throw new JiBXException("Unexpanded entity reference in text at " + this.buildPositionString());
                    }
                }
                case 4: 
                case 5: {
                    if (text == null) {
                        text = this.m_reader.getText();
                        break;
                    }
                    if (buff == null) {
                        buff = new StringBuffer(text);
                    }
                    buff.append(this.m_reader.getText());
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break block5;
                }
            }
            this.m_reader.nextToken();
        }
        if (buff != null) return buff.toString();
        if (text == null) {
            return "";
        }
        String string = text;
        return string;
    }

    public String parseContentText() throws JiBXException {
        return this.accumulateText();
    }

    public String parseContentText(String ns, String tag) throws JiBXException {
        String text = this.accumulateText();
        switch (this.m_reader.getEventType()) {
            case 3: {
                if (this.m_reader.getName().equals(tag) && this.verifyNamespace(ns)) {
                    this.m_reader.nextToken();
                    return text;
                }
                this.throwEndTagNameError(ns, tag);
            }
            case 2: {
                throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, tag) + " end tag, " + "found " + this.currentNameString() + " start tag " + this.buildPositionString());
            }
            case 1: {
                throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, tag) + " end tag, " + "found end of document " + this.buildPositionString());
            }
        }
        return null;
    }

    public int parseContentInt(String ns, String tag) throws JiBXException {
        String text = this.parseContentText(ns, tag);
        try {
            return Utility.parseInt(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public String parseElementText(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.parseContentText(ns, tag);
    }

    public String parseElementText(String ns, String tag, String dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.parseContentText(ns, tag);
        }
        return dflt;
    }

    public String attributeText(String ns, String name) throws JiBXException {
        String value = this.getAttributeValue(ns, name);
        if (value == null) {
            throw new JiBXException("Missing required attribute " + UnmarshallingContext.buildNameString(ns, name) + " " + this.buildPositionString());
        }
        return value;
    }

    public String attributeText(String ns, String name, String dflt) {
        String value = this.getAttributeValue(ns, name);
        if (value == null) {
            return dflt;
        }
        return value;
    }

    public Object findID(String id, int index) throws JiBXException {
        HashMap map = this.m_idMaps[index];
        if (map != null) {
            Object obj = map.get(id);
            if (obj == null || obj instanceof BackFillHolder) {
                return null;
            }
            if (this.m_idClasses == null || this.m_idClasses[index].equals(obj.getClass().getName())) {
                return obj;
            }
            this.throwStartTagException("IDREF element content mapped to wrong type");
        }
        return null;
    }

    public Object findDefinedID(String id, int index) throws JiBXException {
        Object obj = this.findID(id, index);
        if (obj == null) {
            this.throwStartTagException("ID " + id + " not defined");
        }
        return obj;
    }

    public Object parseElementForwardIDREF(String ns, String tag, int index) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        this.m_idref = this.parseContentText(ns, tag);
        return this.findID(this.m_idref, index);
    }

    public Object attributeForwardIDREF(String ns, String name, int index) throws JiBXException {
        this.m_idref = this.attributeText(ns, name);
        return this.findID(this.m_idref, index);
    }

    public Object parseElementExistingIDREF(String ns, String tag, int index) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        this.m_idref = this.parseContentText(ns, tag);
        return this.findDefinedID(this.m_idref, index);
    }

    public Object attributeExistingIDREF(String ns, String name, int index) throws JiBXException {
        this.m_idref = this.attributeText(ns, name);
        return this.findDefinedID(this.m_idref, index);
    }

    public int attributeInt(String ns, String name) throws JiBXException {
        String text = this.attributeText(ns, name);
        try {
            return Utility.parseInt(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public int attributeInt(String ns, String name, int dflt) throws JiBXException {
        String value = this.getAttributeValue(ns, name);
        if (value == null) {
            return dflt;
        }
        try {
            return Utility.parseInt(value);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public int parseElementInt(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.parseContentInt(ns, tag);
    }

    public int parseElementInt(String ns, String tag, int dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.parseContentInt(ns, tag);
        }
        return dflt;
    }

    public int convertEnum(String target, String[] enums, int[] vals) throws JiBXException {
        if (target == null) {
            this.throwStartTagException("Missing required enumeration value");
        }
        try {
            return Utility.enumValue(target, enums, vals);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString());
        }
    }

    public int convertEnum(String target, String[] enums, int[] vals, int dflt) throws JiBXException {
        if (target == null) {
            return dflt;
        }
        try {
            return Utility.enumValue(target, enums, vals);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString());
        }
    }

    public int attributeEnumeration(String ns, String name, String[] enums, int[] vals) throws JiBXException {
        return this.convertEnum(this.getAttributeValue(ns, name), enums, vals);
    }

    public int attributeEnumeration(String ns, String name, String[] enums, int[] vals, int dflt) throws JiBXException {
        return this.convertEnum(this.getAttributeValue(ns, name), enums, vals, dflt);
    }

    public int parseContentEnumeration(String ns, String tag, String[] enums, int[] vals) throws JiBXException {
        return this.convertEnum(this.parseContentText(ns, tag), enums, vals);
    }

    public int parseElementEnumeration(String ns, String tag, String[] enums, int[] vals, int dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            String text = this.parseContentText(ns, tag);
            return this.convertEnum(text, enums, vals, dflt);
        }
        return dflt;
    }

    public byte convertByte(String text) throws JiBXException {
        try {
            return Utility.parseByte(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public byte attributeByte(String ns, String name) throws JiBXException {
        return this.convertByte(this.attributeText(ns, name));
    }

    public byte attributeByte(String ns, String name, byte dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertByte(text);
    }

    public byte parseContentByte(String ns, String tag) throws JiBXException {
        return this.convertByte(this.parseContentText(ns, tag));
    }

    public byte parseElementByte(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.parseContentByte(ns, tag);
    }

    public byte parseElementByte(String ns, String tag, byte dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertByte(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public short convertShort(String text) throws JiBXException {
        try {
            return Utility.parseShort(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public short attributeShort(String ns, String name) throws JiBXException {
        return this.convertShort(this.attributeText(ns, name));
    }

    public short attributeShort(String ns, String name, short dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertShort(text);
    }

    public short parseContentShort(String ns, String tag) throws JiBXException {
        return this.convertShort(this.parseContentText(ns, tag));
    }

    public short parseElementShort(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.parseContentShort(ns, tag);
    }

    public short parseElementShort(String ns, String tag, short dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertShort(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public char convertChar(String text) throws JiBXException {
        try {
            return Utility.parseChar(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public char attributeChar(String ns, String name) throws JiBXException {
        return this.convertChar(this.attributeText(ns, name));
    }

    public char attributeChar(String ns, String name, char dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertChar(text);
    }

    public char parseContentChar(String ns, String tag) throws JiBXException {
        return this.convertChar(this.parseContentText(ns, tag));
    }

    public char parseElementChar(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.parseContentChar(ns, tag);
    }

    public char parseElementChar(String ns, String tag, char dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertChar(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public long convertLong(String text) throws JiBXException {
        try {
            return Utility.parseLong(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public long attributeLong(String ns, String name) throws JiBXException {
        return this.convertLong(this.attributeText(ns, name));
    }

    public long attributeLong(String ns, String name, long dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertLong(text);
    }

    public long parseElementLong(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.convertLong(this.parseContentText(ns, tag));
    }

    public long parseElementLong(String ns, String tag, long dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertLong(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public boolean convertBoolean(String text) throws JiBXException {
        if ("true".equals(text) || "1".equals(text)) {
            return true;
        }
        if ("false".equals(text) || "0".equals(text)) {
            return false;
        }
        throw new JiBXException("Invalid boolean value " + this.buildPositionString());
    }

    public boolean attributeBoolean(String ns, String name) throws JiBXException {
        return this.convertBoolean(this.attributeText(ns, name));
    }

    public boolean attributeBoolean(String ns, String name, boolean dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertBoolean(text);
    }

    public boolean parseElementBoolean(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.convertBoolean(this.parseContentText(ns, tag));
    }

    public boolean parseElementBoolean(String ns, String tag, boolean dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertBoolean(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public float convertFloat(String text) throws JiBXException {
        try {
            return Utility.parseFloat(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public float attributeFloat(String ns, String name) throws JiBXException {
        return this.convertFloat(this.attributeText(ns, name));
    }

    public float attributeFloat(String ns, String name, float dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertFloat(text);
    }

    public float parseElementFloat(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.convertFloat(this.parseContentText(ns, tag));
    }

    public float parseElementFloat(String ns, String tag, float dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertFloat(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public double convertDouble(String text) throws JiBXException {
        try {
            return Utility.parseDouble(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public double attributeDouble(String ns, String name) throws JiBXException {
        return this.convertDouble(this.attributeText(ns, name));
    }

    public double attributeDouble(String ns, String name, double dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertDouble(text);
    }

    public double parseElementDouble(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.convertDouble(this.parseContentText(ns, tag));
    }

    public double parseElementDouble(String ns, String tag, double dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertDouble(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public Date convertDate(String text) throws JiBXException {
        try {
            return new Date(Utility.parseDateTime(text));
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public Date attributeDate(String ns, String name) throws JiBXException {
        return this.convertDate(this.attributeText(ns, name));
    }

    public Date attributeDate(String ns, String name, Date dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertDate(text);
    }

    public Date parseElementDate(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.convertDate(this.parseContentText(ns, tag));
    }

    public Date parseElementDate(String ns, String tag, Date dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertDate(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public void registerBackFill(String id, int index, BackFillReference fill) throws JiBXException {
        Object obj;
        HashMap<String, BackFillHolder> map = this.m_idMaps[index];
        if (map == null) {
            this.m_idMaps[index] = map = new HashMap<String, BackFillHolder>();
        }
        if ((obj = map.get(id)) == null) {
            String xclass = this.m_idClasses == null ? null : this.m_idClasses[index];
            BackFillHolder holder = new BackFillHolder(xclass);
            map.put(id, holder);
            holder.addBackFill(fill);
        } else if (obj instanceof BackFillHolder) {
            ((BackFillHolder)obj).addBackFill(fill);
        } else {
            throw new JiBXException("Internal operation error (back fill error) " + this.buildPositionString());
        }
    }

    public void registerBackFill(int index, BackFillReference fill) throws JiBXException {
        this.registerBackFill(this.m_idref, index, fill);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void defineID(String id, int index, Object obj) throws JiBXException {
        Object prior;
        HashMap<String, Object> map = this.m_idMaps[index];
        if (map == null) {
            this.m_idMaps[index] = map = new HashMap<String, Object>();
        }
        if ((prior = map.put(id, obj)) instanceof BackFillHolder) {
            BackFillHolder holder = (BackFillHolder)prior;
            String xclass = holder.getExpectedClass();
            if (xclass != null && !xclass.equals(obj.getClass().getName())) throw new JiBXException("ID object has wrong type " + this.buildPositionString());
            holder.defineValue(obj);
            return;
        } else {
            if (prior == null) return;
            throw new JiBXException("Duplicate ID definition " + this.buildPositionString());
        }
    }

    protected void mapUnmarshalling(int index) {
        Object value = this.m_unmarshalMap.get(this.m_names[index]);
        if (value instanceof Integer) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            list.add(this.m_indexes[index]);
            this.m_unmarshalMap.put(this.m_names[index], list);
        } else if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            list.add(this.m_indexes[index]);
        } else {
            this.m_unmarshalMap.put(this.m_names[index], this.m_indexes[index]);
        }
    }

    public void addUnmarshalling(int index, String ns, String name, String cname) {
        this.m_namespaces[index] = ns;
        this.m_names[index] = name;
        this.m_unmarshallerClasses[index] = cname;
        if (this.m_unmarshalMap != null && name != null) {
            this.mapUnmarshalling(index);
        }
    }

    public void removeUnmarshalling(int index) {
        if (this.m_unmarshalMap != null && this.m_names[index] != null) {
            Object value = this.m_unmarshalMap.get(this.m_names[index]);
            if (value instanceof Integer) {
                this.m_unmarshalMap.remove(this.m_names[index]);
            } else if (value instanceof ArrayList) {
                ArrayList list = (ArrayList)value;
                list.remove(list.indexOf(this.m_indexes[index]));
            }
        }
        this.m_namespaces[index] = null;
        this.m_names[index] = null;
        this.m_unmarshallers[index] = null;
        this.m_unmarshallerClasses[index] = null;
    }

    public IUnmarshaller getUnmarshaller(int index) throws JiBXException {
        if (this.m_unmarshallers[index] == null) {
            String name = this.m_unmarshallerClasses[index];
            if (name == null) {
                throw new JiBXException("No unmarshaller defined for class at index " + index);
            }
            try {
                IUnmarshaller um;
                Class<?> clas = null;
                ClassLoader factldr = null;
                if (this.m_factory != null) {
                    factldr = this.m_factory.getClass().getClassLoader();
                    try {
                        clas = factldr.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (clas == null) {
                    ClassLoader thisldr;
                    ClassLoader ctxldr = Thread.currentThread().getContextClassLoader();
                    if (ctxldr != null) {
                        try {
                            clas = ctxldr.loadClass(name);
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                    }
                    if (clas == null && (thisldr = (class$org$jibx$runtime$impl$UnmarshallingContext == null ? (class$org$jibx$runtime$impl$UnmarshallingContext = UnmarshallingContext.class$("org.jibx.runtime.impl.UnmarshallingContext")) : class$org$jibx$runtime$impl$UnmarshallingContext).getClassLoader()) != factldr && thisldr != ctxldr) {
                        try {
                            clas = thisldr.loadClass(name);
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                    }
                }
                if (clas == null) {
                    throw new JiBXException("Unable to load unmarshaller class " + name);
                }
                this.m_unmarshallers[index] = um = (IUnmarshaller)clas.newInstance();
            }
            catch (JiBXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JiBXException("Unable to create unmarshaller of class " + name + ":", e);
            }
        }
        return this.m_unmarshallers[index];
    }

    public IUnmarshaller getUnmarshaller(String ns, String name) throws JiBXException {
        Object value;
        if (this.m_unmarshalMap == null) {
            this.m_unmarshalMap = new HashMap();
            this.m_indexes = new Integer[this.m_names.length];
            for (int i = 0; i < this.m_names.length; ++i) {
                this.m_indexes[i] = new Integer(i);
                if (this.m_names[i] == null) continue;
                this.mapUnmarshalling(i);
            }
        }
        if ((value = this.m_unmarshalMap.get(name)) instanceof Integer) {
            int index = (Integer)value;
            String mns = this.m_namespaces[index];
            if (ns == mns || ns == null && mns.length() == 0 || mns == null && ns.length() == 0 || ns != null && ns.equals(mns)) {
                return this.getUnmarshaller(index);
            }
        } else if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            for (int i = 0; i < list.size(); ++i) {
                int index = (Integer)list.get(i);
                String mns = this.m_namespaces[index];
                if (!(ns == mns || ns == null && mns.length() == 0 || mns == null && ns.length() == 0) && (ns == null || !ns.equals(mns))) continue;
                return this.getUnmarshaller(index);
            }
        }
        return null;
    }

    public Object unmarshalOptionalElement() throws JiBXException {
        IUnmarshaller unmarshal;
        int type = this.toTag();
        if (type == 2 && (unmarshal = this.getUnmarshaller(this.m_reader.getNamespace(), this.m_reader.getName())) != null) {
            return unmarshal.unmarshal(null, this);
        }
        return null;
    }

    public Object unmarshalElement(Class clas) throws JiBXException {
        String name = this.toStart();
        IUnmarshaller unmarshal = this.getUnmarshaller(this.m_reader.getNamespace(), name);
        if (unmarshal == null) {
            throw new JiBXException("No unmarshaller for element " + this.currentNameString() + " " + this.buildPositionString());
        }
        Object obj = unmarshal.unmarshal(null, this);
        if (!clas.isInstance(obj)) {
            throw new JiBXException("Element " + name + " not compatible with expected type " + clas.getName() + " " + this.buildPositionString());
        }
        return obj;
    }

    public Object unmarshalElement() throws JiBXException {
        String name = this.toStart();
        IUnmarshaller unmarshal = this.getUnmarshaller(this.m_reader.getNamespace(), name);
        if (unmarshal == null) {
            throw new JiBXException("No unmarshaller for element " + this.currentNameString() + " " + this.buildPositionString());
        }
        return unmarshal.unmarshal(null, this);
    }

    public void parsePastElement(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        int depth = 0;
        while (true) {
            switch (this.m_reader.getEventType()) {
                case 3: {
                    if (depth == 0) {
                        if (this.m_reader.getName().equals(tag) && this.verifyNamespace(ns)) {
                            this.m_reader.nextToken();
                            return;
                        }
                        this.throwEndTagNameError(ns, tag);
                        break;
                    }
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                    break;
                }
            }
            this.m_reader.nextToken();
        }
    }

    public String getElementName() throws JiBXException {
        int type = this.m_reader.getEventType();
        if (type == 2 || type == 3) {
            return this.m_reader.getName();
        }
        return null;
    }

    public String getElementNamespace() throws JiBXException {
        int type = this.m_reader.getEventType();
        if (type == 2 || type == 3) {
            return this.m_reader.getNamespace();
        }
        return null;
    }

    public void throwStartTagException(String msg) throws JiBXException {
        throw new JiBXException(msg + " at tag " + this.currentNameString() + this.buildPositionString());
    }

    public void throwStartTagException(String msg, Exception ex) throws JiBXException {
        throw new JiBXException(msg + " at tag " + this.currentNameString() + this.buildPositionString(), ex);
    }

    public void throwException(String msg) throws JiBXException {
        throw new JiBXException(msg + " " + this.buildPositionString());
    }

    public void throwException(String msg, Exception ex) throws JiBXException {
        throw new JiBXException(msg + " " + this.buildPositionString(), ex);
    }

    public Object unmarshalDocument(InputStream ins, String enc) throws JiBXException {
        this.setDocument(ins, enc);
        return this.unmarshalElement();
    }

    public Object unmarshalDocument(Reader rdr) throws JiBXException {
        this.setDocument(rdr);
        return this.unmarshalElement();
    }

    public Object unmarshalDocument(InputStream ins, String name, String enc) throws JiBXException {
        this.setDocument(ins, name, enc);
        return this.unmarshalElement();
    }

    public Object unmarshalDocument(Reader rdr, String name) throws JiBXException {
        this.setDocument(rdr, name);
        return this.unmarshalElement();
    }

    public IBindingFactory getFactory() {
        return this.m_factory;
    }

    public String getDocumentName() {
        return this.m_reader.getDocumentName();
    }

    public String getInputEncoding() {
        return this.m_reader.getInputEncoding();
    }

    public void setUserContext(Object obj) {
        this.m_userContext = obj;
    }

    public Object getUserContext() {
        return this.m_userContext;
    }

    public void pushObject(Object obj) {
        int depth = this.m_stackDepth;
        if (depth >= this.m_objectStack.length) {
            Object[] stack = new Object[depth * 2];
            System.arraycopy(this.m_objectStack, 0, stack, 0, depth);
            this.m_objectStack = stack;
        }
        this.m_objectStack[depth] = obj;
        ++this.m_stackDepth;
    }

    public void pushTrackedObject(Object obj) {
        this.pushObject(obj);
        if (obj instanceof ITrackSourceImpl) {
            ((ITrackSourceImpl)obj).jibx_setSource(this.m_reader.getDocumentName(), this.m_reader.getLineNumber(), this.m_reader.getColumnNumber());
        }
    }

    public void popObject() throws JiBXException {
        if (this.m_stackDepth > 0) {
            --this.m_stackDepth;
        } else {
            throw new JiBXException("No object on stack");
        }
    }

    public int getStackDepth() {
        return this.m_stackDepth;
    }

    public Object getStackObject(int depth) {
        if (depth >= 0 && depth < this.m_stackDepth) {
            return this.m_objectStack[this.m_stackDepth - depth - 1];
        }
        throw new ArrayIndexOutOfBoundsException("Depth " + depth + " is out of range");
    }

    public Object getStackTop() {
        if (this.m_stackDepth > 0) {
            return this.m_objectStack[this.m_stackDepth - 1];
        }
        return null;
    }

    public int getActiveNamespaceCount() {
        try {
            return this.m_reader.getNamespaceCount(this.m_reader.getNestingDepth());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Internal error: " + e.getMessage());
        }
    }

    public String getActiveNamespaceUri(int index) {
        return this.m_reader.getNamespaceUri(index);
    }

    public String getActiveNamespacePrefix(int index) {
        return this.m_reader.getNamespacePrefix(index);
    }

    public void skipElement() throws JiBXException {
        if (!this.isEnd()) {
            this.next();
            int depth = 1;
            while (depth > 0) {
                depth = this.isEnd() ? --depth : ++depth;
                this.next();
            }
        }
    }

    public int next() throws JiBXException {
        return this.m_reader.next();
    }

    public int nextToken() throws JiBXException {
        return this.m_reader.nextToken();
    }

    public int currentEvent() throws JiBXException {
        return this.m_reader.getEventType();
    }

    public String getName() {
        return this.m_reader.getName();
    }

    public String getNamespace() {
        return this.m_reader.getNamespace();
    }

    public String getPrefix() {
        return this.m_reader.getPrefix();
    }

    public int getAttributeCount() {
        return this.m_reader.getAttributeCount();
    }

    public String getAttributeName(int index) {
        return this.m_reader.getAttributeName(index);
    }

    public String getAttributeNamespace(int index) {
        return this.m_reader.getAttributeNamespace(index);
    }

    public String getAttributePrefix(int index) {
        return this.m_reader.getAttributePrefix(index);
    }

    public String getAttributeValue(int index) {
        return this.m_reader.getAttributeValue(index);
    }

    public int getNamespaceCount() {
        try {
            int level = this.m_reader.getNestingDepth();
            return this.m_reader.getNamespaceCount(level) - this.m_reader.getNamespaceCount(level - 1);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Internal error: " + e.getMessage());
        }
    }

    public String getNamespaceUri(int index) {
        int base = this.m_reader.getNamespaceCount(this.m_reader.getNestingDepth() - 1);
        return this.m_reader.getNamespaceUri(base + index);
    }

    public String getNamespacePrefix(int index) {
        int base = this.m_reader.getNamespaceCount(this.m_reader.getNestingDepth() - 1);
        return this.m_reader.getNamespacePrefix(base + index);
    }

    public String getNamespaceUri(String prefix) {
        return this.m_reader.getNamespace(prefix);
    }

    public String getText() {
        return this.m_reader.getText();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String prop = System.getProperty("org.jibx.runtime.impl.parser");
        if (prop == null) {
            IXMLReaderFactory fact = null;
            try {
                fact = UnmarshallingContext.createReaderFactory("org.jibx.runtime.impl.XMLPullReaderFactory");
            }
            catch (Throwable e) {
                fact = UnmarshallingContext.createReaderFactory("org.jibx.runtime.impl.StAXReaderFactory");
            }
            s_readerFactory = fact;
        } else {
            s_readerFactory = UnmarshallingContext.createReaderFactory(prop);
        }
    }
}

