/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema;

import java.util.HashMap;
import org.jibx.runtime.QName;
import org.jibx.schema.elements.AttributeElement;
import org.jibx.schema.elements.AttributeGroupElement;
import org.jibx.schema.elements.CommonTypeDefinition;
import org.jibx.schema.elements.ElementElement;
import org.jibx.schema.elements.GroupElement;
import org.jibx.schema.support.SchemaTypes;

public class NameRegister {
    private HashMap m_globalAttributeMap = new HashMap();
    private HashMap m_importedAttributeMap;
    private HashMap m_globalAttributeGroupMap = new HashMap();
    private HashMap m_importedAttributeGroupMap;
    private HashMap m_globalElementMap = new HashMap();
    private HashMap m_importedElementMap;
    private HashMap m_globalGroupMap = new HashMap();
    private HashMap m_importedGroupMap;
    private HashMap m_globalTypeMap = new HashMap();
    private HashMap m_importedTypeMap;

    public void reset() {
        this.m_globalAttributeMap.clear();
        this.m_globalAttributeGroupMap.clear();
        this.m_globalElementMap.clear();
        this.m_globalGroupMap.clear();
        this.m_globalTypeMap.clear();
    }

    public AttributeElement registerAttribute(QName qname, AttributeElement def) {
        return this.m_globalAttributeMap.put(qname, def);
    }

    public AttributeGroupElement registerAttributeGroup(QName qname, AttributeGroupElement def) {
        return this.m_globalAttributeGroupMap.put(qname, def);
    }

    public ElementElement registerElement(QName qname, ElementElement def) {
        return this.m_globalElementMap.put(qname, def);
    }

    public GroupElement registerGroup(QName qname, GroupElement def) {
        return this.m_globalGroupMap.put(qname, def);
    }

    public CommonTypeDefinition registerType(QName qname, CommonTypeDefinition def) {
        return this.m_globalTypeMap.put(qname, def);
    }

    private Object findInMaps(Object key, HashMap map1, HashMap map2) {
        Object obj = map1.get(key);
        if (obj == null && map2 != null) {
            obj = map2.get(key);
        }
        return obj;
    }

    public AttributeElement findAttribute(QName qname) {
        return (AttributeElement)this.findInMaps(qname, this.m_globalAttributeMap, this.m_importedAttributeMap);
    }

    public AttributeGroupElement findAttributeGroup(QName qname) {
        AttributeGroupElement agrp = (AttributeGroupElement)this.m_globalAttributeGroupMap.get(qname);
        if (agrp == null && this.m_importedAttributeGroupMap != null) {
            agrp = (AttributeGroupElement)this.m_importedAttributeGroupMap.get(qname);
        }
        return agrp;
    }

    public ElementElement findElement(QName qname) {
        ElementElement elem = (ElementElement)this.m_globalElementMap.get(qname);
        if (elem == null && this.m_importedElementMap != null) {
            elem = (ElementElement)this.m_importedElementMap.get(qname);
        }
        return elem;
    }

    public GroupElement findGroup(QName qname) {
        GroupElement grp = (GroupElement)this.m_globalGroupMap.get(qname);
        if (grp == null && this.m_importedGroupMap != null) {
            grp = (GroupElement)this.m_importedGroupMap.get(qname);
        }
        return grp;
    }

    public CommonTypeDefinition findType(QName qname) {
        if ("http://www.w3.org/2001/XMLSchema".equals(qname.getUri())) {
            return SchemaTypes.getSchemaType(qname.getName());
        }
        CommonTypeDefinition type = (CommonTypeDefinition)this.m_globalTypeMap.get(qname);
        if (type == null && this.m_importedTypeMap != null) {
            type = (CommonTypeDefinition)this.m_importedTypeMap.get(qname);
        }
        return type;
    }

    public void mergeDefinitions(NameRegister mrg) {
        this.m_globalAttributeMap.putAll(mrg.m_globalAttributeMap);
        this.m_globalAttributeGroupMap.putAll(mrg.m_globalAttributeGroupMap);
        this.m_globalElementMap.putAll(mrg.m_globalElementMap);
        this.m_globalGroupMap.putAll(mrg.m_globalGroupMap);
        this.m_globalTypeMap.putAll(mrg.m_globalTypeMap);
    }

    private void mergeMapNamespaced(String uri, HashMap source, HashMap target) {
        if (!source.isEmpty()) {
            for (QName oldname : source.keySet()) {
                QName newname = new QName(uri, oldname.getName());
                target.put(newname, source.get(oldname));
            }
        }
    }

    public void mergeDefinitionsNamespaced(String uri, NameRegister mrg) {
        this.mergeMapNamespaced(uri, mrg.m_globalAttributeMap, this.m_globalAttributeMap);
        this.mergeMapNamespaced(uri, mrg.m_globalAttributeGroupMap, this.m_globalAttributeGroupMap);
        this.mergeMapNamespaced(uri, mrg.m_globalElementMap, this.m_globalElementMap);
        this.mergeMapNamespaced(uri, mrg.m_globalGroupMap, this.m_globalGroupMap);
        this.mergeMapNamespaced(uri, mrg.m_globalTypeMap, this.m_globalTypeMap);
    }

    private HashMap mergeLazyMap(HashMap source, HashMap target) {
        if (!source.isEmpty()) {
            if (target == null) {
                return new HashMap(source);
            }
            target.putAll(source);
            return target;
        }
        return target;
    }

    public void mergeImportedDefinitions(NameRegister mrg) {
        this.m_importedAttributeMap = this.mergeLazyMap(mrg.m_globalAttributeMap, this.m_importedAttributeMap);
        this.m_importedAttributeGroupMap = this.mergeLazyMap(mrg.m_globalAttributeGroupMap, this.m_importedAttributeGroupMap);
        this.m_importedElementMap = this.mergeLazyMap(mrg.m_globalElementMap, this.m_importedElementMap);
        this.m_importedGroupMap = this.mergeLazyMap(mrg.m_globalGroupMap, this.m_importedGroupMap);
        this.m_importedTypeMap = this.mergeLazyMap(mrg.m_globalTypeMap, this.m_importedTypeMap);
    }
}

