/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema;

import java.util.HashSet;
import java.util.Set;
import org.jibx.binding.util.ObjectStack;
import org.jibx.schema.ISchemaListener;
import org.jibx.schema.NameRegister;
import org.jibx.schema.elements.SchemaElement;

public class SchemaContextTracker
implements ISchemaListener {
    protected NameRegister m_nameRegister;
    private final Set m_traversedSchemas = new HashSet();
    private final ObjectStack m_schemaStack = new ObjectStack();

    public NameRegister getNameRegister() {
        if (this.m_nameRegister == null) {
            throw new IllegalStateException("Internal error: name register has not been set");
        }
        return this.m_nameRegister;
    }

    public void setNameRegister(NameRegister reg) {
        this.m_nameRegister = reg;
    }

    public SchemaElement getCurrentSchema() {
        if (this.m_schemaStack.size() == 0) {
            throw new IllegalStateException("Internal error: schema has not been set");
        }
        return (SchemaElement)this.m_schemaStack.peek();
    }

    public void clearTraversed() {
        this.m_traversedSchemas.clear();
    }

    @Override
    public boolean enterSchema(SchemaElement schema) {
        if (this.m_traversedSchemas.contains(schema)) {
            return false;
        }
        this.m_traversedSchemas.add(schema);
        this.m_schemaStack.push((Object)schema);
        this.m_nameRegister = schema.getRegister();
        return true;
    }

    @Override
    public void exitSchema() {
        this.m_schemaStack.pop();
        if (this.m_schemaStack.size() > 0) {
            this.m_nameRegister = ((SchemaElement)this.m_schemaStack.peek()).getRegister();
        }
    }
}

