/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.util.HashSet;

public class NameUtils {
    private static final HashSet s_reservedWords = new HashSet();
    private static final HashSet s_defaultImportClassNames;

    public static boolean isReserved(String name) {
        return s_reservedWords.contains(name);
    }

    public static boolean isDefaultImport(String name) {
        return s_defaultImportClassNames.contains(name);
    }

    public static String sanitizePackageName(String raw) {
        StringBuffer buff = new StringBuffer(raw.length());
        boolean first = true;
        int i = 0;
        while (i < raw.length()) {
            char chr = buff.charAt(i);
            if (first) {
                if (Character.isJavaIdentifierStart(chr)) {
                    first = false;
                    ++i;
                    continue;
                }
                buff.deleteCharAt(i);
                continue;
            }
            if (chr == '.') {
                first = true;
                ++i;
                continue;
            }
            if (!Character.isJavaIdentifierPart(chr)) {
                buff.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        return buff.toString();
    }

    public static String toNameWord(String word) {
        char chr;
        while ((chr = word.charAt(0)) == '_' && word.length() > 1) {
            word = word.substring(1);
        }
        if (Character.isLowerCase(chr)) {
            StringBuffer buff = new StringBuffer(word);
            buff.setCharAt(0, Character.toUpperCase(chr));
            word = buff.toString();
        }
        if ("Class".equals(word)) {
            return "_Class";
        }
        if (Character.isDigit(word.charAt(0))) {
            return "_" + word;
        }
        return word;
    }

    public static String toNameLead(String word) {
        char chr = word.charAt(0);
        if (Character.isUpperCase(chr) && (word.length() < 2 || Character.isLowerCase(word.charAt(1)))) {
            StringBuffer buff = new StringBuffer(word);
            buff.setCharAt(0, Character.toLowerCase(chr));
            return buff.toString();
        }
        return word;
    }

    static {
        s_reservedWords.add("abstract");
        s_reservedWords.add("assert");
        s_reservedWords.add("boolean");
        s_reservedWords.add("break");
        s_reservedWords.add("byte");
        s_reservedWords.add("case");
        s_reservedWords.add("catch");
        s_reservedWords.add("char");
        s_reservedWords.add("class");
        s_reservedWords.add("const");
        s_reservedWords.add("continue");
        s_reservedWords.add("default");
        s_reservedWords.add("do");
        s_reservedWords.add("double");
        s_reservedWords.add("else");
        s_reservedWords.add("enum");
        s_reservedWords.add("extends");
        s_reservedWords.add("final");
        s_reservedWords.add("finally");
        s_reservedWords.add("float");
        s_reservedWords.add("for");
        s_reservedWords.add("goto");
        s_reservedWords.add("if");
        s_reservedWords.add("implements");
        s_reservedWords.add("import");
        s_reservedWords.add("instanceof");
        s_reservedWords.add("int");
        s_reservedWords.add("interface");
        s_reservedWords.add("long");
        s_reservedWords.add("native");
        s_reservedWords.add("new");
        s_reservedWords.add("package");
        s_reservedWords.add("private");
        s_reservedWords.add("protected");
        s_reservedWords.add("public");
        s_reservedWords.add("return");
        s_reservedWords.add("short");
        s_reservedWords.add("static");
        s_reservedWords.add("strictfp");
        s_reservedWords.add("super");
        s_reservedWords.add("switch");
        s_reservedWords.add("synchronized");
        s_reservedWords.add("this");
        s_reservedWords.add("throw");
        s_reservedWords.add("throws");
        s_reservedWords.add("transient");
        s_reservedWords.add("try");
        s_reservedWords.add("void");
        s_reservedWords.add("volatile");
        s_reservedWords.add("while");
        s_reservedWords.add("true");
        s_reservedWords.add("false");
        s_reservedWords.add("null");
        s_defaultImportClassNames = new HashSet();
        s_defaultImportClassNames.add("Appendable");
        s_defaultImportClassNames.add("CharSequence");
        s_defaultImportClassNames.add("Cloneable");
        s_defaultImportClassNames.add("Comparable");
        s_defaultImportClassNames.add("Iterable");
        s_defaultImportClassNames.add("Readable");
        s_defaultImportClassNames.add("Runnable");
        s_defaultImportClassNames.add("Boolean");
        s_defaultImportClassNames.add("Byte");
        s_defaultImportClassNames.add("Character");
        s_defaultImportClassNames.add("Class");
        s_defaultImportClassNames.add("ClassLoader");
        s_defaultImportClassNames.add("Double");
        s_defaultImportClassNames.add("Enum");
        s_defaultImportClassNames.add("Float");
        s_defaultImportClassNames.add("Integer");
        s_defaultImportClassNames.add("Long");
        s_defaultImportClassNames.add("Math");
        s_defaultImportClassNames.add("Number");
        s_defaultImportClassNames.add("Object");
        s_defaultImportClassNames.add("Package");
        s_defaultImportClassNames.add("Short");
        s_defaultImportClassNames.add("String");
        s_defaultImportClassNames.add("StringBuffer");
        s_defaultImportClassNames.add("StringBuilder");
        s_defaultImportClassNames.add("System");
        s_defaultImportClassNames.add("Thread");
        s_defaultImportClassNames.add("Throwable");
        s_defaultImportClassNames.add("Void");
        s_defaultImportClassNames.add("Exception");
        s_defaultImportClassNames.add("Error");
    }
}

