/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.wsdl.tools.custom;

import java.util.Collection;
import java.util.List;
import org.jibx.custom.classes.CustomBase;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.jibx.util.IClass;
import org.jibx.util.IClassItem;
import org.jibx.util.IClassLocator;
import org.jibx.util.Types;
import org.jibx.ws.wsdl.tools.custom.NestingBase;
import org.jibx.ws.wsdl.tools.custom.OperationCustom;

public class FaultCustom
extends CustomBase {
    private String m_exceptionType;
    private String m_fieldName;
    private String m_dataType;
    private String m_faultName;
    private String m_elementName;
    private List m_documentation;

    protected FaultCustom(NestingBase parent, String type) {
        super(parent);
        this.m_exceptionType = type;
    }

    public String getExceptionType() {
        return this.m_exceptionType;
    }

    public String getFaultName() {
        return this.m_faultName;
    }

    public String getElementName() {
        return this.m_elementName;
    }

    public String getDataType() {
        return this.m_dataType;
    }

    public List getDocumentation() {
        return this.m_documentation;
    }

    public void apply(IClassLocator icl) {
        String simple = this.m_exceptionType.substring(this.m_exceptionType.lastIndexOf(46) + 1);
        if (simple.endsWith("Exception")) {
            simple = simple.substring(0, simple.length() - 9);
        }
        if (this.m_elementName == null) {
            this.m_elementName = this.getParent().convertName(simple);
        }
        if (this.m_faultName == null) {
            this.m_faultName = this.m_elementName + "Fault";
        }
        IClass clas = icl.getRequiredClassInfo(this.m_exceptionType);
        if (this.m_fieldName == null) {
            IClassItem[] fields = clas.getFields();
            for (int i = 0; i < fields.length; ++i) {
                IClass info;
                IClassItem item = fields[i];
                String type = item.getTypeName();
                if (Types.isSimpleValue((String)type) || !(info = icl.getRequiredClassInfo(type)).isModifiable()) continue;
                this.m_fieldName = item.getName();
                this.m_dataType = type;
                break;
            }
            if (this.m_fieldName == null) {
                throw new IllegalStateException("No data object field found for exception class " + this.m_exceptionType);
            }
        } else {
            IClassItem field = clas.getField(this.m_fieldName);
            if (field == null) {
                throw new IllegalStateException("Field " + this.m_fieldName + " not found in exception class " + this.m_exceptionType);
            }
            this.m_dataType = field.getTypeName();
        }
    }

    private static FaultCustom throwsFactory(IUnmarshallingContext ictx) throws JiBXException {
        UnmarshallingContext uctx = (UnmarshallingContext)ictx;
        Object parent = uctx.getStackTop();
        int depth = 0;
        if (parent instanceof Collection) {
            parent = uctx.getStackObject(++depth);
        }
        return new FaultCustom((OperationCustom)parent, uctx.attributeText(null, "class"));
    }
}

