/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen.extend;

import java.util.ArrayList;
import org.jibx.schema.codegen.NameUtils;
import org.jibx.schema.codegen.extend.NameConverter;
import org.jibx.util.NameUtilities;

public class DefaultNameConverter
implements NameConverter {
    private boolean m_camelCase;
    private String m_fieldPrefix;
    private String m_fieldSuffix;
    private String m_staticPrefix;
    private String m_staticSuffix;
    private boolean m_underscore;
    private boolean m_upperInitial;
    private String[] m_stripPrefixes;
    private String[] m_stripSuffixes;
    private ArrayList m_wordList;

    public DefaultNameConverter() {
        this.m_fieldPrefix = "";
        this.m_fieldSuffix = "";
        this.m_staticPrefix = "";
        this.m_staticSuffix = "";
        this.m_camelCase = true;
        this.m_stripSuffixes = new String[0];
        this.m_stripPrefixes = this.m_stripSuffixes;
        this.m_wordList = new ArrayList();
    }

    public DefaultNameConverter(DefaultNameConverter base) {
        this.m_fieldPrefix = base.m_fieldPrefix;
        this.m_fieldSuffix = base.m_fieldSuffix;
        this.m_staticPrefix = base.m_staticPrefix;
        this.m_staticSuffix = base.m_staticSuffix;
        this.m_camelCase = base.m_camelCase;
        this.m_stripPrefixes = base.m_stripPrefixes;
        this.m_stripSuffixes = base.m_stripSuffixes;
        this.m_wordList = new ArrayList();
    }

    @Override
    public String pluralize(String name) {
        return NameUtilities.pluralize((String)name);
    }

    @Override
    public String depluralize(String name) {
        return NameUtilities.depluralize((String)name);
    }

    public String getFieldPrefix() {
        return this.m_fieldPrefix;
    }

    public void setFieldPrefix(String pref) {
        this.m_fieldPrefix = pref;
    }

    public String getFieldSuffix() {
        return this.m_fieldPrefix;
    }

    public void setFieldSuffix(String suff) {
        this.m_fieldPrefix = suff;
    }

    public String getStaticPrefix() {
        return this.m_staticPrefix;
    }

    public void setStaticPrefix(String pref) {
        this.m_staticPrefix = pref;
    }

    public String getStaticSuffix() {
        return this.m_staticPrefix;
    }

    public void setStaticSuffix(String suff) {
        this.m_staticPrefix = suff;
    }

    public String[] getStripPrefixes() {
        return this.m_stripPrefixes;
    }

    public void setStripPrefixes(String[] prefixes) {
        this.m_stripPrefixes = prefixes;
    }

    public String[] getStripSuffixes() {
        return this.m_stripSuffixes;
    }

    public void setStripSuffixes(String[] suffixes) {
        this.m_stripSuffixes = suffixes;
    }

    @Override
    public String trimXName(String xname) {
        int i;
        for (i = 0; i < this.m_stripPrefixes.length; ++i) {
            String prefix = this.m_stripPrefixes[i];
            if (!xname.startsWith(prefix) || xname.length() <= prefix.length()) continue;
            xname = xname.substring(prefix.length());
            break;
        }
        for (i = 0; i < this.m_stripSuffixes.length; ++i) {
            String suffix = this.m_stripSuffixes[i];
            if (!xname.endsWith(suffix) || xname.length() <= suffix.length()) continue;
            xname = xname.substring(0, xname.length() - suffix.length());
            break;
        }
        return xname;
    }

    @Override
    public String[] splitXMLWords(String name) {
        int offset = 0;
        while (!Character.isJavaIdentifierStart(name.charAt(offset))) {
            if (++offset < name.length()) continue;
            return new String[0];
        }
        StringBuffer word = new StringBuffer();
        this.m_wordList.clear();
        boolean lastupper = false;
        while (offset < name.length()) {
            char chr;
            if ((chr = name.charAt(offset++)) == '-' || chr == '.' || chr == '_') {
                if (word.length() <= 0) continue;
                this.m_wordList.add(word.toString());
                word.setLength(0);
                continue;
            }
            if (!Character.isJavaIdentifierPart(chr)) continue;
            if (Character.isUpperCase(chr)) {
                if (!lastupper && word.length() > 0) {
                    this.m_wordList.add(word.toString());
                    word.setLength(0);
                }
                lastupper = true;
            } else {
                if (lastupper) {
                    if (word.length() > 1) {
                        int split = word.length() - 1;
                        this.m_wordList.add(word.substring(0, split));
                        char start = Character.toLowerCase(word.charAt(split));
                        word.setLength(0);
                        word.append(start);
                    } else if (word.length() > 0) {
                        word.setCharAt(0, Character.toLowerCase(word.charAt(0)));
                    }
                }
                lastupper = false;
            }
            word.append(chr);
        }
        if (word.length() > 0) {
            this.m_wordList.add(word.toString());
        }
        return this.m_wordList.toArray(new String[this.m_wordList.size()]);
    }

    protected static boolean isConversionNeeded(String name) {
        int length = name.length();
        if (length > 0 && Character.isJavaIdentifierStart(name.charAt(0))) {
            for (int i = 1; i < length; ++i) {
                char chr = name.charAt(i);
                if (chr != '_' && Character.isJavaIdentifierPart(chr)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public String toJavaClassName(String name) {
        char chr;
        int index = 0;
        while ((chr = name.charAt(index)) == '_') {
            ++index;
        }
        if (Character.isLowerCase(chr)) {
            name = name.substring(0, index) + Character.toUpperCase(chr) + name.substring(index + 1);
        }
        while (NameUtils.isDefaultImport(name)) {
            name = "_" + name;
        }
        return name;
    }

    @Override
    public String toBaseName(String xname) {
        String name = this.trimXName(xname);
        if (DefaultNameConverter.isConversionNeeded(name) || Character.isUpperCase(name.charAt(0))) {
            String[] words = this.splitXMLWords(name);
            if (words.length == 0) {
                return "x";
            }
            if (words.length == 0) {
                words = new String[]{"_"};
            }
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < words.length; ++i) {
                String word = words[i];
                if (i > 0 && this.m_underscore) {
                    buff.append('_');
                }
                if (i == 0 && this.m_upperInitial || i > 0 && this.m_camelCase) {
                    buff.append(Character.toUpperCase(word.charAt(0)));
                    if (word.length() <= 1) continue;
                    buff.append(word.substring(1, word.length()));
                    continue;
                }
                buff.append(word);
            }
            name = buff.toString();
        }
        return name;
    }

    @Override
    public String toConstantName(String text) {
        String name;
        StringBuffer buff = new StringBuffer(text.length());
        boolean lastup = false;
        boolean multup = false;
        char lastchar = '\u0000';
        for (int index = 0; index < text.length(); ++index) {
            char chr = text.charAt(index);
            if (index == 0 && !Character.isJavaIdentifierStart(chr)) {
                buff.append('_');
            }
            if (!Character.isJavaIdentifierPart(chr)) continue;
            if (lastup) {
                if (Character.isUpperCase(chr)) {
                    multup = true;
                } else {
                    lastup = false;
                    if (chr == '_') {
                        multup = false;
                    } else if (multup) {
                        buff.insert(buff.length() - 1, '_');
                        multup = false;
                    }
                }
            } else if (Character.isUpperCase(chr)) {
                if (index > 0 && lastchar != '_') {
                    buff.append('_');
                }
                lastup = true;
                multup = false;
            }
            lastchar = Character.toUpperCase(chr);
            buff.append(lastchar);
        }
        if (buff.length() == 0) {
            buff.append('_');
        }
        if (NameUtils.isReserved(name = buff.toString())) {
            name = "_" + name;
        }
        return name;
    }

    private String buildFieldName(String base, String prefix, String suffix) {
        boolean toupper;
        String name = base;
        int added = prefix.length() + suffix.length();
        boolean bl = toupper = this.m_upperInitial && !Character.isUpperCase(name.charAt(0));
        if (added == 0) {
            if (toupper) {
                StringBuffer buff = new StringBuffer(name);
                buff.setCharAt(0, Character.toUpperCase(buff.charAt(0)));
                name = buff.toString();
            }
        } else {
            StringBuffer buff = new StringBuffer(name.length() + added);
            buff.append(prefix);
            int offset = buff.length();
            buff.append(name);
            if (toupper) {
                buff.setCharAt(offset, Character.toUpperCase(name.charAt(0)));
            }
            buff.append(suffix);
            name = buff.toString();
        }
        if (NameUtils.isReserved(name)) {
            name = "_" + name;
        }
        return name;
    }

    @Override
    public String toFieldName(String base) {
        String prefix = this.m_fieldPrefix;
        String suffix = this.m_fieldSuffix;
        return this.buildFieldName(base, prefix, suffix);
    }

    @Override
    public String toStaticFieldName(String base) {
        String prefix = this.m_staticPrefix;
        String suffix = this.m_staticSuffix;
        return this.buildFieldName(base, prefix, suffix);
    }

    @Override
    public String toPropertyName(String base) {
        if (!Character.isUpperCase(base.charAt(0))) {
            StringBuffer buff = new StringBuffer(base);
            buff.setCharAt(0, Character.toUpperCase(buff.charAt(0)));
            return buff.toString();
        }
        return base;
    }

    @Override
    public String toReadAccessMethodName(String prop) {
        return "get" + prop;
    }

    @Override
    public String toWriteAccessMethodName(String prop) {
        return "set" + prop;
    }

    @Override
    public String toTestAccessMethodName(String prop) {
        return "is" + prop;
    }

    @Override
    public String toIfSetAccessMethodName(String prop) {
        return "if" + prop;
    }
}

