/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.generator;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jibx.custom.CustomizationCommandLineBase;
import org.jibx.custom.classes.ClassCustomizationBase;
import org.jibx.custom.classes.GlobalCustom;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.schema.validation.ValidationContext;
import org.jibx.util.IClassLocator;
import org.jibx.util.ReflectionUtilities;

public class SchemaGenCommandLine
extends ClassCustomizationBase {
    private static final String[] EXTRA_USAGE_LINES = new String[]{" -n uri=name,... schema namespace URI and file name pairs (default generates\n          file names from URIs)"};
    private GlobalCustom m_global;
    private Map m_uriNames = new HashMap();
    private IClassLocator m_locator;

    public SchemaGenCommandLine() {
        super(EXTRA_USAGE_LINES);
    }

    protected SchemaGenCommandLine(String[] lines) {
        super(SchemaGenCommandLine.mergeUsageLines(lines, EXTRA_USAGE_LINES));
    }

    public IClassLocator getLocator() {
        return this.m_locator;
    }

    protected void setLocator(IClassLocator locator) {
        this.m_locator = locator;
    }

    public GlobalCustom getGlobal() {
        return this.m_global;
    }

    public Map getUriNames() {
        return this.m_uriNames;
    }

    private boolean addUriNamePair(String text) {
        int split = text.indexOf(61);
        if (split >= 0) {
            String key = text.substring(split);
            if (this.m_uriNames.containsKey(key)) {
                System.err.println("Duplicate namespace URI for uri=name parameter: " + key);
            } else {
                this.m_uriNames.put(key, text.substring(split + 1));
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean checkParameter(CustomizationCommandLineBase.ArgList alist) {
        boolean match = true;
        String arg = alist.current();
        if ("-n".equalsIgnoreCase(arg)) {
            int split;
            String text = alist.next();
            int base = 0;
            boolean valid = true;
            while ((split = text.indexOf(44, base)) >= 0) {
                valid = this.addUriNamePair(text.substring(base, split)) && valid;
                base = split + 1;
            }
            boolean bl = valid = this.addUriNamePair(text.substring(base)) && valid;
            if (!valid) {
                alist.setValid(false);
            }
        } else {
            match = super.checkParameter(alist);
        }
        return match;
    }

    @Override
    protected void loadCustomizations(String path, IClassLocator loc, ValidationContext vctx) throws JiBXException, IOException {
        this.m_global = new GlobalCustom(loc);
        this.m_global.setNamespaceStyle(new Integer(2));
        if (path != null) {
            IBindingFactory fact = BindingDirectory.getFactory((String)"class-customs-binding", GlobalCustom.class);
            IUnmarshallingContext ictx = fact.createUnmarshallingContext();
            FileInputStream is = new FileInputStream(path);
            ictx.setDocument((InputStream)is, null);
            ictx.setUserContext((Object)vctx);
            ((IUnmarshallable)this.m_global).unmarshal(ictx);
        }
        this.setLocator(loc);
    }

    @Override
    protected Map applyOverrides(Map overmap) {
        Map unknowns = ReflectionUtilities.applyKeyValueMap((Map)overmap, (Object)this.m_global);
        this.m_global.initClasses();
        this.m_global.fillClasses();
        return unknowns;
    }

    @Override
    public void printUsage() {
        System.out.println("\nUsage: java org.jibx.schema.generator.SchemaGen [options] binding1 binding2 ...\nwhere options are:");
        String[] usages = this.getUsageLines();
        for (int i = 0; i < usages.length; ++i) {
            System.out.println(usages[i]);
        }
        System.out.println("The binding# files are different bindings to be included in the schema(s).\nBindings referenced (using <include>) by the specified bindings will also be\nincluded.");
    }
}

