/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jibx.extras.DocumentComparator;
import org.jibx.extras.TestMultRoundtrip;
import org.jibx.extras.TestRoundtrip;
import org.jibx.maven.AbstractJibxMojo;
import org.jibx.runtime.JiBXException;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentCompareMojo
extends AbstractJibxMojo {
    private String mappedClass;
    private String inFile;
    private String outFile;
    private String xmlDirectory;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        block16: {
            Throwable cause;
            this.checkConfiguration();
            if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
                this.getLog().info((CharSequence)"JiBX document compare does not run for pom packaging");
                return;
            }
            this.inFile = this.fixFilePath(this.inFile, null);
            if (this.outFile != null) {
                String defaultOutPath = null;
                if (!this.outFile.contains(File.pathSeparator) && !this.outFile.contains("/")) {
                    File fileIn = new File(this.inFile);
                    defaultOutPath = fileIn.getParent();
                }
                this.outFile = this.fixFilePath(this.outFile, defaultOutPath);
            }
            if (this.mappedClass != null) {
                ClassLoader parent = this.addTestClasspath();
                try {
                    if (this.outFile == null) {
                        this.outFile = this.inFile;
                    }
                    if (!MyTestRoundtrip.runTest(this.mappedClass, null, this.inFile, this.outFile)) {
                        throw new MojoExecutionException("Class did not round-trip document on document-compare");
                    }
                    break block16;
                }
                catch (Exception e) {
                    Throwable cause2 = e.getCause() != null ? e.getCause() : e;
                    throw new MojoExecutionException(cause2.getLocalizedMessage(), cause2);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(parent);
                }
            }
            if (this.outFile == null) {
                this.getLog().info((CharSequence)"For JiBX document compare you must supply two documents or a class and a document");
                return;
            }
            try {
                File fileIn = new File(this.inFile);
                File fileOut = new File(this.outFile);
                FileReader brdr = new FileReader(fileIn);
                FileReader frdr = new FileReader(fileOut);
                DocumentComparator comp = new DocumentComparator(System.err);
                if (!comp.compare((Reader)frdr, (Reader)brdr)) {
                    throw new MojoExecutionException("Documents are not equal on document-compare");
                }
                this.getLog().info((CharSequence)"JiBX document compare successful");
            }
            catch (XmlPullParserException e) {
                cause = e.getCause() != null ? e.getCause() : e;
                throw new MojoExecutionException(cause.getLocalizedMessage(), cause);
            }
            catch (FileNotFoundException e) {
                cause = e.getCause() != null ? e.getCause() : e;
                throw new MojoExecutionException(cause.getLocalizedMessage(), cause);
            }
        }
    }

    @Override
    protected void checkConfiguration() {
        super.checkConfiguration();
    }

    private ClassLoader addTestClasspath() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        List list = null;
        try {
            list = this.project.getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            e.printStackTrace();
        }
        if (list == null || list.size() == 0) {
            return oldClassLoader;
        }
        ClassLoader parent = oldClassLoader;
        try {
            URL[] urls = new URL[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                urls[i] = new File(((String)list.get(i)).toString()).toURI().toURL();
            }
            if (parent == null) {
                parent = TestMultRoundtrip.class.getClassLoader();
            }
            URLClassLoader loader = new URLClassLoader(urls, parent);
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        return oldClassLoader;
    }

    protected String getXmlDirectory() {
        return this.xmlDirectory;
    }

    @Override
    String getDefaultSchemaBindingDirectory() {
        return this.xmlDirectory;
    }

    @Override
    protected Set<String> getProjectCompileClasspathElements(MavenProject project) throws MojoExecutionException {
        try {
            return new HashSet<String>(project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public static class MyTestRoundtrip
    extends TestRoundtrip {
        public static boolean runTest(String mname, String bname, String fin, String fout) throws IOException, JiBXException, XmlPullParserException {
            return TestRoundtrip.runTest((String)mname, (String)bname, (String)fin, (String)fout);
        }
    }
}

