/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import org.jmxtrans.embedded.EmbeddedJmxTransMBean;
import org.jmxtrans.embedded.Query;
import org.jmxtrans.embedded.output.OutputWriter;
import org.jmxtrans.embedded.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedJmxTrans
implements EmbeddedJmxTransMBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private State state = State.STOPPED;
    private final ReadWriteLock lifecycleLock = new ReentrantReadWriteLock();
    private ScheduledExecutorService collectScheduledExecutor;
    private ScheduledExecutorService exportScheduledExecutor;
    @Nonnull
    private MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    @Nonnull
    private final List<Query> queries = new ArrayList<Query>();
    private Set<OutputWriter> outputWriters = new HashSet<OutputWriter>();
    private int numQueryThreads = 1;
    private int numExportThreads = 1;
    private int queryIntervalInSeconds = 30;
    private int exportIntervalInSeconds = 5;
    private int exportBatchSize = 50;
    private EmbeddedJmxTransShutdownHook shutdownHook;

    public EmbeddedJmxTrans() {
    }

    public EmbeddedJmxTrans(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    @Override
    @PostConstruct
    public void start() throws Exception {
        this.lifecycleLock.writeLock().lock();
        try {
            if (!State.STOPPED.equals((Object)this.state)) {
                this.logger.warn("Ignore start() command for {} instance", (Object)this.state);
                return;
            }
            this.logger.info("Start...");
            for (final Query query : this.queries) {
                query.start();
            }
            for (OutputWriter outputWriter : this.outputWriters) {
                outputWriter.start();
            }
            this.collectScheduledExecutor = Executors.newScheduledThreadPool(this.getNumQueryThreads(), new NamedThreadFactory("jmxtrans-collect-", true));
            this.exportScheduledExecutor = Executors.newScheduledThreadPool(this.getNumExportThreads(), new NamedThreadFactory("jmxtrans-export-", true));
            this.logger.info("Start queries and output writers...");
            for (final Query query : this.getQueries()) {
                this.collectScheduledExecutor.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        EmbeddedJmxTrans.this.lifecycleLock.readLock().lock();
                        try {
                            if (!State.STARTED.equals((Object)EmbeddedJmxTrans.this.state)) {
                                EmbeddedJmxTrans.this.logger.debug("Ignore query.collectMetrics() command for {} instance", (Object)EmbeddedJmxTrans.this.state);
                                return;
                            }
                            query.collectMetrics();
                        }
                        finally {
                            EmbeddedJmxTrans.this.lifecycleLock.readLock().unlock();
                        }
                    }

                    public String toString() {
                        return "Collector[" + query + "]";
                    }
                }, 0L, this.getQueryIntervalInSeconds(), TimeUnit.SECONDS);
                this.exportScheduledExecutor.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        EmbeddedJmxTrans.this.lifecycleLock.readLock().lock();
                        try {
                            if (!State.STARTED.equals((Object)EmbeddedJmxTrans.this.state)) {
                                EmbeddedJmxTrans.this.logger.debug("Ignore query.exportCollectedMetrics() command for {} instance", (Object)EmbeddedJmxTrans.this.state);
                                return;
                            }
                            query.exportCollectedMetrics();
                        }
                        finally {
                            EmbeddedJmxTrans.this.lifecycleLock.readLock().unlock();
                        }
                    }

                    public String toString() {
                        return "Exporter[" + query + "]";
                    }
                }, this.getQueryIntervalInSeconds() + 1, this.getExportIntervalInSeconds(), TimeUnit.SECONDS);
            }
            this.shutdownHook = new EmbeddedJmxTransShutdownHook();
            this.shutdownHook.registerToRuntime();
            this.state = State.STARTED;
            this.logger.info("EmbeddedJmxTrans started");
        }
        catch (RuntimeException e) {
            this.state = State.ERROR;
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("Exception starting EmbeddedJmxTrans", (Throwable)e);
            }
            throw e;
        }
        finally {
            this.lifecycleLock.writeLock().unlock();
        }
    }

    @Override
    @PreDestroy
    public void stop() {
        this.logger.info("Stop...");
        this.lifecycleLock.writeLock().lock();
        try {
            if (!State.STARTED.equals((Object)this.state)) {
                this.logger.debug("Ignore stop() command for " + (Object)((Object)this.state) + " instance");
                return;
            }
            this.logger.info("Unregister shutdown hook");
            this.shutdownHook.unregisterFromRuntime();
            this.logger.info("Shutdown collectScheduledExecutor and exportScheduledExecutor...");
            this.collectScheduledExecutor.shutdownNow();
            this.exportScheduledExecutor.shutdownNow();
            try {
                this.logger.info("Collect metrics...");
                this.collectMetrics();
                this.logger.info("Export metrics...");
                this.exportCollectedMetrics();
            }
            catch (RuntimeException e) {
                this.logger.warn("Ignore failure collecting and exporting metrics during stop", (Throwable)e);
            }
            this.logger.info("Stop queries...");
            for (Query query : this.queries) {
                try {
                    query.stop();
                }
                catch (Exception e) {
                    this.logger.warn("Ignore exception stopping query {}", (Object)query, (Object)e);
                }
            }
            this.logger.info("Stop output writers...");
            for (OutputWriter outputWriter : this.outputWriters) {
                try {
                    outputWriter.stop();
                }
                catch (Exception e) {
                    this.logger.warn("Ignore exception stopping outputWriters", (Throwable)e);
                }
            }
            this.state = State.STOPPED;
            this.logger.info("Set state to {}", (Object)this.state);
        }
        catch (RuntimeException e) {
            this.state = State.ERROR;
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("Exception stopping EmbeddedJmxTrans", (Throwable)e);
            }
            throw e;
        }
        finally {
            this.lifecycleLock.writeLock().unlock();
        }
        this.logger.info("Stopped");
    }

    @Override
    public void collectMetrics() {
        this.lifecycleLock.readLock().lock();
        try {
            if (!State.STARTED.equals((Object)this.state)) {
                this.logger.debug("Ignore collectMetrics() command for " + (Object)((Object)this.state) + " instance");
                return;
            }
            for (Query query : this.getQueries()) {
                query.collectMetrics();
            }
        }
        finally {
            this.lifecycleLock.readLock().unlock();
        }
    }

    @Override
    public void exportCollectedMetrics() {
        this.lifecycleLock.readLock().lock();
        try {
            if (!State.STARTED.equals((Object)this.state)) {
                this.logger.debug("Ignore collectMetrics() command for " + (Object)((Object)this.state) + " instance");
                return;
            }
            for (Query query : this.getQueries()) {
                query.exportCollectedMetrics();
            }
        }
        finally {
            this.lifecycleLock.readLock().unlock();
        }
    }

    @Nonnull
    public List<Query> getQueries() {
        return this.queries;
    }

    public void addQuery(@Nonnull Query query) {
        query.setEmbeddedJmxTrans(this);
        this.queries.add(query);
    }

    public String toString() {
        return "EmbeddedJmxTrans{state=" + this.getState() + ", queries=" + this.queries + ", outputWriters=" + this.outputWriters + ", numQueryThreads=" + this.numQueryThreads + ", queryIntervalInSeconds=" + this.queryIntervalInSeconds + ", numExportThreads=" + this.numExportThreads + ", exportIntervalInSeconds=" + this.exportIntervalInSeconds + ", exportBatchSize=" + this.exportBatchSize + '}';
    }

    @Override
    public int getNumQueryThreads() {
        return this.numQueryThreads;
    }

    public void setNumQueryThreads(int numQueryThreads) {
        this.numQueryThreads = numQueryThreads;
    }

    @Override
    public int getQueryIntervalInSeconds() {
        return this.queryIntervalInSeconds;
    }

    public void setQueryIntervalInSeconds(int queryIntervalInSeconds) {
        this.queryIntervalInSeconds = queryIntervalInSeconds;
    }

    @Override
    public int getExportIntervalInSeconds() {
        return this.exportIntervalInSeconds;
    }

    public void setExportIntervalInSeconds(int exportIntervalInSeconds) {
        this.exportIntervalInSeconds = exportIntervalInSeconds;
    }

    @Override
    public int getNumExportThreads() {
        return this.numExportThreads;
    }

    public void setNumExportThreads(int numExportThreads) {
        this.numExportThreads = numExportThreads;
    }

    @Nonnull
    public Set<OutputWriter> getOutputWriters() {
        return this.outputWriters;
    }

    public int getExportBatchSize() {
        return this.exportBatchSize;
    }

    public void setExportBatchSize(int exportBatchSize) {
        this.exportBatchSize = exportBatchSize;
    }

    @Nonnull
    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    @Override
    public int getCollectedMetricsCount() {
        int result = 0;
        for (Query query : this.queries) {
            result += query.getCollectedMetricsCount();
        }
        return result;
    }

    @Override
    public long getCollectionDurationInNanos() {
        long result = 0L;
        for (Query query : this.queries) {
            result += query.getCollectionDurationInNanos();
        }
        return result;
    }

    @Override
    public long getCollectionDurationInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.getCollectionDurationInNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int getCollectionCount() {
        int result = 0;
        for (Query query : this.queries) {
            result += query.getCollectionCount();
        }
        return result;
    }

    @Override
    public int getExportedMetricsCount() {
        int result = 0;
        for (Query query : this.queries) {
            result += query.getExportedMetricsCount();
        }
        return result;
    }

    @Override
    public long getExportDurationInNanos() {
        long result = 0L;
        for (Query query : this.queries) {
            result += query.getExportDurationInNanos();
        }
        return result;
    }

    @Override
    public long getExportDurationInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.getExportDurationInNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int getExportCount() {
        int result = 0;
        for (Query query : this.queries) {
            result += query.getExportCount();
        }
        return result;
    }

    @Override
    public int getDiscardedResultsCount() {
        int result = 0;
        for (Query query : this.queries) {
            int discardedResultsCount = query.getDiscardedResultsCount();
            if (discardedResultsCount == -1) continue;
            result += discardedResultsCount;
        }
        return result;
    }

    @Override
    @Nullable
    public String getState() {
        this.lifecycleLock.readLock().lock();
        try {
            String string = this.state == null ? null : this.state.toString();
            return string;
        }
        finally {
            this.lifecycleLock.readLock().unlock();
        }
    }

    static enum State {
        STOPPED,
        STARTED,
        ERROR;

    }

    private class EmbeddedJmxTransShutdownHook
    extends Thread {
        private boolean removed = false;
        private final Logger logger = LoggerFactory.getLogger(this.getClass());

        public EmbeddedJmxTransShutdownHook() {
            this.setName(this.getClass().getSimpleName() + "-" + this.getName());
        }

        @Override
        public void run() {
            try {
                EmbeddedJmxTrans.this.stop();
            }
            catch (Exception e) {
                this.logger.warn("Exception shutting down", (Throwable)e);
            }
        }

        public void registerToRuntime() {
            Runtime.getRuntime().addShutdownHook(this);
        }

        public void unregisterFromRuntime() {
            if (this.removed) {
                this.logger.debug("Shutdown hook already removed");
            }
            try {
                boolean shutdownHookRemoved = Runtime.getRuntime().removeShutdownHook(this);
                if (shutdownHookRemoved) {
                    this.removed = true;
                    this.logger.debug("ShutdownHook successfully removed");
                } else {
                    this.logger.warn("Failure to remove ShutdownHook");
                }
            }
            catch (IllegalStateException e) {
                this.logger.debug("Failure to remove ShutdownHook, probably 'Shutdown in progress'", (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.warn("Failure to remove ShutdownHook", (Throwable)e);
            }
        }
    }
}

