/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.jmxtrans.embedded.Query;
import org.jmxtrans.embedded.QueryResult;
import org.jmxtrans.embedded.ResultNameStrategy;
import org.jmxtrans.embedded.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryAttribute {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ResultNameStrategy resultNameStrategy = new ResultNameStrategy();
    private Query query;
    @Nonnull
    private String name;
    @Nullable
    private String resultAlias;
    @Nullable
    private String type;
    @Nullable
    private String[] keys;

    public QueryAttribute(@Nonnull String name, @Nullable String type, @Nullable String resultAlias) {
        this.name = Preconditions.checkNotEmpty(name);
        this.type = type;
        this.resultAlias = resultAlias;
    }

    public QueryAttribute(@Nonnull String name, @Nullable String type, @Nullable String resultAlias, @Nullable Collection<String> keys) {
        this(name, type, resultAlias);
        this.addKeys(keys);
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getResultAlias() {
        return this.resultAlias;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public int collectMetrics(@Nonnull ObjectName objectName, @Nonnull Object value, long epochInMillis, @Nonnull Queue<QueryResult> results) {
        int metricsCounter = 0;
        if (value instanceof CompositeData) {
            String[] keysToCollect;
            CompositeData compositeData = (CompositeData)value;
            if (this.keys == null) {
                keysToCollect = compositeData.getCompositeType().keySet().toArray(new String[0]);
                this.logger.info("No 'key' has been configured to collect data on this Composite attribute, collect all keys. {}:{}:{}", new Object[]{this.getQuery(), objectName, this});
            } else {
                keysToCollect = this.keys;
            }
            for (String key : keysToCollect) {
                String resultName = this.resultNameStrategy.getResultName(this.getQuery(), objectName, this, key);
                Object compositeValue = compositeData.get(key);
                if (compositeValue instanceof Number || compositeValue instanceof String || compositeValue instanceof Date) {
                    QueryResult result = new QueryResult(resultName, this.getType(), compositeValue, epochInMillis);
                    this.logger.debug("Collect {}", (Object)result);
                    results.add(result);
                    ++metricsCounter;
                    continue;
                }
                this.logger.debug("Skip non supported value {}:{}:{}:{}={}", new Object[]{this.getQuery(), objectName, this, key, compositeValue});
            }
        } else if (value instanceof Number || value instanceof String || value instanceof Date) {
            if (this.keys != null && this.logger.isInfoEnabled()) {
                this.logger.info("Ignore keys configured for 'simple' jmx attribute. {}:{}:{}", new Object[]{this.getQuery(), objectName, this});
            }
            String resultName = this.resultNameStrategy.getResultName(this.getQuery(), objectName, this);
            QueryResult result = new QueryResult(resultName, this.getType(), value, epochInMillis);
            this.logger.debug("Collect {}", (Object)result);
            results.add(result);
            ++metricsCounter;
        } else {
            this.logger.info("Ignore non CompositeData attribute value {}:{}:{}={}", new Object[]{this.getQuery(), objectName, this, value});
        }
        return metricsCounter;
    }

    @Nonnull
    public QueryAttribute addKeys(@Nullable Collection<String> newKeys) {
        if (newKeys == null) {
            return this;
        }
        HashSet<String> newKeysSet = new HashSet<String>(newKeys);
        if (this.keys != null) {
            Collections.addAll(newKeysSet, this.keys);
        }
        this.keys = newKeysSet.toArray(new String[0]);
        return this;
    }

    public String toString() {
        return "QueryAttribute{name='" + this.getName() + '\'' + ", resultAlias='" + this.getResultAlias() + '\'' + ", keys=" + (this.keys == null ? null : Arrays.asList(this.keys)) + '}';
    }
}

