/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.output;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.jmxtrans.embedded.EmbeddedJmxTransException;
import org.jmxtrans.embedded.QueryResult;
import org.jmxtrans.embedded.output.AbstractOutputWriter;
import org.jmxtrans.embedded.output.OutputWriter;
import org.jmxtrans.embedded.util.io.IoUtils2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteHttpWriter
extends AbstractOutputWriter
implements OutputWriter {
    public static final String DEFAULT_NAME_PREFIX = "servers.#hostname#.";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String metricPathPrefix;
    private URL graphiteHttpUrl;

    @Override
    public void start() {
        String url = this.getStringSetting("url");
        try {
            this.graphiteHttpUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new EmbeddedJmxTransException(e);
        }
        this.logger.info("Start Graphite writer connected to '{}'...", (Object)this.graphiteHttpUrl);
        this.metricPathPrefix = this.getStringSetting("namePrefix", DEFAULT_NAME_PREFIX);
        this.metricPathPrefix = this.getStrategy().resolveExpression(this.metricPathPrefix);
        if (!this.metricPathPrefix.isEmpty() && !this.metricPathPrefix.endsWith(".")) {
            this.metricPathPrefix = this.metricPathPrefix + ".";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Iterable<QueryResult> results) {
        this.logger.debug("Export to '{}' results {}", (Object)this.graphiteHttpUrl, results);
        URLConnection urlConnection = null;
        try {
            StringBuilder sbUrlWriter = new StringBuilder("");
            for (QueryResult result : results) {
                String msg = this.metricPathPrefix + result.getName() + " " + result.getValue() + " " + result.getEpoch(TimeUnit.SECONDS) + "\n";
                this.logger.debug("Export '{}'", (Object)msg);
                sbUrlWriter.append(msg);
            }
            if (sbUrlWriter.length() > 0) {
                sbUrlWriter.insert(0, "data=");
                urlConnection = (HttpURLConnection)this.graphiteHttpUrl.openConnection();
                ((HttpURLConnection)urlConnection).setRequestMethod("POST");
                urlConnection.setDoOutput(true);
                OutputStreamWriter urlWriter = new OutputStreamWriter(urlConnection.getOutputStream(), Charset.forName("UTF-8"));
                urlWriter.write(sbUrlWriter.toString());
                urlWriter.flush();
                IoUtils2.closeQuietly(urlWriter);
                int responseCode = ((HttpURLConnection)urlConnection).getResponseCode();
                if (responseCode != 200) {
                    this.logger.warn("Failure {}:'{}' to send result to Graphite HTTP proxy'{}' ", new Object[]{responseCode, ((HttpURLConnection)urlConnection).getResponseMessage(), this.graphiteHttpUrl});
                }
                if (this.logger.isTraceEnabled()) {
                    IoUtils2.copy(urlConnection.getInputStream(), System.out);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Failure to send result to Graphite HTTP proxy '{}'", (Object)this.graphiteHttpUrl, (Object)e);
        }
        finally {
            if (urlConnection != null) {
                try {
                    InputStream in = urlConnection.getInputStream();
                    IoUtils2.copy(in, IoUtils2.nullOutputStream());
                    IoUtils2.closeQuietly(in);
                    InputStream err = ((HttpURLConnection)urlConnection).getErrorStream();
                    if (err != null) {
                        IoUtils2.copy(err, IoUtils2.nullOutputStream());
                        IoUtils2.closeQuietly(err);
                    }
                }
                catch (IOException e) {
                    this.logger.warn("Exception flushing http connection", (Throwable)e);
                }
            }
        }
    }
}

