/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.embedded.util.Preconditions;

public class StringUtils2 {
    private StringUtils2() {
    }

    public static List<String> delimitedStringToList(@Nullable String delimitedString) {
        if (delimitedString == null) {
            return null;
        }
        String[] splits = delimitedString.split("[,;\\n]");
        ArrayList<String> result = new ArrayList<String>();
        for (String split : splits) {
            if ((split = split.trim()).isEmpty()) continue;
            result.add(split);
        }
        return result;
    }

    public static String join(@Nullable List<String> tokens, @Nonnull String delimiter) {
        if (tokens == null) {
            return null;
        }
        Preconditions.checkNotNull(delimiter, "given delimiter can not be null");
        Iterator<String> it = tokens.iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            String token = it.next();
            sb.append(token);
            if (!it.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String reverseTokens(@Nullable String str, @Nonnull String delimiter) {
        if (str == null) {
            return null;
        }
        Preconditions.checkNotNull(delimiter, "given delimiter can not be null");
        StringTokenizer st = new StringTokenizer(str, delimiter);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        Collections.reverse(tokens);
        return StringUtils2.join(tokens, delimiter);
    }

    public static boolean isNullOrEmpty(@Nullable String value) {
        return value == null || value.trim().isEmpty();
    }

    @Nonnull
    public static String abbreviate(String str, int max) {
        if (str == null) {
            return "";
        }
        if (str.length() <= max) {
            return str;
        }
        return str.substring(0, max - 3) + "...";
    }
}

