/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.jmx;

import javax.annotation.Nullable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxUtils2 {
    private static final Logger logger = LoggerFactory.getLogger(JmxUtils2.class);

    private JmxUtils2() {
    }

    @Nullable
    public static ObjectName registerObject(Object object, String objectName, MBeanServer mbeanServer) {
        try {
            return mbeanServer.registerMBean(object, new ObjectName(objectName)).getObjectName();
        }
        catch (Exception e) {
            logger.warn("Failure to register {}:{}", new Object[]{objectName, object, e});
            return null;
        }
    }

    public static void unregisterObject(ObjectName objectName, MBeanServer mbeanServer) {
        if (objectName == null) {
            return;
        }
        try {
            mbeanServer.unregisterMBean(objectName);
        }
        catch (Exception e) {
            logger.warn("Failure to unregister {}", (Object)objectName, (Object)e);
        }
    }
}

