/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.net;

import java.io.BufferedWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import org.jmxtrans.embedded.util.net.UDPDatagramWriter;

public class SocketWriter
extends FilterWriter {
    private final Socket socket;
    private final DatagramSocket datagramSocket;

    public SocketWriter(InetSocketAddress inetSocketAddress, Charset charset) throws IOException {
        this(new Socket(inetSocketAddress.getAddress(), inetSocketAddress.getPort()), charset);
    }

    public SocketWriter(Socket socket, Charset charset) throws IOException {
        super(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), charset)));
        this.socket = socket;
        this.datagramSocket = null;
    }

    public SocketWriter(DatagramSocket datagramSocket, Charset charset) throws IOException {
        super(new UDPDatagramWriter(datagramSocket, charset));
        this.datagramSocket = datagramSocket;
        this.socket = null;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public DatagramSocket getDatagramSocket() {
        return this.datagramSocket;
    }

    public String toString() {
        return "SocketWriter{socket=" + (this.socket != null ? this.socket : this.datagramSocket) + '}';
    }
}

