/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.pool;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.net.SocketFactory;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.jmxtrans.embedded.util.net.HostAndPort;
import org.jmxtrans.embedded.util.net.SocketWriter;

public class SocketWriterPoolFactory
extends BaseKeyedPooledObjectFactory<HostAndPort, SocketWriter>
implements KeyedPooledObjectFactory<HostAndPort, SocketWriter> {
    public static final int DEFAULT_SOCKET_CONNECT_TIMEOUT_IN_MILLIS = 500;
    private final Charset charset;
    private final int socketConnectTimeoutInMillis;
    private final SocketFactory socketFactory;

    @Deprecated
    public SocketWriterPoolFactory(@Nonnull String charset, int socketConnectTimeoutInMillis) {
        this(Charset.forName(charset), socketConnectTimeoutInMillis);
    }

    @Deprecated
    public SocketWriterPoolFactory(@Nonnull Charset charset, int socketConnectTimeoutInMillis) {
        this(SocketFactory.getDefault(), charset, socketConnectTimeoutInMillis);
    }

    public SocketWriterPoolFactory(@Nonnull SocketFactory socketFactory, @Nonnull Charset charset, int socketConnectTimeoutInMillis) {
        this.charset = charset;
        this.socketConnectTimeoutInMillis = socketConnectTimeoutInMillis;
        this.socketFactory = socketFactory;
    }

    public SocketWriter create(HostAndPort hostAndPort) throws Exception {
        Socket socket = this.socketFactory.createSocket();
        socket.setKeepAlive(true);
        socket.connect(new InetSocketAddress(hostAndPort.getHost(), hostAndPort.getPort()), this.socketConnectTimeoutInMillis);
        return new SocketWriter(socket, this.charset);
    }

    public void destroyObject(HostAndPort hostAndPort, PooledObject<SocketWriter> socketWriterRef) throws Exception {
        super.destroyObject((Object)hostAndPort, socketWriterRef);
        SocketWriter socketWriter = (SocketWriter)socketWriterRef.getObject();
        socketWriter.close();
        socketWriter.getSocket().close();
    }

    public PooledObject<SocketWriter> wrap(SocketWriter socketWriter) {
        return new DefaultPooledObject((Object)socketWriter);
    }

    public boolean validateObject(HostAndPort hostAndPort, PooledObject<SocketWriter> socketWriterRef) {
        Socket socket = ((SocketWriter)socketWriterRef.getObject()).getSocket();
        return socket.isConnected() && socket.isBound() && !socket.isClosed() && !socket.isInputShutdown() && !socket.isOutputShutdown();
    }
}

