/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.pool;

import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.jmxtrans.embedded.util.net.HostAndPort;
import org.jmxtrans.embedded.util.net.SocketWriter;

public class UDPSocketWriterPoolFactory
extends BaseKeyedPooledObjectFactory<HostAndPort, SocketWriter>
implements KeyedPooledObjectFactory<HostAndPort, SocketWriter> {
    private final Charset charset;

    public UDPSocketWriterPoolFactory(String charset) {
        this.charset = Charset.forName(charset);
    }

    public UDPSocketWriterPoolFactory(Charset charset) {
        this.charset = charset;
    }

    public SocketWriter create(HostAndPort hostAndPort) throws Exception {
        DatagramSocket datagramSocket = new DatagramSocket(null);
        datagramSocket.connect(new InetSocketAddress(hostAndPort.getHost(), hostAndPort.getPort()));
        return new SocketWriter(datagramSocket, this.charset);
    }

    public PooledObject<SocketWriter> wrap(SocketWriter socketWriter) {
        return new DefaultPooledObject((Object)socketWriter);
    }

    public boolean validateObject(HostAndPort hostAndPort, PooledObject<SocketWriter> socketWriterRef) {
        DatagramSocket datagramSocket = ((SocketWriter)socketWriterRef.getObject()).getDatagramSocket();
        return datagramSocket.isConnected() && !datagramSocket.isClosed();
    }

    public void destroyObject(HostAndPort hostAndPort, PooledObject<SocketWriter> socketWriterRef) throws Exception {
        super.destroyObject((Object)hostAndPort, socketWriterRef);
        SocketWriter socketWriter = (SocketWriter)socketWriterRef.getObject();
        socketWriter.close();
        socketWriter.getDatagramSocket().close();
    }
}

