/*
 * Decompiled with CFR 0.152.
 */
package jodd.mutable;

import java.util.function.Supplier;

public class LazyValue<T>
implements Supplier<T> {
    private Supplier<T> supplier;
    private volatile boolean initialized;
    private T value;

    public static <T> LazyValue<T> of(Supplier<T> supplier) {
        return new LazyValue<T>(supplier);
    }

    private LazyValue(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (!this.initialized) {
            LazyValue lazyValue = this;
            synchronized (lazyValue) {
                if (!this.initialized) {
                    T t = this.supplier.get();
                    this.value = t;
                    this.initialized = true;
                    this.supplier = null;
                    return t;
                }
            }
        }
        return this.value;
    }
}

