/*
 * Decompiled with CFR 0.152.
 */
package jodd.buffer;

import java.util.Arrays;

public class FastBooleanBuffer {
    private boolean[] buffer;
    private int offset;

    public FastBooleanBuffer() {
        this.buffer = new boolean[64];
    }

    public FastBooleanBuffer(int size) {
        this.buffer = new boolean[size];
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buffer.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity + 512;
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    public void append(boolean element) {
        if (this.offset - this.buffer.length >= 0) {
            this.grow(this.offset);
        }
        this.buffer[this.offset++] = element;
    }

    public FastBooleanBuffer append(boolean[] array, int off, int len) {
        if (this.offset + len - this.buffer.length > 0) {
            this.grow(this.offset + len);
        }
        System.arraycopy(array, off, this.buffer, this.offset, len);
        this.offset += len;
        return this;
    }

    public FastBooleanBuffer append(boolean[] array) {
        return this.append(array, 0, array.length);
    }

    public FastBooleanBuffer append(FastBooleanBuffer buff) {
        if (buff.offset == 0) {
            return this;
        }
        this.append(buff.buffer, 0, buff.offset);
        return this;
    }

    public int size() {
        return this.offset;
    }

    public boolean isEmpty() {
        return this.offset == 0;
    }

    public void clear() {
        this.offset = 0;
    }

    public boolean[] toArray() {
        return Arrays.copyOf(this.buffer, this.offset);
    }

    public boolean[] toArray(int start, int len) {
        boolean[] array = new boolean[len];
        if (len == 0) {
            return array;
        }
        System.arraycopy(this.buffer, start, array, 0, len);
        return array;
    }

    public boolean get(int index) {
        if (index >= this.offset) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[index];
    }
}

