/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.nio.CharBuffer;
import java.util.List;
import jodd.lagarto.LagartoParserEngine;
import jodd.lagarto.dom.DOMBuilderTagVisitor;
import jodd.lagarto.dom.Document;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LagartoDOMBuilder
extends LagartoParserEngine {
    public static final String[] HTML5_VOID_TAGS = new String[]{"area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"};
    protected boolean ignoreWhitespacesBetweenTags;
    protected boolean caseSensitive;
    protected boolean ignoreComments;
    protected boolean selfCloseVoidTags;
    protected boolean collectErrors;
    protected String conditionalCommentExpression;
    protected String[] voidTags = HTML5_VOID_TAGS;
    protected boolean impliedEndTags;
    protected List<String> errors;
    protected long elapsed;

    public LagartoDOMBuilder() {
        this.enableHtmlMode();
    }

    public boolean isIgnoreWhitespacesBetweenTags() {
        return this.ignoreWhitespacesBetweenTags;
    }

    public void setIgnoreWhitespacesBetweenTags(boolean ignoreWhitespacesBetweenTags) {
        this.ignoreWhitespacesBetweenTags = ignoreWhitespacesBetweenTags;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    public String[] getVoidTags() {
        return this.voidTags;
    }

    public void setVoidTags(String ... voidTags) {
        this.voidTags = voidTags;
    }

    public boolean hasVoidTags() {
        return this.voidTags != null;
    }

    public boolean isVoidTag(String tagName) {
        if (this.voidTags == null) {
            return false;
        }
        return StringUtil.equalsOne((String)(tagName = tagName.toLowerCase()), (String[])this.voidTags) != -1;
    }

    public boolean isSelfCloseVoidTags() {
        return this.selfCloseVoidTags;
    }

    public void setSelfCloseVoidTags(boolean selfCloseVoidTags) {
        this.selfCloseVoidTags = selfCloseVoidTags;
    }

    public boolean isCollectErrors() {
        return this.collectErrors;
    }

    public void setCollectErrors(boolean collectErrors) {
        this.collectErrors = collectErrors;
    }

    public String getConditionalCommentExpression() {
        return this.conditionalCommentExpression;
    }

    public void setConditionalCommentExpression(String conditionalCommentExpression) {
        this.conditionalCommentExpression = conditionalCommentExpression;
    }

    public boolean isImpliedEndTags() {
        return this.impliedEndTags;
    }

    public void setImpliedEndTags(boolean impliedEndTags) {
        this.impliedEndTags = impliedEndTags;
    }

    public LagartoDOMBuilder enableHtmlMode() {
        this.ignoreWhitespacesBetweenTags = false;
        this.caseSensitive = false;
        this.parseSpecialTagsAsCdata = true;
        this.voidTags = HTML5_VOID_TAGS;
        this.selfCloseVoidTags = false;
        this.impliedEndTags = true;
        this.enableConditionalComments = true;
        this.conditionalCommentExpression = "if !IE";
        return this;
    }

    public LagartoDOMBuilder enableXhtmlMode() {
        this.ignoreWhitespacesBetweenTags = false;
        this.caseSensitive = true;
        this.parseSpecialTagsAsCdata = false;
        this.voidTags = HTML5_VOID_TAGS;
        this.selfCloseVoidTags = true;
        this.impliedEndTags = false;
        this.enableConditionalComments = true;
        this.conditionalCommentExpression = "if !IE";
        return this;
    }

    public LagartoDOMBuilder enableXmlMode() {
        this.ignoreWhitespacesBetweenTags = true;
        this.caseSensitive = true;
        this.parseSpecialTagsAsCdata = false;
        this.voidTags = null;
        this.selfCloseVoidTags = false;
        this.impliedEndTags = false;
        this.enableConditionalComments = false;
        this.conditionalCommentExpression = null;
        return this;
    }

    public Document parse(CharSequence content) {
        this.initialize(CharBuffer.wrap(content));
        return this.doParse();
    }

    public Document parse(CharBuffer content) {
        this.initialize(content);
        return this.doParse();
    }

    protected Document doParse() {
        DOMBuilderTagVisitor domBuilderTagVisitor = this.createDOMDomBuilderTagVisitor();
        this.parse(domBuilderTagVisitor);
        return domBuilderTagVisitor.getDocument();
    }

    protected DOMBuilderTagVisitor createDOMDomBuilderTagVisitor() {
        return new DOMBuilderTagVisitor(this);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public long getParsingTime() {
        return this.elapsed;
    }
}

