/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.servlet;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ListenerInfo;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import lombok.Generated;
import org.apache.catalina.Context;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;

public class WebFragmentRegistrationBean
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebFragmentRegistrationBean.class);
    private List<Class<? extends EventListener>> listeners = new LinkedList<Class<? extends EventListener>>();
    private List<ErrorPage> errorPages = new LinkedList<ErrorPage>();
    private Map<String, String> contextParams = new LinkedHashMap<String, String>();

    public void customize(ConfigurableServletWebServerFactory factory) {
        if (factory instanceof TomcatServletWebServerFactory) {
            ((TomcatServletWebServerFactory)factory).addContextCustomizers(new TomcatContextCustomizer[]{new TomcatListenerAdder(this.listeners)});
        } else if (factory instanceof JettyServletWebServerFactory) {
            ((JettyServletWebServerFactory)factory).addConfigurations(new Configuration[]{new JettyListenerAdder(this.listeners)});
        } else if (factory instanceof UndertowServletWebServerFactory) {
            ((UndertowServletWebServerFactory)factory).addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{new UndertowListenerAdder(this.listeners)});
        } else {
            log.warn("Unkown WebServerFactory implementation: {}", factory.getClass());
            factory.addInitializers(new ServletContextInitializer[]{servletContext -> this.listeners.forEach(arg_0 -> ((ServletContext)servletContext).addListener(arg_0))});
        }
        factory.addInitializers(new ServletContextInitializer[]{servletContext -> this.contextParams.forEach((arg_0, arg_1) -> ((ServletContext)servletContext).setInitParameter(arg_0, arg_1))});
        this.errorPages.forEach(xva$0 -> factory.addErrorPages(new ErrorPage[]{xva$0}));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Class<? extends EventListener>> getListeners() {
        return this.listeners;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<ErrorPage> getErrorPages() {
        return this.errorPages;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, String> getContextParams() {
        return this.contextParams;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setListeners(List<Class<? extends EventListener>> listeners) {
        this.listeners = listeners;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setErrorPages(List<ErrorPage> errorPages) {
        this.errorPages = errorPages;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setContextParams(Map<String, String> contextParams) {
        this.contextParams = contextParams;
    }

    public static class UndertowListenerAdder
    implements UndertowDeploymentInfoCustomizer {
        private final List<Class<? extends EventListener>> listeners;

        public void customize(DeploymentInfo deploymentInfo) {
            this.listeners.forEach(listener -> deploymentInfo.addListener(new ListenerInfo(listener, false)));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UndertowListenerAdder(List<Class<? extends EventListener>> listeners) {
            this.listeners = listeners;
        }
    }

    public static class JettyListenerAdder
    extends AbstractConfiguration {
        private final List<Class<? extends EventListener>> listeners;

        public void configure(WebAppContext context) throws Exception {
            for (Class<? extends EventListener> listener : this.listeners) {
                context.addEventListener(listener.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public JettyListenerAdder(List<Class<? extends EventListener>> listeners) {
            this.listeners = listeners;
        }
    }

    public static class TomcatListenerAdder
    implements TomcatContextCustomizer {
        private final List<Class<? extends EventListener>> listeners;

        public void customize(Context context) {
            this.listeners.forEach(listener -> context.addApplicationListener(listener.getName()));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TomcatListenerAdder(List<Class<? extends EventListener>> listeners) {
            this.listeners = listeners;
        }
    }
}

