/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.session;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import lombok.Generated;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class SpringSessionFixFilter
extends OncePerRequestFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        RequestWrapper wrappedRequest = new RequestWrapper(request);
        try {
            filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)response);
        }
        finally {
            HttpSession session = request.getSession(false);
            if (session != null) {
                this.reSetAttributes(wrappedRequest, session);
            }
        }
    }

    private void reSetAttributes(RequestWrapper wrappedRequest, HttpSession session) {
        if (CollectionUtils.isEmpty((Collection)wrappedRequest.readAttributeNames)) {
            return;
        }
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object attributeValue;
            String attributeName = (String)attributeNames.nextElement();
            if (!wrappedRequest.readAttributeNames.contains(attributeName) || ClassUtils.isPrimitiveOrWrapper((attributeValue = session.getAttribute(attributeName)).getClass())) continue;
            session.setAttribute(attributeName, attributeValue);
        }
    }

    static class RequestWrapper
    extends HttpServletRequestWrapper {
        @NonNull
        private final Set<String> readAttributeNames = new HashSet<String>();

        RequestWrapper(HttpServletRequest request) {
            super(request);
        }

        @Nullable
        public HttpSession getSession(boolean create) {
            HttpSession session = super.getSession(create);
            return session != null ? new SessionWrapper(session) : null;
        }

        public HttpSession getSession() {
            return new SessionWrapper(super.getSession());
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Set<String> getReadAttributeNames() {
            return this.readAttributeNames;
        }

        class SessionWrapper
        implements HttpSession {
            private final HttpSession delegate;

            public long getCreationTime() {
                return this.delegate.getCreationTime();
            }

            public String getId() {
                return this.delegate.getId();
            }

            public long getLastAccessedTime() {
                return this.delegate.getLastAccessedTime();
            }

            public ServletContext getServletContext() {
                return this.delegate.getServletContext();
            }

            public void setMaxInactiveInterval(int interval) {
                this.delegate.setMaxInactiveInterval(interval);
            }

            public int getMaxInactiveInterval() {
                return this.delegate.getMaxInactiveInterval();
            }

            @Deprecated
            public HttpSessionContext getSessionContext() {
                return this.delegate.getSessionContext();
            }

            @Nullable
            public Object getAttribute(String name) {
                RequestWrapper.this.readAttributeNames.add(name);
                return this.delegate.getAttribute(name);
            }

            @Deprecated
            @Nullable
            public Object getValue(String name) {
                RequestWrapper.this.readAttributeNames.add(name);
                return this.delegate.getValue(name);
            }

            public Enumeration<String> getAttributeNames() {
                return this.delegate.getAttributeNames();
            }

            @Deprecated
            public String[] getValueNames() {
                return this.delegate.getValueNames();
            }

            public void setAttribute(String name, Object value) {
                this.delegate.setAttribute(name, value);
            }

            @Deprecated
            public void putValue(String name, Object value) {
                this.delegate.putValue(name, value);
            }

            public void removeAttribute(String name) {
                this.delegate.removeAttribute(name);
            }

            @Deprecated
            public void removeValue(String name) {
                this.delegate.removeValue(name);
            }

            public void invalidate() {
                this.delegate.invalidate();
                RequestWrapper.this.readAttributeNames.clear();
            }

            public boolean isNew() {
                return this.delegate.isNew();
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public SessionWrapper(HttpSession delegate) {
                this.delegate = delegate;
            }
        }
    }
}

