/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.faces;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.faces.context.FacesContext;
import lombok.Generated;
import org.joinfaces.autoconfigure.faces.FacesServletProperties;
import org.joinfaces.autoconfigure.faces.JakartaFaces3Properties;
import org.joinfaces.autoconfigure.faces.JakartaFaces4Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.PriorityOrdered;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={FacesContext.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={JakartaFaces3Properties.class, JakartaFaces4Properties.class})
public class JakartaFaces3AutoConfiguration {
    @Bean
    public static FacesServletPropertiesPostProcessor disableFacesservletToXhtml(ApplicationContext applicationContext) {
        return new FacesServletPropertiesPostProcessor(applicationContext);
    }

    public static class FacesServletPropertiesPostProcessor
    implements BeanPostProcessor,
    PriorityOrdered {
        private final ApplicationContext applicationContext;

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof FacesServletProperties) {
                FacesServletProperties facesServletProperties = (FacesServletProperties)bean;
                Boolean disableFacesservletToXhtml = ((JakartaFaces3Properties)this.applicationContext.getBean(JakartaFaces3Properties.class)).getDisableFacesservletToXhtml();
                if (disableFacesservletToXhtml != null && disableFacesservletToXhtml.booleanValue()) {
                    facesServletProperties.getUrlMappings().remove("*.xhtml");
                }
            }
            return bean;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FacesServletPropertiesPostProcessor(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }
    }
}

