/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXB;
import org.jooq.SortOrder;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractGenerator;
import org.jooq.util.CatalogDefinition;
import org.jooq.util.CheckConstraintDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.IndexColumnDefinition;
import org.jooq.util.IndexDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ParameterDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.TextWriter;
import org.jooq.util.UniqueKeyDefinition;
import org.jooq.util.xml.jaxb.Column;
import org.jooq.util.xml.jaxb.Index;
import org.jooq.util.xml.jaxb.IndexColumnUsage;
import org.jooq.util.xml.jaxb.InformationSchema;
import org.jooq.util.xml.jaxb.KeyColumnUsage;
import org.jooq.util.xml.jaxb.Parameter;
import org.jooq.util.xml.jaxb.ParameterMode;
import org.jooq.util.xml.jaxb.ReferentialConstraint;
import org.jooq.util.xml.jaxb.Routine;
import org.jooq.util.xml.jaxb.RoutineType;
import org.jooq.util.xml.jaxb.Schema;
import org.jooq.util.xml.jaxb.Sequence;
import org.jooq.util.xml.jaxb.Table;
import org.jooq.util.xml.jaxb.TableConstraint;
import org.jooq.util.xml.jaxb.TableConstraintType;

public class XMLGenerator
extends AbstractGenerator {
    private static final JooqLogger log = JooqLogger.getLogger(XMLGenerator.class);

    public XMLGenerator() {
        super(AbstractGenerator.Language.XML);
    }

    @Override
    public void generate(Database db) {
        this.logDatabaseParameters(db);
        log.info((Object)"");
        this.logGenerationRemarks(db);
        log.info((Object)"");
        log.info((Object)"----------------------------------------------------------");
        TextWriter out = new TextWriter(this.getStrategy().getFile("information_schema.xml"), this.targetEncoding);
        log.info((Object)"");
        log.info((Object)"Generating XML", (Object)out.file().getName());
        log.info((Object)"==========================================================");
        InformationSchema is = new InformationSchema();
        for (CatalogDefinition c : db.getCatalogs()) {
            String catalogName = c.getOutputName();
            for (SchemaDefinition s : c.getSchemata()) {
                String constraintName;
                List columns;
                Column column;
                Table table;
                String schemaName = s.getOutputName();
                Schema schema = new Schema();
                schema.setCatalogName(catalogName);
                schema.setSchemaName(schemaName);
                is.getSchemata().add(schema);
                for (TableDefinition t : s.getTables()) {
                    String tableName = t.getOutputName();
                    table = new Table();
                    table.setTableCatalog(catalogName);
                    table.setTableSchema(schemaName);
                    table.setTableName(tableName);
                    is.getTables().add(table);
                    for (ColumnDefinition co : t.getColumns()) {
                        String columnName = co.getOutputName();
                        DataTypeDefinition type = co.getType();
                        column = new Column();
                        column.setTableCatalog(catalogName);
                        column.setTableSchema(schemaName);
                        column.setTableName(tableName);
                        column.setColumnName(columnName);
                        column.setCharacterMaximumLength(Integer.valueOf(type.getLength()));
                        column.setColumnDefault(type.getDefaultValue());
                        column.setDataType(type.getType());
                        if (co.isIdentity()) {
                            column.setIdentityGeneration("YES");
                        }
                        column.setIsNullable(Boolean.valueOf(type.isNullable()));
                        column.setNumericPrecision(Integer.valueOf(type.getPrecision()));
                        column.setNumericScale(Integer.valueOf(type.getScale()));
                        column.setOrdinalPosition(Integer.valueOf(co.getPosition()));
                        is.getColumns().add(column);
                    }
                }
                for (IndexDefinition i : db.getIndexes(s)) {
                    String indexName = i.getOutputName();
                    table = i.getTable();
                    columns = i.getIndexColumns();
                    Index index = new Index();
                    index.setIndexCatalog(catalogName);
                    index.setIndexSchema(schemaName);
                    index.setIndexName(indexName);
                    index.setTableCatalog(table.getCatalog().getOutputName());
                    index.setTableSchema(table.getSchema().getOutputName());
                    index.setTableName(table.getOutputName());
                    index.setIsUnique(Boolean.valueOf(i.isUnique()));
                    is.getIndexes().add(index);
                    for (int j = 0; j < columns.size(); ++j) {
                        IndexColumnDefinition indexColumn = (IndexColumnDefinition)columns.get(j);
                        column = indexColumn.getColumn();
                        IndexColumnUsage ic = new IndexColumnUsage();
                        ic.setIndexCatalog(catalogName);
                        ic.setIndexSchema(schemaName);
                        ic.setIndexName(indexName);
                        ic.setColumnName(column.getOutputName());
                        ic.setOrdinalPosition(j + 1);
                        ic.setIsDescending(Boolean.valueOf(indexColumn.getSortOrder() == SortOrder.DESC));
                        ic.setTableCatalog(table.getCatalog().getOutputName());
                        ic.setTableSchema(table.getSchema().getOutputName());
                        ic.setTableName(table.getOutputName());
                        is.getIndexColumnUsages().add(ic);
                    }
                }
                for (UniqueKeyDefinition u : db.getUniqueKeys(s)) {
                    constraintName = u.getOutputName();
                    table = u.getTable();
                    columns = u.getKeyColumns();
                    TableConstraint constraint = new TableConstraint();
                    constraint.setConstraintCatalog(catalogName);
                    constraint.setConstraintSchema(schemaName);
                    constraint.setConstraintName(constraintName);
                    constraint.setConstraintType(u.isPrimaryKey() ? TableConstraintType.PRIMARY_KEY : TableConstraintType.UNIQUE);
                    constraint.setTableCatalog(table.getCatalog().getOutputName());
                    constraint.setTableSchema(table.getSchema().getOutputName());
                    constraint.setTableName(table.getOutputName());
                    is.getTableConstraints().add(constraint);
                    for (int i = 0; i < columns.size(); ++i) {
                        ColumnDefinition column2 = (ColumnDefinition)columns.get(i);
                        KeyColumnUsage kc = new KeyColumnUsage();
                        kc.setConstraintCatalog(catalogName);
                        kc.setConstraintSchema(schemaName);
                        kc.setConstraintName(constraintName);
                        kc.setColumnName(column2.getOutputName());
                        kc.setOrdinalPosition(i);
                        kc.setTableCatalog(table.getCatalog().getOutputName());
                        kc.setTableSchema(table.getSchema().getOutputName());
                        kc.setTableName(table.getOutputName());
                        is.getKeyColumnUsages().add(kc);
                    }
                }
                for (ForeignKeyDefinition f : db.getForeignKeys(s)) {
                    constraintName = f.getOutputName();
                    UniqueKeyDefinition referenced = f.getReferencedKey();
                    TableDefinition table2 = f.getKeyTable();
                    List columns2 = f.getKeyColumns();
                    TableConstraint tc = new TableConstraint();
                    tc.setConstraintCatalog(catalogName);
                    tc.setConstraintSchema(schemaName);
                    tc.setConstraintName(constraintName);
                    tc.setConstraintType(TableConstraintType.FOREIGN_KEY);
                    tc.setTableCatalog(table2.getCatalog().getOutputName());
                    tc.setTableSchema(table2.getSchema().getOutputName());
                    tc.setTableName(table2.getOutputName());
                    ReferentialConstraint rc = new ReferentialConstraint();
                    rc.setConstraintCatalog(catalogName);
                    rc.setConstraintSchema(schemaName);
                    rc.setConstraintName(constraintName);
                    rc.setUniqueConstraintCatalog(referenced.getCatalog().getOutputName());
                    rc.setUniqueConstraintSchema(referenced.getSchema().getOutputName());
                    rc.setUniqueConstraintName(referenced.getOutputName());
                    is.getTableConstraints().add(tc);
                    is.getReferentialConstraints().add(rc);
                    for (int i = 0; i < columns2.size(); ++i) {
                        ColumnDefinition column3 = (ColumnDefinition)columns2.get(i);
                        KeyColumnUsage kc = new KeyColumnUsage();
                        kc.setConstraintCatalog(catalogName);
                        kc.setConstraintSchema(schemaName);
                        kc.setConstraintName(constraintName);
                        kc.setColumnName(column3.getOutputName());
                        kc.setOrdinalPosition(i);
                        kc.setTableCatalog(table2.getCatalog().getOutputName());
                        kc.setTableSchema(table2.getSchema().getOutputName());
                        kc.setTableName(table2.getOutputName());
                        is.getKeyColumnUsages().add(kc);
                    }
                }
                for (CheckConstraintDefinition ch : db.getCheckConstraints(s)) {
                    constraintName = ch.getOutputName();
                    table = ch.getTable();
                    TableConstraint constraint = new TableConstraint();
                    constraint.setConstraintCatalog(catalogName);
                    constraint.setConstraintSchema(schemaName);
                    constraint.setConstraintName(constraintName);
                    constraint.setConstraintType(TableConstraintType.CHECK);
                    constraint.setTableCatalog(table.getCatalog().getOutputName());
                    constraint.setTableSchema(table.getSchema().getOutputName());
                    constraint.setTableName(table.getOutputName());
                    is.getTableConstraints().add(constraint);
                }
                for (SequenceDefinition se : db.getSequences(s)) {
                    String sequenceName = se.getOutputName();
                    DataTypeDefinition type = se.getType();
                    Sequence sequence = new Sequence();
                    sequence.setSequenceCatalog(catalogName);
                    sequence.setSequenceSchema(schemaName);
                    sequence.setSequenceName(sequenceName);
                    sequence.setCharacterMaximumLength(Integer.valueOf(type.getLength()));
                    sequence.setDataType(type.getType());
                    sequence.setNumericPrecision(Integer.valueOf(type.getPrecision()));
                    sequence.setNumericScale(Integer.valueOf(type.getScale()));
                    is.getSequences().add(sequence);
                }
                for (PackageDefinition pkg : db.getPackages(s)) {
                    for (RoutineDefinition r : pkg.getRoutines()) {
                        this.exportRoutine(is, r, catalogName, schemaName);
                    }
                }
                for (RoutineDefinition r : db.getRoutines(s)) {
                    this.exportRoutine(is, r, catalogName, schemaName);
                }
            }
        }
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)is, (Writer)writer);
        out.print(writer.toString());
        out.close();
    }

    private void exportRoutine(InformationSchema is, RoutineDefinition r, String catalogName, String schemaName) {
        String specificName = r.getName() + (StringUtils.isBlank((String)r.getOverload()) ? "" : "_" + r.getOverload());
        Routine routine = new Routine();
        routine.setRoutineCatalog(catalogName);
        routine.setSpecificCatalog(catalogName);
        routine.setRoutineSchema(schemaName);
        routine.setSpecificSchema(schemaName);
        if (r.getPackage() != null) {
            routine.setRoutinePackage(r.getPackage().getName());
            routine.setSpecificPackage(r.getPackage().getName());
        }
        routine.setRoutineName(r.getName());
        routine.setSpecificName(specificName);
        if (r.getReturnValue() == null) {
            routine.setRoutineType(RoutineType.PROCEDURE);
        } else {
            routine.setRoutineType(RoutineType.FUNCTION);
            routine.setDataType(r.getReturnType().getType());
            routine.setCharacterMaximumLength(Integer.valueOf(r.getReturnType().getLength()));
            routine.setNumericPrecision(Integer.valueOf(r.getReturnType().getPrecision()));
            routine.setNumericScale(Integer.valueOf(r.getReturnType().getScale()));
        }
        is.getRoutines().add(routine);
        int i = 1;
        for (ParameterDefinition p : r.getAllParameters()) {
            if (p == r.getReturnValue()) continue;
            Parameter parameter = new Parameter();
            parameter.setSpecificCatalog(catalogName);
            parameter.setSpecificSchema(schemaName);
            if (r.getPackage() != null) {
                parameter.setSpecificPackage(r.getPackage().getName());
            }
            parameter.setSpecificName(specificName);
            parameter.setOrdinalPosition(i++);
            parameter.setParameterName(p.getName());
            boolean in = r.getInParameters().contains(p);
            boolean out = r.getOutParameters().contains(p);
            if (in && out) {
                parameter.setParameterMode(ParameterMode.INOUT);
            } else if (in) {
                parameter.setParameterMode(ParameterMode.IN);
            } else if (out) {
                parameter.setParameterMode(ParameterMode.OUT);
            }
            parameter.setDataType(p.getType().getType());
            parameter.setCharacterMaximumLength(Integer.valueOf(p.getType().getLength()));
            parameter.setNumericPrecision(Integer.valueOf(p.getType().getPrecision()));
            parameter.setNumericScale(Integer.valueOf(p.getType().getScale()));
            parameter.setParameterDefault(p.getType().getDefaultValue());
            is.getParameters().add(parameter);
        }
    }
}

