/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import org.jooq.SQLDialect;
import org.jooq.impl.FieldTypeHelper;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.oracle.OracleDataType;

public class DefaultDataTypeDefinition
implements DataTypeDefinition {
    private final Database database;
    private final SchemaDefinition schema;
    private final String typeName;
    private final String udtName;
    private final int length;
    private final int precision;
    private final int scale;

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale) {
        this(database, schema, typeName, length, precision, scale, typeName);
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, String udtName) {
        this.database = database;
        this.schema = schema;
        this.typeName = typeName;
        this.udtName = udtName;
        if (length != null && precision != null && length.intValue() != 0 && precision.intValue() != 0) {
            if (typeName.toLowerCase().matches(".*?(char|text|lob|xml|graphic).*?")) {
                precision = null;
                scale = null;
            } else {
                length = null;
            }
        }
        this.length = length == null ? 0 : length.intValue();
        this.precision = precision == null ? 0 : precision.intValue();
        this.scale = scale == null ? 0 : scale.intValue();
    }

    @Override
    public final Database getDatabase() {
        return this.database;
    }

    @Override
    public final SchemaDefinition getSchema() {
        return this.schema;
    }

    private final SQLDialect getDialect() {
        return this.getDatabase().getDialect();
    }

    @Override
    public final boolean isUDT() {
        return this.getDatabase().getUDT(this.schema, this.udtName) != null;
    }

    @Override
    public final String getType() {
        return this.typeName;
    }

    @Override
    public final int getLength() {
        return this.length;
    }

    @Override
    public final int getPrecision() {
        return this.precision;
    }

    @Override
    public final int getScale() {
        return this.scale;
    }

    @Override
    public final String getUserType() {
        return this.udtName;
    }

    @Override
    public final boolean isGenericNumberType() {
        switch (this.getDialect()) {
            case ORACLE: {
                return OracleDataType.NUMBER.getTypeName().equalsIgnoreCase(this.typeName) && this.precision == 0 && this.scale == 0;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        result = 31 * result + (this.udtName == null ? 0 : this.udtName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultDataTypeDefinition) {
            DefaultDataTypeDefinition other = (DefaultDataTypeDefinition)obj;
            if (FieldTypeHelper.normalise((String)this.typeName).equals(FieldTypeHelper.normalise((String)other.typeName)) && FieldTypeHelper.normalise((String)this.udtName).equals(FieldTypeHelper.normalise((String)other.udtName))) {
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataType [ t=");
        sb.append(this.typeName);
        sb.append("; p=");
        sb.append(this.precision);
        sb.append("; s=");
        sb.append(this.scale);
        sb.append("; u=");
        sb.append(this.udtName);
        sb.append(" ]");
        return sb.toString();
    }
}

