/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.db2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectQuery;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.db2.DB2RoutineDefinition;
import org.jooq.util.db2.DB2TableDefinition;
import org.jooq.util.db2.DB2UDTDefinition;
import org.jooq.util.db2.syscat.SyscatFactory;
import org.jooq.util.db2.syscat.tables.Datatypes;
import org.jooq.util.db2.syscat.tables.Functions;
import org.jooq.util.db2.syscat.tables.Keycoluse;
import org.jooq.util.db2.syscat.tables.Procedures;
import org.jooq.util.db2.syscat.tables.References;
import org.jooq.util.db2.syscat.tables.Sequences;
import org.jooq.util.db2.syscat.tables.Tabconst;
import org.jooq.util.db2.syscat.tables.Tables;

public class DB2Database
extends AbstractDatabase {
    @Override
    public Factory create() {
        return new SyscatFactory(this.getConnection());
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("P")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Keycoluse.TABSCHEMA.trim()));
            String key = (String)record.getValue("constraint_name", String.class);
            String tableName = (String)record.getValue(Keycoluse.TABNAME);
            String columnName = (String)record.getValue(Keycoluse.COLNAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("U")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Keycoluse.TABSCHEMA.trim()));
            String key = (String)record.getValue("constraint_name", String.class);
            String tableName = (String)record.getValue(Keycoluse.TABNAME);
            String columnName = (String)record.getValue(Keycoluse.COLNAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private List<Record> fetchKeys(String constraintType) {
        return this.create().select(new Field[]{Factory.concat((Field[])new Field[]{Keycoluse.TABNAME, Factory.val((Object)"__"), Keycoluse.CONSTNAME}).as("constraint_name"), Keycoluse.TABSCHEMA.trim(), Keycoluse.TABNAME, Keycoluse.COLNAME}).from(new TableLike[]{Keycoluse.KEYCOLUSE}).join((TableLike)Tabconst.TABCONST).on(new Condition[]{Keycoluse.TABSCHEMA.equal(Tabconst.TABSCHEMA)}).and(Keycoluse.CONSTNAME.equal(Tabconst.CONSTNAME)).where(new Condition[]{Keycoluse.TABSCHEMA.in(this.getInputSchemata())}).and(Tabconst.TYPE.equal((Object)constraintType)).orderBy(new SortField[]{Keycoluse.TABSCHEMA.asc(), Keycoluse.TABNAME.asc(), Keycoluse.CONSTNAME.asc(), Keycoluse.COLSEQ.asc()}).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.create().select(new Field[]{Factory.concat((Field[])new Field[]{References.TABNAME, Factory.val((Object)"__"), References.CONSTNAME}).as("constraint_name"), References.TABSCHEMA.trim(), References.TABNAME, References.FK_COLNAMES, Factory.concat((Field[])new Field[]{References.REFTABNAME, Factory.val((Object)"__"), References.REFKEYNAME}).as("referenced_constraint_name"), References.REFTABSCHEMA.trim()}).from(new TableLike[]{References.REFERENCES}).where(new Condition[]{References.TABSCHEMA.in(this.getInputSchemata())}).orderBy(new Field[]{References.TABSCHEMA, References.TABNAME, References.CONSTNAME, References.FK_COLNAMES}).fetch()) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.getValue(References.TABSCHEMA.trim()));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.getValue(References.REFTABSCHEMA.trim()));
            String foreignKey = (String)record.getValue("constraint_name", String.class);
            String foreignKeyTableName = (String)record.getValue(References.TABNAME);
            String foreignKeyColumn = (String)record.getValue(References.FK_COLNAMES);
            String uniqueKey = (String)record.getValue("referenced_constraint_name", String.class);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            if (foreignKeyTable == null) continue;
            String[] referencingColumnNames = foreignKeyColumn.trim().split("[ ]+");
            for (int i = 0; i < referencingColumnNames.length; ++i) {
                ColumnDefinition column = foreignKeyTable.getColumn(referencingColumnNames[i]);
                relations.addForeignKey(foreignKey, uniqueKey, column, uniqueKeySchema);
            }
        }
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(new Field[]{Sequences.SEQSCHEMA.trim(), Sequences.SEQNAME, Sequences.SEQTYPE, Datatypes.TYPENAME, Sequences.PRECISION}).from(new TableLike[]{Sequences.SEQUENCES}).join((TableLike)Datatypes.DATATYPES).on(new Condition[]{Sequences.DATATYPEID.equal(Datatypes.TYPEID.cast(Integer.class))}).where(new Condition[]{Sequences.SEQSCHEMA.in(this.getInputSchemata())}).orderBy(new Field[]{Sequences.SEQSCHEMA, Sequences.SEQNAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Sequences.SEQSCHEMA.trim()));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, (String)record.getValue(Datatypes.TYPENAME), 0, (Number)record.getValue(Sequences.PRECISION), 0);
            result.add(new DefaultSequenceDefinition(schema, (String)record.getValue(Sequences.SEQNAME), type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        SelectQuery q = this.create().selectQuery();
        q.addFrom(new TableLike[]{Tables.TABLES});
        q.addSelect(new Field[]{Tables.TABSCHEMA.trim()});
        q.addSelect(new Field[]{Tables.TABNAME});
        q.addConditions(new Condition[]{Tables.TABSCHEMA.in(this.getInputSchemata())});
        q.addConditions(new Condition[]{Tables.TYPE.in((Object[])new String[]{"T", "V"})});
        q.addOrderBy(new Field[]{Tables.TABNAME});
        q.execute();
        for (Record record : q.getResult()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.TABSCHEMA.trim()));
            String name = (String)record.getValue(Tables.TABNAME);
            String comment = "";
            DB2TableDefinition table = new DB2TableDefinition(schema, name, comment);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (Record record : this.create().select(new Field[0]).from(new TableLike[]{this.create().select(new Field[]{Procedures.PROCSCHEMA.trim().as("schema"), Procedures.PROCNAME.as("name"), Factory.val((Object)true).as("isProcedure")}).from(new TableLike[]{Procedures.PROCEDURES}).where(new Condition[]{Procedures.PROCSCHEMA.in(this.getInputSchemata())}).unionAll((Select)this.create().select(new Field[]{Functions.FUNCSCHEMA.trim().as("schema"), Functions.FUNCNAME.as("name"), Factory.val((Object)false).as("isProcedure")}).from(new TableLike[]{Functions.FUNCTIONS}).where(new Condition[]{Functions.FUNCSCHEMA.in(this.getInputSchemata())}))}).orderBy(new Field[]{Factory.two()}).fetch()) {
            result.add(new DB2RoutineDefinition(this.getSchema(record.getValueAsString("schema")), record.getValueAsString("name"), null, record.getValueAsBoolean("isProcedure")));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        for (Record record : this.create().selectDistinct(new Field[]{Datatypes.TYPESCHEMA.trim(), Datatypes.TYPENAME}).from(new TableLike[]{Datatypes.DATATYPES}).where(new Condition[]{Datatypes.TYPESCHEMA.in(this.getInputSchemata())}).orderBy(new Field[]{Datatypes.TYPENAME}).fetch()) {
            result.add(new DB2UDTDefinition(this.getSchema((String)record.getValue(Datatypes.TYPESCHEMA.trim())), (String)record.getValue(Datatypes.TYPENAME), null));
        }
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }
}

