/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.oracle;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractRoutineDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultParameterDefinition;
import org.jooq.util.InOutDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.oracle.sys.Tables;

public class OracleRoutineDefinition
extends AbstractRoutineDefinition {
    private final BigDecimal objectId;

    public OracleRoutineDefinition(SchemaDefinition schema, PackageDefinition pkg, String name, String comment, BigDecimal objectId, String overload) {
        super(schema, pkg, name, comment, overload);
        this.objectId = objectId;
    }

    @Override
    protected void init0() throws SQLException {
        Result result = this.create().select(new Field[]{Tables.ALL_ARGUMENTS.IN_OUT, Tables.ALL_ARGUMENTS.ARGUMENT_NAME, Tables.ALL_ARGUMENTS.DATA_TYPE, Tables.ALL_ARGUMENTS.DATA_LENGTH, Tables.ALL_ARGUMENTS.DATA_PRECISION, Tables.ALL_ARGUMENTS.DATA_SCALE, Tables.ALL_ARGUMENTS.TYPE_NAME, Tables.ALL_ARGUMENTS.POSITION, Tables.ALL_ARGUMENTS.DEFAULTED}).from(new TableLike[]{Tables.ALL_ARGUMENTS}).where(new Condition[]{Tables.ALL_ARGUMENTS.OWNER.equal((Object)this.getSchema().getName())}).and(Tables.ALL_ARGUMENTS.OBJECT_NAME.equal((Object)this.getName())).and(Tables.ALL_ARGUMENTS.OBJECT_ID.equal((Object)this.objectId)).and(Tables.ALL_ARGUMENTS.OVERLOAD.equal((Object)this.getOverload())).and(Tables.ALL_ARGUMENTS.DATA_LEVEL.equal((Object)BigDecimal.ZERO)).and(Tables.ALL_ARGUMENTS.DATA_TYPE.isNotNull()).orderBy(new SortField[]{Tables.ALL_ARGUMENTS.POSITION.asc()}).fetch();
        for (Record record : result) {
            InOutDefinition inOut = InOutDefinition.getFromString((String)record.getValue(Tables.ALL_ARGUMENTS.IN_OUT));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.getValue(Tables.ALL_ARGUMENTS.DATA_TYPE), (Number)record.getValue(Tables.ALL_ARGUMENTS.DATA_LENGTH), (Number)record.getValue(Tables.ALL_ARGUMENTS.DATA_PRECISION), (Number)record.getValue(Tables.ALL_ARGUMENTS.DATA_SCALE), (String)record.getValue(Tables.ALL_ARGUMENTS.TYPE_NAME));
            String name = (String)record.getValue(Tables.ALL_ARGUMENTS.ARGUMENT_NAME);
            Integer position = record.getValueAsInteger(Tables.ALL_ARGUMENTS.POSITION);
            if (StringUtils.isBlank((String)name) && position == 0) {
                inOut = InOutDefinition.RETURN;
                name = "RETURN_VALUE";
            }
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, name, (int)position, (DataTypeDefinition)type, (Boolean)record.getValue(Tables.ALL_ARGUMENTS.DEFAULTED, Boolean.TYPE));
            this.addParameter(inOut, parameter);
        }
    }
}

