/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.sqlite;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Record;
import org.jooq.util.AbstractTableDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.SchemaDefinition;

public class SQLiteTableDefinition
extends AbstractTableDefinition {
    public SQLiteTableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        int position = 0;
        for (Record record : this.create().fetch("pragma table_info('" + this.getName() + "')")) {
            ++position;
            String name = record.getValueAsString("name");
            String dataType = record.getValueAsString("type").replaceAll("\\(\\d+\\)", "");
            Number precision = this.parsePrecision(record.getValueAsString("type"));
            Number scale = this.parseScale(record.getValueAsString("type"));
            boolean pk = record.getValueAsBoolean("pk");
            boolean identity = pk && (Boolean)this.create().fetchOne("select count(*) from sqlite_sequence where name = ?", new Object[]{this.getName()}).getValue(0, Boolean.class) != false;
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), dataType, precision, precision, scale);
            DefaultColumnDefinition column = new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), name, position, type, (Boolean)record.getValue("notnull", Boolean.TYPE) == false, identity, null);
            result.add(column);
        }
        return result;
    }
}

