/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.derby;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record5;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.SortOrder;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.derby.DerbyTableDefinition;
import org.jooq.meta.derby.sys.tables.Syschecks;
import org.jooq.meta.derby.sys.tables.Sysconglomerates;
import org.jooq.meta.derby.sys.tables.Sysconstraints;
import org.jooq.meta.derby.sys.tables.Syskeys;
import org.jooq.meta.derby.sys.tables.Sysschemas;
import org.jooq.meta.derby.sys.tables.Syssequences;
import org.jooq.meta.derby.sys.tables.Systables;
import org.jooq.meta.derby.sys.tables.Sysviews;

public class DerbyDatabase
extends AbstractDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("P")) {
            SchemaDefinition schema = this.getSchema((String)record.get(Sysschemas.SCHEMANAME));
            String key = (String)record.get(Sysconstraints.CONSTRAINTNAME);
            String tableName = (String)record.get(Systables.TABLENAME);
            String descriptor = (String)record.get(Sysconglomerates.DESCRIPTOR, String.class);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            for (int index : this.decode(descriptor)) {
                relations2.addPrimaryKey(key, table, table.getColumn(index));
            }
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("U")) {
            SchemaDefinition schema = this.getSchema((String)record.get(Sysschemas.SCHEMANAME));
            String key = (String)record.get(Sysconstraints.CONSTRAINTNAME);
            String tableName = (String)record.get(Systables.TABLENAME);
            String descriptor = (String)record.get(Sysconglomerates.DESCRIPTOR, String.class);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            for (int index : this.decode(descriptor)) {
                relations2.addUniqueKey(key, table, table.getColumn(index));
            }
        }
    }

    private Result<Record5<String, String, String, String, String>> fetchKeys(String constraintType) {
        return this.create().select(Sysschemas.SCHEMANAME, Systables.TABLENAME, Systables.TABLEID, Sysconstraints.CONSTRAINTNAME, Sysconglomerates.DESCRIPTOR).from((TableLike)Sysconglomerates.SYSCONGLOMERATES).join((TableLike)Syskeys.SYSKEYS).on(Syskeys.CONGLOMERATEID.equal(Sysconglomerates.CONGLOMERATEID)).join((TableLike)Sysconstraints.SYSCONSTRAINTS).on(Sysconstraints.CONSTRAINTID.equal(Syskeys.CONSTRAINTID)).join((TableLike)Systables.SYSTABLES).on(Systables.TABLEID.equal(Sysconglomerates.TABLEID)).join((TableLike)Sysschemas.SYSSCHEMAS).on(Sysschemas.SCHEMAID.equal(Systables.SCHEMAID)).and(Sysschemas.SCHEMANAME.cast(SQLDataType.VARCHAR((int)32672)).in(this.getInputSchemata())).where(Sysconstraints.TYPE.cast(SQLDataType.VARCHAR((int)32672)).equal((Object)constraintType)).orderBy(Sysschemas.SCHEMANAME, Systables.TABLENAME, Sysconstraints.CONSTRAINTNAME).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Field fkName = DSL.field((String)"fc.constraintname", String.class);
        Field fkTable = DSL.field((String)"ft.tablename", String.class);
        Field fkSchema = DSL.field((String)"fs.schemaname", String.class);
        Field fkDescriptor = DSL.field((String)"fg.descriptor");
        Field ukName = DSL.field((String)"pc.constraintname", String.class);
        Field ukTable = DSL.field((String)"pt.tablename", String.class);
        Field ukSchema = DSL.field((String)"ps.schemaname", String.class);
        for (Record record : this.create().select((SelectField)fkName, (SelectField)fkTable, (SelectField)fkSchema, (SelectField)fkDescriptor, (SelectField)ukName, (SelectField)ukTable, (SelectField)ukSchema).from("sys.sysconstraints   fc").join("sys.sysforeignkeys   f ").on("f.constraintid = fc.constraintid").join("sys.sysconglomerates fg").on("fg.conglomerateid = f.conglomerateid").join("sys.systables        ft").on("ft.tableid = fg.tableid").join("sys.sysschemas       fs").on("ft.schemaid = fs.schemaid").join("sys.sysconstraints   pc").on("pc.constraintid = f.keyconstraintid").join("sys.systables        pt").on("pt.tableid = pc.tableid").join("sys.sysschemas       ps").on("ps.schemaid = pt.schemaid").where("cast(fc.type as varchar(32672)) = 'F'").fetch()) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.get(fkSchema));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.get(ukSchema));
            String foreignKeyName = (String)record.get(fkName);
            String foreignKeyTableName = (String)record.get(fkTable);
            List<Integer> foreignKeyIndexes = this.decode((String)record.get(fkDescriptor, String.class));
            String uniqueKeyName = (String)record.get(ukName);
            String uniqueKeyTableName = (String)record.get(ukTable);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            TableDefinition uniqueKeyTable = this.getTable(uniqueKeySchema, uniqueKeyTableName);
            if (foreignKeyTable == null || uniqueKeyTable == null) continue;
            for (int i = 0; i < foreignKeyIndexes.size(); ++i) {
                relations2.addForeignKey(foreignKeyName, foreignKeyTable, foreignKeyTable.getColumn(foreignKeyIndexes.get(i)), uniqueKeyName, uniqueKeyTable);
            }
        }
    }

    private List<Integer> decode(String descriptor) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Pattern p = Pattern.compile(".*?\\((.*?)\\)");
        Matcher m = p.matcher(descriptor);
        while (m.find()) {
            String[] split = m.group(1).split(",");
            if (split == null) continue;
            for (String index : split) {
                result.add(Integer.valueOf(index.trim()) - 1);
            }
        }
        return result;
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        for (Record record : this.create().select(Sysschemas.SCHEMANAME, Systables.TABLENAME, Sysconstraints.CONSTRAINTNAME, Syschecks.CHECKDEFINITION).from((TableLike)Syschecks.SYSCHECKS).join((TableLike)Sysconstraints.SYSCONSTRAINTS).on(Syschecks.CONSTRAINTID.eq(Sysconstraints.CONSTRAINTID)).join((TableLike)Systables.SYSTABLES).on(Systables.TABLEID.equal(Sysconstraints.TABLEID)).join((TableLike)Sysschemas.SYSSCHEMAS).on(Sysschemas.SCHEMAID.equal(Systables.SCHEMAID)).where(Sysschemas.SCHEMANAME.in(this.getInputSchemata()))) {
            SchemaDefinition schema = this.getSchema((String)record.get(Sysschemas.SCHEMANAME));
            TableDefinition table = this.getTable(schema, (String)record.get(Systables.TABLENAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.get(Sysconstraints.CONSTRAINTNAME), (String)record.get(Syschecks.CHECKDEFINITION)));
        }
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        for (Record record : this.create().select(Sysschemas.SCHEMANAME, Systables.TABLENAME, Sysconglomerates.CONGLOMERATENAME, Sysconglomerates.DESCRIPTOR).from((TableLike)Sysconglomerates.SYSCONGLOMERATES).join((TableLike)Systables.SYSTABLES).on(Sysconglomerates.TABLEID.eq(Systables.TABLEID)).join((TableLike)Sysschemas.SYSSCHEMAS).on(Systables.SCHEMAID.eq(Sysschemas.SCHEMAID)).where(Sysschemas.SCHEMANAME.cast(SQLDataType.VARCHAR((int)32672)).in(this.getInputSchemata())).and(Sysconglomerates.ISINDEX).and(this.getIncludeSystemIndexes() ? DSL.noCondition() : DSL.not((Condition)DSL.condition(Sysconglomerates.ISCONSTRAINT))).orderBy(Sysschemas.SCHEMANAME, Systables.TABLENAME, Sysconglomerates.CONGLOMERATENAME)) {
            String descriptor;
            SchemaDefinition tableSchema = this.getSchema((String)record.get(Sysschemas.SCHEMANAME));
            if (tableSchema == null) continue;
            String indexName = (String)record.get(Sysconglomerates.CONGLOMERATENAME);
            String tableName = (String)record.get(Systables.TABLENAME);
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null || (descriptor = (String)record.get(Sysconglomerates.DESCRIPTOR)) == null) continue;
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, descriptor.toUpperCase().contains("UNIQUE")){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    List columnIndexes = DerbyDatabase.this.decode(descriptor);
                    for (int i = 0; i < columnIndexes.size(); ++i) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn((Integer)columnIndexes.get(i)), SortOrder.ASC, i + 1));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (String name : this.create().select(Sysschemas.SCHEMANAME).from((TableLike)Sysschemas.SYSSCHEMAS).fetch(Sysschemas.SCHEMANAME)) {
            result.add(new SchemaDefinition((Database)this, name, ""));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(Sysschemas.SCHEMANAME, Syssequences.SEQUENCENAME, Syssequences.SEQUENCEDATATYPE, (SelectField)DSL.nullif(Syssequences.STARTVALUE, (Object)DSL.one()).as(Syssequences.STARTVALUE), (SelectField)DSL.nullif(Syssequences.INCREMENT, (Object)DSL.one()).as(Syssequences.INCREMENT), (SelectField)DSL.nullif(Syssequences.MINIMUMVALUE, (Field)DSL.case_((Field)DSL.cast(Syssequences.SEQUENCEDATATYPE, (DataType)SQLDataType.VARCHAR)).when((Field)DSL.inline((String)"SMALLINT"), (Field)DSL.inline((long)-32768L)).when((Field)DSL.inline((String)"INTEGER"), (Field)DSL.inline((long)Integer.MIN_VALUE)).when((Field)DSL.inline((String)"BIGINT"), (Field)DSL.inline((long)Long.MIN_VALUE))).as(Syssequences.MINIMUMVALUE), (SelectField)DSL.nullif(Syssequences.MAXIMUMVALUE, (Field)DSL.case_((Field)DSL.cast(Syssequences.SEQUENCEDATATYPE, (DataType)SQLDataType.VARCHAR)).when((Field)DSL.inline((String)"SMALLINT"), (Field)DSL.inline((long)32767L)).when((Field)DSL.inline((String)"INTEGER"), (Field)DSL.inline((long)Integer.MAX_VALUE)).when((Field)DSL.inline((String)"BIGINT"), (Field)DSL.inline((long)Long.MAX_VALUE))).as(Syssequences.MAXIMUMVALUE), Syssequences.CYCLEOPTION).from((TableLike)Syssequences.SYSSEQUENCES).join((TableLike)Sysschemas.SYSSCHEMAS).on(Sysschemas.SCHEMAID.equal(Syssequences.SCHEMAID)).where(Sysschemas.SCHEMANAME.cast(SQLDataType.VARCHAR((int)32672)).in(this.getInputSchemata())).orderBy(Sysschemas.SCHEMANAME, Syssequences.SEQUENCENAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(Sysschemas.SCHEMANAME));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, (String)record.get(Syssequences.SEQUENCEDATATYPE));
            result.add(new DefaultSequenceDefinition(schema, (String)record.get(Syssequences.SEQUENCENAME), type, null, (Number)record.get(Syssequences.STARTVALUE), (Number)record.get(Syssequences.INCREMENT), (Number)record.get(Syssequences.MINIMUMVALUE), (Number)record.get(Syssequences.MAXIMUMVALUE), (Boolean)record.get(Syssequences.CYCLEOPTION, Boolean.class), null));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(Sysschemas.SCHEMANAME, Systables.TABLENAME, Systables.TABLEID, (SelectField)DSL.when((Condition)Systables.TABLETYPE.eq((Field)DSL.inline((String)"V")), (Field)DSL.inline((String)TableOptions.TableType.VIEW.name())).else_((Field)DSL.inline((String)TableOptions.TableType.TABLE.name())).as("table_type"), Sysviews.VIEWDEFINITION).from((TableLike)Systables.SYSTABLES).join((TableLike)Sysschemas.SYSSCHEMAS).on(Systables.SCHEMAID.equal(Sysschemas.SCHEMAID)).leftJoin((TableLike)Sysviews.SYSVIEWS).on(Systables.TABLEID.eq(Sysviews.TABLEID)).where(Sysschemas.SCHEMANAME.cast(SQLDataType.VARCHAR((int)32672)).in(this.getInputSchemata())).orderBy(Sysschemas.SCHEMANAME, Systables.TABLENAME)) {
            SchemaDefinition schema = this.getSchema((String)record.get(Sysschemas.SCHEMANAME));
            String name = (String)record.get(Systables.TABLENAME);
            String id = (String)record.get(Systables.TABLEID);
            TableOptions.TableType tableType = (TableOptions.TableType)record.get("table_type", TableOptions.TableType.class);
            String source = (String)record.get(Sysviews.VIEWDEFINITION);
            DerbyTableDefinition table = new DerbyTableDefinition(schema, name, id, tableType, source);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.DERBY);
    }
}

