/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.sqlite;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.sqlite.sqlite_master.SQLiteMaster;

public class SQLiteTableDefinition
extends AbstractTableDefinition {
    private static Boolean existsSqliteSequence;

    public SQLiteTableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    public SQLiteTableDefinition(SchemaDefinition schema, String name, String comment, TableOptions.TableType tableType, String source) {
        super(schema, name, comment, tableType, source);
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        Field fName = DSL.field((Name)DSL.name((String)"name"), String.class);
        Field fType = DSL.field((Name)DSL.name((String)"type"), String.class);
        Field fNotnull = DSL.field((Name)DSL.name((String)"notnull"), Boolean.TYPE);
        Field fDefaultValue = DSL.field((Name)DSL.name((String)"dflt_value"), String.class);
        Field fPk = DSL.field((Name)DSL.name((String)"pk"), Integer.TYPE);
        int position = 0;
        for (Record record : this.create().select((SelectField)fName, (SelectField)fType, (SelectField)fNotnull, (SelectField)fDefaultValue, (SelectField)fPk).from("pragma_table_info({0})", new QueryPart[]{DSL.inline((String)this.getName())}).fetch()) {
            ++position;
            String name = (String)record.get(fName);
            String dataType = ((String)record.get(fType)).replaceAll("\\(\\d+(\\s*,\\s*\\d+)?\\)", "");
            Number precision = this.parsePrecision((String)record.get(fType));
            Number scale = this.parseScale((String)record.get(fType));
            int pk = (Integer)record.get(fPk);
            boolean identity = false;
            if (pk > 0 && !(identity |= this.existsSqliteSequence() && (Boolean)this.create().fetchOne("select count(*) from sqlite_sequence where name = ?", new Object[]{this.getName()}).get(0, Boolean.class) != false) && !this.create().fetchExists((Select)DSL.selectOne().from("{0}", new QueryPart[]{DSL.name((String)this.getName())}))) {
                identity = ((String)this.create().select(SQLiteMaster.SQL).from((TableLike)SQLiteMaster.SQLITE_MASTER).where(SQLiteMaster.NAME.eq((Object)this.getName())).fetchOneInto(String.class)).matches("(?s:.*\\b" + this.getName() + "\\b[^,]*(?i:\\bautoincrement\\b)[^,]*.*)");
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), dataType, precision, precision, scale, (Boolean)((Boolean)record.get(fNotnull) == false ? 1 : 0), (String)record.get(fDefaultValue));
            DefaultColumnDefinition column = new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), name, position, (DataTypeDefinition)type, identity, null);
            result.add(column);
        }
        return result;
    }

    private boolean existsSqliteSequence() {
        if (existsSqliteSequence == null) {
            existsSqliteSequence = (Boolean)this.create().selectCount().from((TableLike)SQLiteMaster.SQLITE_MASTER).where(SQLiteMaster.NAME.lower().eq((Object)"sqlite_sequence")).fetchOne(0, Boolean.TYPE);
        }
        return existsSqliteSequence;
    }
}

