/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.firebird;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record3;
import org.jooq.Record4;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SortOrder;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultDomainDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.firebird.FirebirdRoutineDefinition;
import org.jooq.meta.firebird.FirebirdTableDefinition;
import org.jooq.meta.firebird.FirebirdTableValuedFunction;
import org.jooq.meta.firebird.rdb.Tables;
import org.jooq.meta.firebird.rdb.tables.Rdb$checkConstraints;
import org.jooq.meta.firebird.rdb.tables.Rdb$fields;
import org.jooq.meta.firebird.rdb.tables.Rdb$indexSegments;
import org.jooq.meta.firebird.rdb.tables.Rdb$indices;
import org.jooq.meta.firebird.rdb.tables.Rdb$refConstraints;
import org.jooq.meta.firebird.rdb.tables.Rdb$relationConstraints;
import org.jooq.meta.firebird.rdb.tables.Rdb$triggers;
import org.jooq.meta.jaxb.SchemaMappingType;
import org.jooq.tools.StringUtils;
import org.jooq.util.firebird.FirebirdDataType;

public class FirebirdDatabase
extends AbstractDatabase {
    private static Boolean is30;

    public FirebirdDatabase() {
        SchemaMappingType schema = new SchemaMappingType();
        schema.setInputSchema("");
        schema.setOutputSchema("");
        ArrayList<SchemaMappingType> schemata = new ArrayList<SchemaMappingType>();
        schemata.add(schema);
        this.setConfiguredSchemata(schemata);
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations r) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            String tableName = (String)record.get(Tables.RDB$RELATION_CONSTRAINTS.RDB$RELATION_NAME.trim());
            String fieldName = (String)record.get(Tables.RDB$INDEX_SEGMENTS.RDB$FIELD_NAME.trim());
            String key = (String)record.get(Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_NAME.trim());
            TableDefinition td = this.getTable(this.getSchemata().get(0), tableName);
            if (td == null) continue;
            r.addPrimaryKey(key, td, td.getColumn(fieldName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations r) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            String tableName = (String)record.get(Tables.RDB$RELATION_CONSTRAINTS.RDB$RELATION_NAME.trim());
            String fieldName = (String)record.get(Tables.RDB$INDEX_SEGMENTS.RDB$FIELD_NAME.trim());
            String key = (String)record.get(Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_NAME.trim());
            TableDefinition td = this.getTable(this.getSchemata().get(0), tableName);
            if (td == null) continue;
            r.addUniqueKey(key, td, td.getColumn(fieldName));
        }
    }

    private Result<Record3<String, String, String>> fetchKeys(String constraintType) {
        return this.create().select((SelectField)Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_NAME.trim(), (SelectField)Tables.RDB$RELATION_CONSTRAINTS.RDB$RELATION_NAME.trim(), (SelectField)Tables.RDB$INDEX_SEGMENTS.RDB$FIELD_NAME.trim()).from((TableLike)Tables.RDB$RELATION_CONSTRAINTS).join((TableLike)Tables.RDB$INDEX_SEGMENTS).on(Tables.RDB$INDEX_SEGMENTS.RDB$INDEX_NAME.eq(Tables.RDB$RELATION_CONSTRAINTS.RDB$INDEX_NAME)).where(Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_TYPE.eq((Object)constraintType)).orderBy((OrderField)Tables.RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_NAME.asc(), (OrderField)Tables.RDB$INDEX_SEGMENTS.RDB$FIELD_POSITION.asc()).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Rdb$relationConstraints pk = Tables.RDB$RELATION_CONSTRAINTS.as("pk");
        Rdb$relationConstraints fk = Tables.RDB$RELATION_CONSTRAINTS.as("fk");
        Rdb$refConstraints rc = Tables.RDB$REF_CONSTRAINTS.as("rc");
        Rdb$indexSegments isp = Tables.RDB$INDEX_SEGMENTS.as("isp");
        Rdb$indexSegments isf = Tables.RDB$INDEX_SEGMENTS.as("isf");
        for (Record record : this.create().selectDistinct((SelectField)fk.RDB$CONSTRAINT_NAME.trim().as("fk"), (SelectField)fk.RDB$RELATION_NAME.trim().as("fkTable"), (SelectField)isf.RDB$FIELD_NAME.trim().as("fkField"), (SelectField)pk.RDB$CONSTRAINT_NAME.trim().as("pk"), (SelectField)pk.RDB$RELATION_NAME.trim().as("pkTable")).from((TableLike)fk).join((TableLike)rc).on(fk.RDB$CONSTRAINT_NAME.eq(rc.RDB$CONSTRAINT_NAME)).join((TableLike)pk).on(pk.RDB$CONSTRAINT_NAME.eq(rc.RDB$CONST_NAME_UQ)).join((TableLike)isp).on(isp.RDB$INDEX_NAME.eq(pk.RDB$INDEX_NAME)).join((TableLike)isf).on(isf.RDB$INDEX_NAME.eq(fk.RDB$INDEX_NAME)).where(isp.RDB$FIELD_POSITION.eq(isf.RDB$FIELD_POSITION)).orderBy((OrderField)fk.RDB$CONSTRAINT_NAME.asc(), (OrderField)isf.RDB$FIELD_POSITION.asc()).fetch()) {
            String pkName = (String)record.get("pk", String.class);
            String pkTable = (String)record.get("pkTable", String.class);
            String fkName = (String)record.get("fk", String.class);
            String fkTable = (String)record.get("fkTable", String.class);
            String fkField = (String)record.get("fkField", String.class);
            TableDefinition foreignKeyTable = this.getTable(this.getSchemata().get(0), fkTable, true);
            TableDefinition primaryKeyTable = this.getTable(this.getSchemata().get(0), pkTable, true);
            if (primaryKeyTable == null || foreignKeyTable == null) continue;
            relations2.addForeignKey(fkName, foreignKeyTable, foreignKeyTable.getColumn(fkField), pkName, primaryKeyTable);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        Rdb$relationConstraints r = Tables.RDB$RELATION_CONSTRAINTS.as("r");
        Rdb$checkConstraints c = Tables.RDB$CHECK_CONSTRAINTS.as("c");
        Rdb$triggers t = Tables.RDB$TRIGGERS.as("t");
        for (Record record : this.create().select((SelectField)r.RDB$RELATION_NAME.trim().as(r.RDB$RELATION_NAME), (SelectField)r.RDB$CONSTRAINT_NAME.trim().as(r.RDB$CONSTRAINT_NAME), (SelectField)DSL.max((Field)t.RDB$TRIGGER_SOURCE.trim()).as(t.RDB$TRIGGER_SOURCE)).from((TableLike)r).join((TableLike)c).on(r.RDB$CONSTRAINT_NAME.eq(c.RDB$CONSTRAINT_NAME)).join((TableLike)t).on(c.RDB$TRIGGER_NAME.eq(t.RDB$TRIGGER_NAME)).where(r.RDB$CONSTRAINT_TYPE.eq((Field)DSL.inline((String)"CHECK"))).groupBy(new GroupField[]{r.RDB$RELATION_NAME, r.RDB$CONSTRAINT_NAME}).orderBy(r.RDB$RELATION_NAME, r.RDB$CONSTRAINT_NAME)) {
            SchemaDefinition schema = this.getSchemata().get(0);
            TableDefinition table = this.getTable(schema, (String)record.get(r.RDB$RELATION_NAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.get(r.RDB$CONSTRAINT_NAME), (String)record.get(t.RDB$TRIGGER_SOURCE)));
        }
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        Rdb$relationConstraints c = Tables.RDB$RELATION_CONSTRAINTS.as("c");
        Rdb$indices i = Tables.RDB$INDICES.as("i");
        final Rdb$indexSegments s = Tables.RDB$INDEX_SEGMENTS.as("s");
        Map indexes = this.create().select((SelectField)s.rdb$indices().RDB$RELATION_NAME.trim().as(i.RDB$RELATION_NAME), (SelectField)s.rdb$indices().RDB$INDEX_NAME.trim().as(i.RDB$INDEX_NAME), s.rdb$indices().RDB$UNIQUE_FLAG, (SelectField)s.RDB$FIELD_NAME.trim().as(s.RDB$FIELD_NAME), s.RDB$FIELD_POSITION).from((TableLike)s).where(s.rdb$indices().RDB$INDEX_NAME.notIn((Select)DSL.select(c.RDB$CONSTRAINT_NAME).from((TableLike)c))).orderBy(s.rdb$indices().RDB$RELATION_NAME, s.rdb$indices().RDB$INDEX_NAME, s.RDB$FIELD_POSITION).fetchGroups(new Field[]{i.RDB$RELATION_NAME, i.RDB$INDEX_NAME, i.RDB$UNIQUE_FLAG}, new Field[]{s.RDB$FIELD_NAME, s.RDB$FIELD_POSITION});
        block0: for (Map.Entry entry : indexes.entrySet()) {
            Record index = (Record)entry.getKey();
            final Result columns = (Result)entry.getValue();
            SchemaDefinition schema = this.getSchemata().get(0);
            String indexName = (String)index.get(i.RDB$INDEX_NAME);
            String tableName = (String)index.get(i.RDB$RELATION_NAME);
            final TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            boolean unique = (Boolean)index.get(i.RDB$UNIQUE_FLAG, Boolean.TYPE);
            for (Record column : columns) {
                if (table.getColumn((String)column.get(s.RDB$FIELD_NAME)) != null) continue;
                continue block0;
            }
            result.add(new AbstractIndexDefinition(schema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (Record column : columns) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn((String)column.get(s.RDB$FIELD_NAME)), SortOrder.ASC, (Integer)column.get(s.RDB$FIELD_POSITION, Integer.TYPE)));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        result.add(new SchemaDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select((SelectField)DSL.trim(Tables.RDB$GENERATORS.RDB$GENERATOR_NAME).as(Tables.RDB$GENERATORS.RDB$GENERATOR_NAME), (SelectField)(this.is30() ? DSL.nullif(Tables.RDB$GENERATORS.RDB$INITIAL_VALUE, (Object)DSL.zero()) : DSL.zero()).as(Tables.RDB$GENERATORS.RDB$INITIAL_VALUE), (SelectField)(this.is30() ? DSL.nullif(Tables.RDB$GENERATORS.RDB$GENERATOR_INCREMENT, (Field)DSL.one()) : DSL.one()).as(Tables.RDB$GENERATORS.RDB$GENERATOR_INCREMENT)).from((TableLike)Tables.RDB$GENERATORS).orderBy(new int[]{1})) {
            SchemaDefinition schema = this.getSchemata().get(0);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, FirebirdDataType.BIGINT.getTypeName());
            result.add(new DefaultSequenceDefinition(schema, (String)record.get(Tables.RDB$GENERATORS.RDB$GENERATOR_NAME), type, null, (Number)record.get(Tables.RDB$GENERATORS.RDB$INITIAL_VALUE), (Number)record.get(Tables.RDB$GENERATORS.RDB$GENERATOR_INCREMENT), null, null, false, null));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record4 record : this.create().select((SelectField)Tables.RDB$RELATIONS.RDB$RELATION_NAME.trim(), (SelectField)Tables.RDB$RELATIONS.RDB$DESCRIPTION.trim(), (SelectField)DSL.when((Condition)Tables.RDB$RELATIONS.RDB$RELATION_TYPE.eq((Field)DSL.inline((short)1)), (Field)DSL.inline((String)TableOptions.TableType.VIEW.name())).else_((Field)DSL.inline((String)TableOptions.TableType.TABLE.name())).trim().as("table_type"), (SelectField)DSL.when((Condition)Tables.RDB$RELATIONS.RDB$VIEW_SOURCE.lower().like((Field)DSL.inline((String)"create%")), (Field)Tables.RDB$RELATIONS.RDB$VIEW_SOURCE.trim()).else_(DSL.inline((String)"create view \"").concat(new Field[]{Tables.RDB$RELATIONS.RDB$RELATION_NAME.trim()}).concat(new String[]{"\" as "}).concat(new Field[]{Tables.RDB$RELATIONS.RDB$VIEW_SOURCE})).as("view_source")).from((TableLike)Tables.RDB$RELATIONS).unionAll((Select)DSL.select((SelectField)Tables.RDB$PROCEDURES.RDB$PROCEDURE_NAME.trim(), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)TableOptions.TableType.FUNCTION.name()).trim(), (SelectField)DSL.inline((String)"")).from((TableLike)Tables.RDB$PROCEDURES).where(Tables.RDB$PROCEDURES.RDB$PROCEDURE_TYPE.eq((Object)1)).and((Condition)(this.tableValuedFunctions() ? DSL.noCondition() : DSL.falseCondition()))).orderBy(new int[]{1})) {
            TableOptions.TableType tableType = (TableOptions.TableType)record.get("table_type", TableOptions.TableType.class);
            if (TableOptions.TableType.FUNCTION == tableType) {
                result.add(new FirebirdTableValuedFunction(this.getSchemata().get(0), (String)record.value1(), ""));
                continue;
            }
            result.add(new FirebirdTableDefinition(this.getSchemata().get(0), (String)record.value1(), (String)record.value2(), tableType, (String)record.value4()));
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (String procedureName : this.create().select((SelectField)Tables.RDB$PROCEDURES.RDB$PROCEDURE_NAME.trim()).from((TableLike)Tables.RDB$PROCEDURES).where(Tables.RDB$PROCEDURES.RDB$PROCEDURE_TYPE.eq((Object)2)).orderBy(new int[]{1}).fetch(0, String.class)) {
            result.add(new FirebirdRoutineDefinition(this.getSchemata().get(0), procedureName));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        Rdb$fields f = Tables.RDB$FIELDS;
        for (Record record : this.create().select((SelectField)DSL.trim(f.RDB$FIELD_NAME).as(f.RDB$FIELD_NAME), (SelectField)FirebirdDatabase.CHARACTER_LENGTH(f).as("CHAR_LEN"), f.RDB$FIELD_PRECISION, (SelectField)FirebirdDatabase.FIELD_SCALE(f).as("FIELD_SCALE"), (SelectField)FirebirdDatabase.FIELD_TYPE(f).as("FIELD_TYPE"), (SelectField)DSL.bitOr((Field)f.RDB$NULL_FLAG.nvl((Object)0), (Field)f.RDB$NULL_FLAG.nvl((Object)0)).as(f.RDB$NULL_FLAG), (SelectField)DSL.trim(f.RDB$VALIDATION_SOURCE).as(f.RDB$VALIDATION_SOURCE), (SelectField)DSL.trim(f.RDB$DEFAULT_SOURCE).as(f.RDB$DEFAULT_SOURCE)).from((TableLike)f).where((Condition)f.RDB$FIELD_NAME.notLike(DSL.any((Object[])new String[]{"RDB$%", "SEC$%", "MON$%"}))).orderBy(f.RDB$FIELD_NAME)) {
            SchemaDefinition schema = this.getSchemata().get(0);
            DefaultDataTypeDefinition baseType = new DefaultDataTypeDefinition((Database)this, schema, (String)record.get("FIELD_TYPE", String.class), (Number)record.get("CHAR_LEN", Short.TYPE), (Number)record.get(f.RDB$FIELD_PRECISION), (Number)record.get("FIELD_SCALE", Integer.class), (Boolean)((Short)record.get(f.RDB$NULL_FLAG) == 0 ? 1 : 0), record.get(f.RDB$DEFAULT_SOURCE) == null ? null : ((String)record.get(f.RDB$DEFAULT_SOURCE)).replaceAll("(?i:default )", ""));
            DefaultDomainDefinition domain = new DefaultDomainDefinition(schema, (String)record.get(f.RDB$FIELD_NAME), baseType);
            if (!StringUtils.isBlank((String)((String)record.get(f.RDB$VALIDATION_SOURCE)))) {
                domain.addCheckClause(((String)record.get(f.RDB$VALIDATION_SOURCE)).replaceAll("(?i:check )", ""));
            }
            result.add(domain);
        }
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.FIREBIRD);
    }

    static Field<String> FIELD_TYPE(Rdb$fields f) {
        return DSL.decode().value(f.RDB$FIELD_TYPE).when((Object)7, DSL.decode().when(f.RDB$FIELD_SUB_TYPE.eq((Object)1), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)0).and(f.RDB$FIELD_SCALE.lt((Object)0)), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)2), (Object)"DECIMAL").otherwise((Object)"SMALLINT")).when((Object)8, DSL.decode().when(f.RDB$FIELD_SUB_TYPE.eq((Object)1), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)0).and(f.RDB$FIELD_SCALE.lt((Object)0)), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)2), (Object)"DECIMAL").otherwise((Object)"INTEGER")).when((Object)9, (Object)"QUAD").when((Object)10, (Object)"FLOAT").when((Object)11, (Object)"D_FLOAT").when((Object)12, (Object)"DATE").when((Object)13, (Object)"TIME").when((Object)14, (Object)"CHAR").when((Object)16, DSL.decode().when(f.RDB$FIELD_SUB_TYPE.eq((Object)1), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)0).and(f.RDB$FIELD_SCALE.lt((Object)0)), (Object)"NUMERIC").when(f.RDB$FIELD_SUB_TYPE.eq((Object)2), (Object)"DECIMAL").otherwise((Object)"BIGINT")).when((Object)27, (Object)"DOUBLE").when((Object)35, (Object)"TIMESTAMP").when((Object)37, (Object)"VARCHAR").when((Object)40, (Object)"CSTRING").when((Object)261, DSL.decode().value(f.RDB$FIELD_SUB_TYPE).when((Object)0, (Object)"BLOB").when((Object)1, (Object)"BLOB SUB_TYPE TEXT").otherwise((Object)"BLOB")).otherwise((Object)"UNKNOWN");
    }

    static Field<Short> FIELD_SCALE(Rdb$fields f) {
        return f.RDB$FIELD_SCALE.neg();
    }

    static Field<Short> CHARACTER_LENGTH(Rdb$fields f) {
        return DSL.choose(f.RDB$FIELD_TYPE).when((Object)261, (Object)0).otherwise(f.RDB$CHARACTER_LENGTH);
    }

    boolean is30() {
        if (is30 == null) {
            is30 = this.exists(Tables.RDB$GENERATORS.RDB$INITIAL_VALUE);
        }
        return is30;
    }
}

