/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent.http;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.http.AbstractAutomaticLoginStrategy;

public class UrlBasedAutomaticLoginStrategy
extends AbstractAutomaticLoginStrategy {
    private static final Log log = LogFactory.getLog((Class)UrlBasedAutomaticLoginStrategy.class);
    private List urlPatterns = new ArrayList();

    public UrlBasedAutomaticLoginStrategy() {
    }

    public UrlBasedAutomaticLoginStrategy(String mode) {
        super(mode);
    }

    public boolean isAutomaticLoginRequired(HttpServletRequest hreq, HttpServletResponse hres) {
        boolean autoLoginRequired = true;
        if (this.urlPatterns != null && this.urlPatterns.size() > 0) {
            String requestURL = this.getRequestURL(hreq);
            for (int i = 0; i < this.urlPatterns.size(); ++i) {
                String urlPattern = (String)this.urlPatterns.get(i);
                Pattern p = Pattern.compile(urlPattern);
                Matcher m = p.matcher(requestURL);
                if (!m.matches()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Autologin is not required! Ignored url pattern: " + urlPattern));
                }
                autoLoginRequired = false;
                break;
            }
        }
        return autoLoginRequired;
    }

    private String getRequestURL(HttpServletRequest hreq) {
        StringBuffer sb = new StringBuffer(hreq.getRequestURI());
        if (hreq.getQueryString() != null) {
            String q = hreq.getQueryString();
            if (!q.startsWith("?")) {
                sb.append('?');
            }
            sb.append(q);
        }
        return sb.toString();
    }

    public List getUrlPatterns() {
        return this.urlPatterns;
    }

    public void setIgnoredUrlPatterns(List urlPatterns) {
        this.urlPatterns = urlPatterns;
    }
}

