/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.josso.agent.AbstractSSOAgent;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SSOPartnerAppConfig;
import org.josso.agent.http.FrontChannelParametersBuilder;
import org.josso.agent.http.HttpSSOAgentRequest;
import org.josso.gateway.SSONameValuePair;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.SSOIdentityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpSSOAgent
extends AbstractSSOAgent {
    private static final String JOSSO_LOGIN_URI = "/josso_login/";
    private static final String JOSSO_USER_LOGIN_URI = "/josso_user_login/";
    private static final String JOSSO_SECURITY_CHECK_URI = "/josso_security_check";
    private static final String JOSSO_LOGOUT_URI = "/josso_logout/";
    private static final String JOSSO_AUTHENTICATION_URI = "/josso_authentication/";
    private List<FrontChannelParametersBuilder> _builders = new ArrayList<FrontChannelParametersBuilder>();

    @Override
    public void start() {
        super.start();
    }

    @Override
    protected boolean isAuthenticationAlwaysRequired() {
        return false;
    }

    @Override
    protected void propagateSecurityContext(SSOAgentRequest request, Principal principal) {
        SSOPartnerAppConfig partnerAppConfig;
        HttpSSOAgentRequest servletSSOAgentRequest = (HttpSSOAgentRequest)request;
        String contextPath = servletSSOAgentRequest.getRequest().getContextPath();
        if ("".equals(contextPath)) {
            contextPath = "/";
        }
        if ((partnerAppConfig = this.getPartnerAppConfig(servletSSOAgentRequest.getRequest().getServerName(), contextPath)).getSecurityContextPropagationConfig() == null) {
            return;
        }
        String binding = partnerAppConfig.getSecurityContextPropagationConfig().getBinding();
        String userPlaceHolder = partnerAppConfig.getSecurityContextPropagationConfig().getUserPlaceHolder();
        String rolesPlaceHolder = partnerAppConfig.getSecurityContextPropagationConfig().getRolesPlaceHolder();
        String propertiesPlaceholder = partnerAppConfig.getSecurityContextPropagationConfig().getPropertiesPlaceHolder();
        String user = principal.getName();
        if (binding != null && userPlaceHolder != null && rolesPlaceHolder != null) {
            SSORole[] roleSets;
            try {
                roleSets = this.im.findRolesBySSOSessionId(servletSSOAgentRequest.getSessionId());
            }
            catch (SSOIdentityException e) {
                if (this.debug > 0) {
                    this.log("Error fetching roles for SSO Session [" + servletSSOAgentRequest.getSessionId() + "]" + " on attempting to propagate security context, aborting");
                }
                return;
            }
            HttpServletRequest hreq = servletSSOAgentRequest.getRequest();
            if (binding.equalsIgnoreCase("HTTP_HEADERS")) {
                HashMap headers = new HashMap();
                ArrayList<String> users = new ArrayList<String>();
                users.add(user);
                headers.put(userPlaceHolder, users);
                if (this.debug > 0) {
                    this.log("Propagated user [" + user + "] onto HTTP Header [" + userPlaceHolder + "]");
                }
                ArrayList<String> roles = new ArrayList<String>();
                for (int i = 0; i < roleSets.length; ++i) {
                    SSORole roleSet = roleSets[i];
                    roles.add(roleSet.getName());
                    if (this.debug <= 0) continue;
                    this.log("Propagated role [" + roleSet.getName() + "] onto HTTP_HEADERS based security context");
                }
                headers.put(rolesPlaceHolder, roles);
                hreq.setAttribute("org.josso.agent.http.securitycontext.binding", (Object)"HTTP_HEADERS_BINDING");
                hreq.setAttribute("org.josso.agent.http.securitycontext.content", headers);
            } else if (binding.equalsIgnoreCase("HREQ_ATTRS")) {
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put(userPlaceHolder, user);
                for (int i = 0; i < roleSets.length; ++i) {
                    SSORole roleSet = roleSets[i];
                    attrs.put(rolesPlaceHolder + "_" + i, roleSet.getName());
                    if (this.debug <= 0) continue;
                    this.log("Propagated role [" + roleSet.getName() + "] onto HREQ_ATTRS based security context");
                }
                SSOUser usr = (SSOUser)principal;
                if (usr.getProperties() != null) {
                    Properties props = new Properties();
                    for (int i = 0; i < usr.getProperties().length; ++i) {
                        attrs.put(propertiesPlaceholder + "_" + usr.getProperties()[i].getName(), usr.getProperties()[i].getValue());
                        if (this.debug <= 0) continue;
                        this.log("Propagated role [" + usr.getProperties()[i].getName() + "=" + usr.getProperties()[i].getValue() + "] onto HREQ_ATTRS based security context");
                    }
                }
                hreq.setAttribute("org.josso.agent.http.securitycontext.content", attrs);
                hreq.setAttribute("org.josso.agent.http.securitycontext.binding", (Object)"HTTP_REQ_ATTRS_BINDING");
            }
        }
    }

    public boolean isAutomaticLoginRequired(HttpServletRequest hreq) {
        block14: {
            try {
                Boolean autoLoginExecuted = (Boolean)hreq.getSession().getAttribute("JOSSO_AUTOMATIC_LOGIN_EXECUTED");
                if (autoLoginExecuted == null || !autoLoginExecuted.booleanValue()) {
                    if (this.debug > 0) {
                        this.log("No referer found and automatic login was never executed.  Require Autologin!");
                    }
                    hreq.getSession().setAttribute("JOSSO_AUTOMATIC_LOGIN_EXECUTED", (Object)Boolean.TRUE);
                    return true;
                }
                String referer = hreq.getHeader("referer");
                if (referer != null && !"".equals(referer)) {
                    String oldReferer = (String)hreq.getSession().getAttribute("JOSSO_AUTOMATIC_LOGIN_REFERER");
                    if (oldReferer != null && oldReferer.equals(referer)) {
                        if (this.debug > 0) {
                            this.log("Referer already processed " + referer);
                        }
                        hreq.getSession().removeAttribute("JOSSO_AUTOMATIC_LOGIN_REFERER");
                        return false;
                    }
                    StringBuffer mySelf = hreq.getRequestURL();
                    URL myUrl = new URL(mySelf.toString());
                    String myUrlStr = myUrl.getProtocol() + "://" + myUrl.getHost() + (myUrl.getPort() > 0 && myUrl.getPort() != 80 && myUrl.getPort() != 443 ? ":" + myUrl.getPort() : "") + hreq.getContextPath() + "/";
                    if (this.debug > 0) {
                        this.log("Processing referer " + referer + " for host " + myUrlStr);
                    }
                    if (!referer.startsWith(myUrlStr)) {
                        if (this.debug > 0) {
                            this.log("Referer found differs from current host.  Require Autologin!");
                        }
                        hreq.getSession().setAttribute("JOSSO_AUTOMATIC_LOGIN_REFERER", (Object)referer);
                        return true;
                    }
                    break block14;
                }
                String oldReferer = (String)hreq.getSession().getAttribute("JOSSO_AUTOMATIC_LOGIN_REFERER");
                if (oldReferer != null && oldReferer.equals("NO_REFERER")) {
                    if (this.debug > 0) {
                        this.log("Referer already processed " + referer);
                    }
                    hreq.getSession().removeAttribute("JOSSO_AUTOMATIC_LOGIN_REFERER");
                    return false;
                }
                hreq.getSession().setAttribute("JOSSO_AUTOMATIC_LOGIN_REFERER", (Object)"NO_REFERER");
                return true;
            }
            catch (MalformedURLException e) {
                this.log("Error creating Referer URL : " + e.getMessage(), e);
            }
            catch (Exception e) {
                this.log("Cannot verify request for automatic login : " + e.getMessage(), e);
            }
        }
        if (this.debug > 0) {
            this.log("Do not Require Autologin!");
        }
        return false;
    }

    public void clearAutomaticLoginReferer(HttpServletRequest hreq) {
        hreq.getSession().removeAttribute("JOSSO_AUTOMATIC_LOGIN_REFERER");
    }

    public String buildLogoutUrl(HttpServletRequest hreq) {
        return this.buildLogoutUrl(hreq, "/");
    }

    public String buildLogoutUrl(HttpServletRequest hreq, SSOPartnerAppConfig cfg) {
        return this.buildLogoutUrl(hreq, cfg.getDefaultResource() != null ? cfg.getDefaultResource() : "/");
    }

    public String buildLogoutUrl(HttpServletRequest hreq, String backToPath) {
        String backto = this.buildBackToURL(hreq, backToPath);
        String logoutUrl = this.getGatewayLogoutUrl() + (backto != null ? "?josso_back_to=" + backto : "");
        logoutUrl = logoutUrl + this.buildLogoutUrlParams(hreq);
        return logoutUrl;
    }

    public String buildLoginUrl(HttpServletRequest hreq) {
        String loginUrl = this.getGatewayLoginUrl();
        String backto = this.buildBackToURL(hreq, this.getJOSSOSecurityCheckUri());
        loginUrl = loginUrl + "?josso_back_to=" + backto;
        loginUrl = loginUrl + this.buildLoginUrlParams(hreq);
        return loginUrl;
    }

    public String buildLoginOptionalUrl(HttpServletRequest hreq) {
        String loginUrl = this.getGatewayLoginUrl();
        String backto = this.buildBackToURL(hreq, this.getJOSSOSecurityCheckUri());
        loginUrl = loginUrl + "?josso_cmd=login_optional&josso_back_to=" + backto;
        loginUrl = loginUrl + this.buildLoginUrlParams(hreq);
        return loginUrl;
    }

    public String buildBackToURL(HttpServletRequest hreq, String uri) {
        String backto = null;
        String contextPath = hreq.getContextPath();
        if (contextPath == null || "".equals(contextPath)) {
            contextPath = "/";
        }
        String reverseProxyHost = hreq.getHeader("Josso-ReversE-Proxy");
        String singlePointOfAccess = this.getSinglePointOfAccess();
        if (singlePointOfAccess != null) {
            if (this.debug >= 1) {
                this.log("josso_back_to option : singlePointOfAccess: " + singlePointOfAccess);
            }
            backto = singlePointOfAccess + contextPath + uri;
        } else if (reverseProxyHost != null) {
            if (this.debug >= 1) {
                this.log("josso_back_to option : reverse-proxy-host: " + reverseProxyHost);
            }
            backto = reverseProxyHost + contextPath + uri;
        } else {
            StringBuffer mySelf = HttpUtils.getRequestURL((HttpServletRequest)hreq);
            try {
                URL url = new URL(mySelf.toString());
                backto = url.getProtocol() + "://" + url.getHost() + (url.getPort() > 0 ? ":" + url.getPort() : "");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            backto = backto + (contextPath.endsWith("/") ? contextPath.substring(0, contextPath.length() - 1) : contextPath) + uri;
        }
        if (this.debug >= 1) {
            this.log("Using josso_back_to : " + backto);
        }
        return backto;
    }

    public String buildPostAuthUrl(HttpServletResponse hres, String requestURI, String postAuthURI) {
        String encURL = requestURI.replaceAll("&", "%26").replaceAll("\\?", "%3F");
        return hres.encodeRedirectURL(postAuthURI + "?josso_original_resource=" + hres.encodeURL(encURL));
    }

    public Cookie newJossoCookie(String path, String value) {
        if (path == null || "".equals(path)) {
            path = "/";
        }
        Cookie ssoCookie = new Cookie("JOSSO_SESSIONID", value);
        ssoCookie.setMaxAge(-1);
        ssoCookie.setPath(path);
        return ssoCookie;
    }

    public String buildAutomaticSubmitForm(HttpServletRequest request) {
        return null;
    }

    protected String buildLoginUrlParams(HttpServletRequest hreq) {
        String urlParams = "";
        for (FrontChannelParametersBuilder builder : this._builders) {
            SSONameValuePair[] params;
            for (SSONameValuePair param : params = builder.buildParamters(hreq)) {
                urlParams = urlParams + "&" + param.getName() + "=" + param.getValue();
            }
        }
        return urlParams;
    }

    protected String buildLogoutUrlParams(HttpServletRequest hreq) {
        String urlParams = "";
        for (FrontChannelParametersBuilder builder : this._builders) {
            SSONameValuePair[] params;
            for (SSONameValuePair param : params = builder.buildParamters(hreq)) {
                urlParams = urlParams + "&" + param.getName() + "=" + param.getValue();
            }
        }
        return urlParams;
    }

    @Override
    protected void sendCustomAuthentication(SSOAgentRequest request) throws IOException {
        AbstractStringBuilder sb;
        HttpServletRequest hreq = ((HttpSSOAgentRequest)request).getRequest();
        HttpServletResponse hres = ((HttpSSOAgentRequest)request).getResponse();
        this.prepareNonCacheResponse(hres);
        SSOPartnerAppConfig cfg = this.getPartnerAppConfig(hreq.getServerName(), hreq.getContextPath());
        String splash_resource = null;
        if (hreq.getRequestURI().endsWith(this.getJOSSOAuthenticationUri())) {
            splash_resource = hreq.getParameter("josso_splash_resource");
            if ((splash_resource == null || "".equals(splash_resource)) && cfg != null) {
                splash_resource = cfg.getSplashResource();
            }
        } else {
            if (this.debug > 0) {
                this.log("sendCustomAuthentication executed but URL does not match AUTHENTICATION URI");
            }
            sb = new StringBuffer(hreq.getRequestURI());
            if (hreq.getQueryString() != null) {
                ((StringBuffer)sb).append('?');
                ((StringBuffer)sb).append(hreq.getQueryString());
            }
            String[] uriArray = new String[1];
            splash_resource = ((StringBuffer)sb).toString();
        }
        if (this.debug > 0) {
            this.log("Storing Splash resource '" + splash_resource + "'");
        }
        hreq.getSession(true).setAttribute("josso_splash_resource", (Object)splash_resource);
        sb = new StringBuilder();
        ((StringBuilder)sb).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">\n<body onload=\"document.forms[0].submit()\">\n<noscript>\n<p>\n<strong>Note:</strong> Since your browser does not support JavaScript,\nyou must press the Continue button once to proceed.\n</p>\n</noscript>\n<form action=\"").append(this.getGatewayLoginUrl()).append("\" method=\"post\" name=\"usernamePasswordLoginForm\" enctype=\"application/x-www-form-urlencoded\">\n        <div>");
        Enumeration paramNames = hreq.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String paramValue = hreq.getParameter(paramName);
            if ("josso_splash_resource".equals(paramName)) continue;
            ((StringBuilder)sb).append("\n            <input type=\"hidden\" value=\"").append(paramValue).append("\" name=\"").append(paramName).append("\" />");
        }
        ((StringBuilder)sb).append("\n            <noscript><input type=\"submit\" value=\"Continue\"/></noscript>\n        </div>\n</form>\n</body>\n</html>");
        hres.setContentType("text/html");
        PrintWriter out = hres.getWriter();
        out.print(((StringBuilder)sb).toString());
        if (this.debug >= 1) {
            this.log("Sending an automatic post form : \n" + ((StringBuilder)sb).toString());
        }
        out.flush();
    }

    public void prepareNonCacheResponse(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
    }

    public boolean isResourceIgnored(SSOPartnerAppConfig cfg, HttpServletRequest request) {
        String[] ignoredUrlPatterns = cfg.getIgnoredUrlPatterns();
        if (this.debug >= 1) {
            this.log("Found [" + (ignoredUrlPatterns != null ? ignoredUrlPatterns.length + "" : "no") + "] ignored url patterns ");
        }
        if (ignoredUrlPatterns != null && ignoredUrlPatterns.length > 0) {
            String requestPath = request.getServletPath();
            String pathInfo = request.getPathInfo();
            if (pathInfo != null) {
                requestPath = requestPath + pathInfo;
            }
            for (int i = 0; i < ignoredUrlPatterns.length; ++i) {
                String ignoredUrlPattern = ignoredUrlPatterns[i];
                if (!this.matchPattern(requestPath, ignoredUrlPattern)) continue;
                if (this.debug >= 1) {
                    this.log("Not subject to SSO protection :  url-pattern:" + ignoredUrlPattern);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean matchPattern(String path, String pattern) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = "/";
        }
        if (path.equals(pattern)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            if ((pattern = pattern.substring(0, pattern.length() - 2)).length() == 0) {
                return true;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            while (true) {
                if (pattern.equals(path)) {
                    return true;
                }
                int slash = path.lastIndexOf(47);
                if (slash <= 0) break;
                path = path.substring(0, slash);
            }
            return false;
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(pattern.substring(1));
        }
        return pattern.equals("/");
    }

    public String getJOSSOLoginUri() {
        return JOSSO_LOGIN_URI;
    }

    public String getJOSSOUserLoginUri() {
        return JOSSO_USER_LOGIN_URI;
    }

    public String getJOSSOSecurityCheckUri() {
        return JOSSO_SECURITY_CHECK_URI;
    }

    public String getJOSSOLogoutUri() {
        return JOSSO_LOGOUT_URI;
    }

    public String getJOSSOAuthenticationUri() {
        return JOSSO_AUTHENTICATION_URI;
    }

    public void setParametersBuilders(List<FrontChannelParametersBuilder> builders) {
        this._builders = builders;
    }

    public List<FrontChannelParametersBuilder> getParametersBuilders() {
        return this._builders;
    }
}

