/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.SSOPartnerAppConfig;
import org.josso.agent.http.AbstractFrontChannelParametersBuilder;
import org.josso.auth.util.CipherUtil;
import org.josso.gateway.SSONameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpParametersBuilder
extends AbstractFrontChannelParametersBuilder {
    private static final Log logger = LogFactory.getLog(HttpParametersBuilder.class);
    private boolean encodeValues = true;
    private boolean encodeNames = false;
    private List<String> includeRequestParameters = new ArrayList<String>();
    private List<String> excludeRequestParameters = new ArrayList<String>();
    private List<String> includeSessionAttributes = new ArrayList<String>();
    private List<String> excludeSessionAttributes = new ArrayList<String>();
    private List<Pattern> includeRequestParametersPatterns = new ArrayList<Pattern>();
    private List<Pattern> excludeRequestParametersPatterns = new ArrayList<Pattern>();
    private List<Pattern> includeSessionAttributesPatterns = new ArrayList<Pattern>();
    private List<Pattern> excludeSessionAttributesPatterns = new ArrayList<Pattern>();
    private boolean init = false;

    public boolean isEncodeValues() {
        return this.encodeValues;
    }

    public void setEncodeValues(boolean encodeValues) {
        this.encodeValues = encodeValues;
    }

    public boolean isEncodeNames() {
        return this.encodeNames;
    }

    public void setEncodeNames(boolean encodeNames) {
        this.encodeNames = encodeNames;
    }

    public List<String> getIncludeRequestParameters() {
        return this.includeRequestParameters;
    }

    public void setIncludeRequestParameters(List<String> includeRequestParameters) {
        this.includeRequestParameters = includeRequestParameters;
    }

    public List<String> getExcludeRequestParameters() {
        return this.excludeRequestParameters;
    }

    public void setExcludeRequestParameters(List<String> excludeRequestParameters) {
        this.excludeRequestParameters = excludeRequestParameters;
    }

    public List<String> getIncludeSessionAttributes() {
        return this.includeSessionAttributes;
    }

    public void setIncludeSessionAttributes(List<String> includeSessionAttributes) {
        this.includeSessionAttributes = includeSessionAttributes;
    }

    public List<String> getExcludeSessionAttributes() {
        return this.excludeSessionAttributes;
    }

    public void setExcludeSessionAttributes(List<String> excludeSessionAttributes) {
        this.excludeSessionAttributes = excludeSessionAttributes;
    }

    @Override
    public SSONameValuePair[] buildParamters(SSOPartnerAppConfig cfg, HttpServletRequest hreq) {
        if (!this.init) {
            this.init();
        }
        ArrayList<SSONameValuePair> params = new ArrayList<SSONameValuePair>();
        Enumeration paramNames = hreq.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!this.hreqParamMatches(paramName)) continue;
            String paramValue = hreq.getParameter(paramName);
            if (this.encodeNames) {
                paramName = this.encode(paramName);
            }
            if (this.encodeValues) {
                paramValue = this.encode(paramValue);
            }
            params.add(new SSONameValuePair(paramName, paramValue));
        }
        HttpSession session = hreq.getSession();
        Enumeration attrNames = session.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            if (!this.sessionAttrMatches(attrName)) continue;
            Object value = session.getAttribute(attrName);
            if (value instanceof String) {
                String attrValue = (String)value;
                if (this.encodeValues) {
                    attrValue = this.encode(attrValue);
                }
                if (this.encodeNames) {
                    attrName = this.encode(attrName);
                }
                params.add(new SSONameValuePair(attrName, attrValue));
                continue;
            }
            logger.warn((Object)("Non string session attribute cannot be exported " + attrName));
        }
        return params.toArray(new SSONameValuePair[params.size()]);
    }

    public void init() {
        Pattern pattern;
        for (String p : this.includeRequestParameters) {
            pattern = Pattern.compile(p);
            this.includeRequestParametersPatterns.add(pattern);
        }
        for (String p : this.excludeRequestParameters) {
            pattern = Pattern.compile(p);
            this.excludeRequestParametersPatterns.add(pattern);
        }
        for (String p : this.includeSessionAttributes) {
            pattern = Pattern.compile(p);
            this.includeSessionAttributesPatterns.add(pattern);
        }
        for (String p : this.excludeSessionAttributes) {
            pattern = Pattern.compile(p);
            this.excludeSessionAttributesPatterns.add(pattern);
        }
    }

    protected boolean hreqParamMatches(String paramName) {
        Matcher m;
        for (Pattern p : this.includeRequestParametersPatterns) {
            m = p.matcher(paramName);
            if (!m.matches()) continue;
            return true;
        }
        if (this.includeRequestParametersPatterns.size() > 0) {
            return false;
        }
        for (Pattern p : this.excludeRequestParametersPatterns) {
            m = p.matcher(paramName);
            if (!m.matches()) continue;
            return false;
        }
        if (this.excludeRequestParametersPatterns.size() > 0) {
            return true;
        }
        return true;
    }

    protected boolean sessionAttrMatches(String attrName) {
        Matcher m;
        for (Pattern p : this.includeSessionAttributesPatterns) {
            m = p.matcher(attrName);
            if (!m.matches()) continue;
            return true;
        }
        if (this.includeSessionAttributesPatterns.size() > 0) {
            return false;
        }
        for (Pattern p : this.excludeSessionAttributesPatterns) {
            m = p.matcher(attrName);
            if (!m.matches()) continue;
            return false;
        }
        return this.excludeSessionAttributesPatterns.size() > 0;
    }

    protected String encode(String value) {
        try {
            return URLEncoder.encode(CipherUtil.encodeBase64((byte[])value.getBytes()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("Cannot create Base64 encoding " + e.getMessage()), (Throwable)e);
            return value;
        }
    }
}

