/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.Lookup;
import org.josso.SecurityDomain;
import org.josso.auth.Authenticator;
import org.josso.auth.Credential;
import org.josso.auth.exceptions.AuthenticationFailureException;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.gateway.MutableSSOContext;
import org.josso.gateway.SSOContext;
import org.josso.gateway.SSOException;
import org.josso.gateway.SSOGateway;
import org.josso.gateway.SSORequest;
import org.josso.gateway.SSOSecurityDomainSelector;
import org.josso.gateway.SecurityDomainMatcher;
import org.josso.gateway.SecurityDomainRegistry;
import org.josso.gateway.assertion.AssertionManager;
import org.josso.gateway.assertion.AuthenticationAssertion;
import org.josso.gateway.event.security.SSOSecurityEventManager;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.NoSuchDomainException;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.SSOIdentityManager;
import org.josso.gateway.identity.service.SSOIdentityProvider;
import org.josso.gateway.session.SSOSession;
import org.josso.gateway.session.exceptions.NoSuchSessionException;
import org.josso.gateway.session.exceptions.SSOSessionException;
import org.josso.gateway.session.service.SSOSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSOGatewayImpl
implements SSOGateway {
    private static final Log logger = LogFactory.getLog(SSOGatewayImpl.class);
    private boolean _initialized;
    private List<SecurityDomain> securityDomains = new ArrayList<SecurityDomain>();
    private SSOSecurityDomainSelector securityDomainSelector;
    private SecurityDomainRegistry securityDomainRegistry;

    @Override
    public synchronized void initialize() {
        String name;
        SecurityDomain sd;
        int i;
        if (this._initialized) {
            throw new IllegalStateException("SSOGateway already initialized");
        }
        if (this.securityDomainSelector == null) {
            logger.info((Object)"Finishing setup, using default SecurityDomainSelector");
            try {
                this.securityDomainSelector = (SSOSecurityDomainSelector)this.loadClass("org.josso.gateway.DomainSelectorImpl").newInstance();
            }
            catch (Exception e) {
                logger.error((Object)("Cannot instantiate default security domain selector : " + e.getMessage()), (Throwable)e);
            }
        }
        if (this.securityDomainRegistry == null) {
            logger.info((Object)"Finishing setup, using default SecurityDomainRegistry");
            try {
                this.securityDomainRegistry = (SecurityDomainRegistry)this.loadClass("org.josso.gateway.SecurityDomainRegistryImpl").newInstance();
            }
            catch (Exception e) {
                logger.error((Object)("Cannot instantiate default security domain registry : " + e.getMessage()), (Throwable)e);
            }
        }
        for (i = 0; i < this.securityDomains.size(); ++i) {
            sd = this.securityDomains.get(i);
            name = sd.getName();
            if (sd.getIdentityProvider() == null) {
                logger.info((Object)("Finishing setup [" + name + "], using default IdentityProvider"));
                try {
                    sd.setIdentityProvider((SSOIdentityProvider)this.loadClass("org.josso.gateway.identity.service.SSOIdentityProviderImpl").newInstance());
                }
                catch (Exception e) {
                    logger.error((Object)("Cannot create default identity provider : " + e.getMessage()), (Throwable)e);
                }
            }
            if (sd.getAssertionManager() == null) {
                logger.info((Object)("Finishing setup [" + name + "], using default AssertionManager"));
                try {
                    sd.setAssertionManager((AssertionManager)this.loadClass("org.josso.gateway.assertion.AssertionManagerImpl").newInstance());
                }
                catch (Exception e) {
                    logger.error((Object)("Cannot create default assertion manager : " + e.getMessage()), (Throwable)e);
                }
            }
            if (sd.getMatchers().size() != 0) continue;
            logger.info((Object)("Finishing setup [" + name + "], using default SecurityDomainMatcher"));
            try {
                sd.getMatchers().add((SecurityDomainMatcher)this.loadClass("org.josso.gateway.SimpleSecurityDomainMatcher").newInstance());
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("Cannot instantiate default security domain matcher : " + e.getMessage()), (Throwable)e);
            }
        }
        for (i = 0; i < this.securityDomains.size(); ++i) {
            sd = this.securityDomains.get(i);
            name = sd.getName();
            this.securityDomainRegistry.register(sd);
            logger.info((Object)("Initializing [" + name + " ] SSOEventManager ..."));
            sd.getEventManager().initialize();
            logger.info((Object)("Initializing [" + name + " ] SSOEventManager ... DONE"));
            logger.info((Object)("Initializing [" + name + " ] SSOAssertionManager ..."));
            sd.getAssertionManager().setSecurityDomainName(name);
            sd.getAssertionManager().initialize();
            logger.info((Object)("Initializing [" + name + " ] SSOAssertionManager ... DONE"));
            logger.info((Object)("Initializing [" + name + " ] SSOAssertionManager ..."));
            sd.getIdentityProvider().initialize();
            logger.info((Object)("Initializing [" + name + " ] SSOAssertionManager ... DONE"));
            logger.info((Object)("Initializing [" + name + " ] SSOIdentityManager ..."));
            sd.getIdentityManager().initialize();
            logger.info((Object)("Initializing [" + name + " ] SSOIdentityManager ... DONE"));
            logger.info((Object)("Initializing [" + name + " ] SSOSessionManager ..."));
            sd.getSessionManager().setSecurityDomainName(name);
            sd.getSessionManager().initialize();
            logger.info((Object)("Initializing [" + name + " ] SSOSessionManager ... DONE"));
            logger.info((Object)("Initializing [" + name + " ] SSOAuditManager ..."));
            sd.getAuditManager().initialize();
            logger.info((Object)("Initializing [" + name + " ] SSOAuditManager ... DONE"));
            if (sd.getProtocolManager() != null) {
                logger.info((Object)("Initializing [" + name + " ] SSOProtocolManager ..."));
                sd.getProtocolManager().initialize();
                logger.info((Object)("Initializing [" + name + " ] SSOProtocolManager ... DONE"));
            }
            for (SecurityDomainMatcher matcher : sd.getMatchers()) {
                logger.info((Object)("Initializing [" + name + " ] SecurityDomainMatcher ..."));
                matcher.init();
                logger.info((Object)("Initializing [" + name + " ] SecurityDomainMatcher ... DONE"));
            }
        }
        this._initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this._initialized;
    }

    @Override
    public void destroy() {
        this._initialized = false;
    }

    @Override
    public SSOContext prepareSSOContext(SSORequest req) throws NoSuchDomainException {
        MutableSSOContext ctx = new MutableSSOContext();
        ctx.setUserLocation(req.getUserLocation());
        ctx.setScheme("unknown");
        ctx.setSecurityDomain(this.securityDomainSelector.selectDomain(req, this.securityDomains));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SSOContext created from request for SecurityDomain " + (ctx.getSecurityDomain() != null ? ctx.getSecurityDomain().getName() : "null")));
        }
        return ctx;
    }

    @Override
    public SSOContext prepareSSOContext(String tokenType, String tokenValue) {
        if (tokenType == null || "".equals(tokenType)) {
            throw new IllegalArgumentException("TokenType cannot be null");
        }
        if (tokenValue == null || "".equals(tokenValue)) {
            throw new IllegalArgumentException("TokenValue cannot be null");
        }
        SecurityDomain sd = this.securityDomainRegistry.lookup(tokenType, tokenValue);
        if (sd == null) {
            sd = this.prepareDefaultSSOContext().getSecurityDomain();
            logger.debug((Object)("No security domain found for token : [" + tokenType + "/" + tokenValue + "], using default one : " + sd.getName()));
        }
        MutableSSOContext ctx = new MutableSSOContext();
        ctx.setSecurityDomain(sd);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SSOContext created from token " + tokenType + "/" + tokenValue + " for SecurityDomain " + (ctx.getSecurityDomain() != null ? ctx.getSecurityDomain().getName() : "null")));
        }
        return ctx;
    }

    @Override
    public SSOContext prepareSSOContext(String securityDomainName) throws NoSuchDomainException {
        if (securityDomainName == null) {
            throw new IllegalArgumentException("SecurityDomanName cannot be null");
        }
        MutableSSOContext ctx = new MutableSSOContext();
        SecurityDomain sd = this.getSecurityDomain(securityDomainName);
        ctx.setSecurityDomain(sd);
        return ctx;
    }

    @Override
    public SSOContext prepareDefaultSSOContext() {
        MutableSSOContext ctx = new MutableSSOContext();
        SecurityDomain sd = this.securityDomains.get(0);
        ctx.setSecurityDomain(sd);
        return ctx;
    }

    @Override
    public SecurityDomain getSecurityDomain(String name) throws NoSuchDomainException {
        for (int i = 0; i < this.securityDomains.size(); ++i) {
            SecurityDomain securityDomain = this.securityDomains.get(i);
            if (!securityDomain.getName().equals(name)) continue;
            return securityDomain;
        }
        throw new NoSuchDomainException(name);
    }

    @Override
    public SSOSession login(Credential[] cred, String scheme) throws SSOException, SSOAuthenticationException {
        try {
            SSOIdentityProvider ip = Lookup.getInstance().lookupSSOIdentityProvider();
            return ip.login(cred, scheme);
        }
        catch (AuthenticationFailureException e) {
            throw e;
        }
        catch (SSOAuthenticationException e) {
            throw e;
        }
        catch (SSOIdentityException e) {
            throw new SSOException(e.getMessage(), e);
        }
        catch (SSOSessionException e) {
            throw new SSOException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new SSOException(e.getMessage(), e);
        }
    }

    @Override
    public AuthenticationAssertion assertIdentity(Credential[] credentials, String scheme) throws SSOException, SSOAuthenticationException {
        try {
            SSOIdentityProvider ip = Lookup.getInstance().lookupSSOIdentityProvider();
            return ip.assertIdentity(credentials, scheme);
        }
        catch (AuthenticationFailureException e) {
            throw e;
        }
        catch (SSOAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SSOException(e.getMessage(), e);
        }
    }

    @Override
    public AuthenticationAssertion assertIdentity(String sessionId) throws SSOException {
        try {
            SSOIdentityProvider ip = Lookup.getInstance().lookupSSOIdentityProvider();
            return ip.assertIdentity(sessionId);
        }
        catch (Exception e) {
            throw new SSOException(e.getMessage(), e);
        }
    }

    @Override
    public void logout() throws SSOException {
        try {
            SSOIdentityProvider ip = Lookup.getInstance().lookupSSOIdentityProvider();
            ip.logout();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOException(e.getMessage(), e);
        }
    }

    @Override
    public Credential newCredential(String schemeName, String name, Object value) throws SSOAuthenticationException {
        try {
            SecurityDomain domain = Lookup.getInstance().lookupSecurityDomain();
            Authenticator au = domain.getAuthenticator();
            return au.newCredential(schemeName, name, value);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getPrincipalName(String schemeName, Credential[] creds) throws SSOAuthenticationException {
        try {
            SecurityDomain domain = Lookup.getInstance().lookupSecurityDomain();
            Authenticator au = domain.getAuthenticator();
            Principal p = au.getPrincipal(schemeName, creds);
            if (p != null) {
                return p.getName();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public SSOUser findUserInSession(String sessionId) throws SSOException {
        try {
            SecurityDomain domain = Lookup.getInstance().lookupSecurityDomain();
            SSOIdentityManager im = domain.getIdentityManager();
            return im.findUserInSession(sessionId);
        }
        catch (NoSuchSessionException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new SSOException(e.getMessage(), e);
        }
        catch (SSOIdentityException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new SSOException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOException(e.getMessage(), e);
        }
    }

    @Override
    public SSORole[] findRolesByUsername(String username) throws SSOException {
        try {
            SecurityDomain domain = Lookup.getInstance().lookupSecurityDomain();
            SSOIdentityManager im = domain.getIdentityManager();
            return im.findRolesByUsername(username);
        }
        catch (SSOIdentityException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new SSOException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOException(e.getMessage(), e);
        }
    }

    @Override
    public SSOSession findSession(String jossoSessionId) throws SSOException, NoSuchSessionException {
        try {
            SecurityDomain domain = Lookup.getInstance().lookupSecurityDomain();
            SSOSessionManager sm = domain.getSessionManager();
            return sm.getSession(jossoSessionId);
        }
        catch (NoSuchSessionException e) {
            throw e;
        }
        catch (SSOIdentityException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new SSOException(e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSOException(e.getMessage(), e);
        }
    }

    protected void notifyLoginFailed(SSOContext ctx, Credential[] credentials, String scheme, Throwable error) {
        try {
            SSOSecurityEventManager em = (SSOSecurityEventManager)Lookup.getInstance().lookupSecurityDomain().getEventManager();
            em.fireAuthenticationFailureEvent(ctx.getUserLocation(), scheme, credentials, error);
        }
        catch (Exception e) {
            logger.error((Object)("Can't notify login failure : " + e.getMessage()), (Throwable)e);
        }
    }

    protected void notifyLoginSuccess(SSOContext ctx, String username, SSOSession session, String scheme) {
        try {
            SSOSecurityEventManager em = (SSOSecurityEventManager)Lookup.getInstance().lookupSecurityDomain().getEventManager();
            em.fireAuthenticationSuccessEvent(ctx.getUserLocation(), scheme, username, session.getId());
        }
        catch (Exception e) {
            logger.error((Object)("Can't notify login success : " + e.getMessage()), (Throwable)e);
        }
    }

    private void notifyLogoutFail(SSOContext ctx, Throwable error) {
        try {
            SSOSecurityEventManager em = (SSOSecurityEventManager)Lookup.getInstance().lookupSecurityDomain().getEventManager();
            em.fireLogoutFailureEvent(ctx.getUserLocation(), ctx.getSession().getUsername(), ctx.getSession().getId(), error);
        }
        catch (Exception e) {
            logger.error((Object)("Can't notify login success : " + e.getMessage()), (Throwable)e);
        }
    }

    protected void notifyLogoutSuccess(SSOContext ctx) {
        try {
            SSOSecurityEventManager em = (SSOSecurityEventManager)Lookup.getInstance().lookupSecurityDomain().getEventManager();
            em.fireLogoutSuccessEvent(ctx.getUserLocation(), ctx.getSession().getUsername(), ctx.getSession().getId());
        }
        catch (Exception e) {
            logger.error((Object)("Can't notify login success : " + e.getMessage()), (Throwable)e);
        }
    }

    public SSOSecurityDomainSelector getSecurityDomainSelector() {
        return this.securityDomainSelector;
    }

    public void setSecurityDomainSelector(SSOSecurityDomainSelector securityDomainSelector) {
        this.securityDomainSelector = securityDomainSelector;
    }

    @Override
    public SecurityDomainRegistry getSecurityDomainRegistry() {
        return this.securityDomainRegistry;
    }

    public void setSecurityDomainRegistry(SecurityDomainRegistry securityDomainRegistry) {
        this.securityDomainRegistry = securityDomainRegistry;
    }

    public void setSecurityDomains(List<SecurityDomain> sds) {
        this.securityDomains = sds;
        if (this._initialized) {
            for (SecurityDomain sd : sds) {
                this.securityDomainRegistry.register(sd);
            }
        }
    }

    public List<SecurityDomain> getSecurityDomains() {
        return this.securityDomains;
    }

    protected Class loadClass(String fqcn) throws ClassNotFoundException {
        Class<?> c = null;
        try {
            c = this.getClass().getClassLoader().loadClass(fqcn);
            return c;
        }
        catch (ClassNotFoundException e) {
            try {
                c = Thread.currentThread().getContextClassLoader().loadClass(fqcn);
                return c;
            }
            catch (ClassNotFoundException e2) {
                try {
                    Class.forName(fqcn);
                    return c;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ClassNotFoundException(fqcn);
                }
            }
        }
    }
}

