/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.TransactionManager;
import org.jboss.portal.common.transaction.Transactions;
import org.jboss.portal.identity.MembershipModule;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.identity.UserStatus;
import org.jboss.portal.identity.auth.UserPrincipal;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class IdentityLoginModule
extends UsernamePasswordLoginModule {
    protected String userModuleJNDIName;
    protected String roleModuleJNDIName;
    protected String userProfileModuleJNDIName;
    protected String membershipModuleJNDIName;
    protected String additionalRole;
    protected String havingRole;
    protected String validateUserNameCase;
    protected String userNameToLowerCase;
    private UserModule userModule;
    private RoleModule roleModule;
    private UserProfileModule userProfileModule;
    private MembershipModule membershipModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.userModuleJNDIName = (String)options.get("userModuleJNDIName");
        this.roleModuleJNDIName = (String)options.get("roleModuleJNDIName");
        this.userProfileModuleJNDIName = (String)options.get("userProfileModuleJNDIName");
        this.membershipModuleJNDIName = (String)options.get("membershipModuleJNDIName");
        this.additionalRole = (String)options.get("additionalRole");
        this.havingRole = (String)options.get("havingRole");
        this.validateUserNameCase = (String)options.get("validateUserNameCase");
        this.userNameToLowerCase = (String)options.get("userNameToLowerCase");
        this.log.trace((Object)("userModuleJNDIName = " + this.userModuleJNDIName));
        this.log.trace((Object)("roleModuleJNDIName = " + this.roleModuleJNDIName));
        this.log.trace((Object)("userProfileModuleJNDIName = " + this.userProfileModuleJNDIName));
        this.log.trace((Object)("membershipModuleJNDIName = " + this.membershipModuleJNDIName));
        this.log.trace((Object)("additionalRole = " + this.additionalRole));
        this.log.trace((Object)("havingRole = " + this.havingRole));
        this.log.trace((Object)("validateUserNameCase = " + this.validateUserNameCase));
        this.log.trace((Object)("userNameToLowerCase = " + this.userNameToLowerCase));
    }

    protected UserModule getUserModule() throws NamingException {
        if (this.userModule == null) {
            this.userModule = (UserModule)new InitialContext().lookup(this.userModuleJNDIName);
        }
        return this.userModule;
    }

    protected RoleModule getRoleModule() throws NamingException {
        if (this.roleModule == null) {
            this.roleModule = (RoleModule)new InitialContext().lookup(this.roleModuleJNDIName);
        }
        return this.roleModule;
    }

    protected UserProfileModule getUserProfileModule() throws NamingException {
        if (this.userProfileModule == null) {
            this.userProfileModule = (UserProfileModule)new InitialContext().lookup(this.userProfileModuleJNDIName);
        }
        return this.userProfileModule;
    }

    protected MembershipModule getMembershipModule() throws NamingException {
        if (this.membershipModule == null) {
            this.membershipModule = (MembershipModule)new InitialContext().lookup(this.membershipModuleJNDIName);
        }
        return this.membershipModule;
    }

    protected String getUsersPassword() throws LoginException {
        return "";
    }

    /*
     * Loose catch block
     */
    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        HttpServletRequest request = null;
        try {
            request = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
        }
        catch (Exception e) {
            this.log.error((Object)this, (Throwable)e);
            throw new RuntimeException(e);
        }
        Object ssoSuccess = request.getAttribute("ssoSuccess");
        if (ssoSuccess != null) {
            return true;
        }
        if (inputPassword != null) {
            try {
                block12: {
                    UserStatus userStatus = this.getUserStatus(inputPassword);
                    request.setAttribute("org.jboss.portal.userStatus", (Object)userStatus);
                    if (userStatus == UserStatus.DISABLE) {
                        request.setAttribute("org.jboss.portal.loginError", (Object)"Your account is disabled");
                        return false;
                    }
                    if (userStatus == UserStatus.NOTASSIGNEDTOROLE) {
                        request.setAttribute("org.jboss.portal.loginError", (Object)"The user doesn't have the correct role");
                        return false;
                    }
                    if (userStatus == UserStatus.UNEXISTING || userStatus == UserStatus.WRONGPASSWORD) {
                        request.setAttribute("org.jboss.portal.loginError", (Object)"The user doesn't exist or the password is incorrect");
                        return false;
                    }
                    if (userStatus != UserStatus.OK) break block12;
                    return true;
                }
                this.log.error((Object)"Unexpected error while logging in");
                return false;
            }
            catch (Exception e) {
                this.log.error((Object)"Error when validating password", (Throwable)e);
                {
                    catch (Exception e2) {
                        this.log.debug((Object)"Failed to validate password", (Throwable)e2);
                    }
                }
            }
        }
        return false;
    }

    protected UserStatus getUserStatus(final String inputPassword) {
        UserStatus result = UserStatus.OK;
        try {
            TransactionManager tm = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            UserStatus tmp = (UserStatus)Transactions.required((TransactionManager)tm, (Transactions.Runnable)new Transactions.Runnable(){

                public Object run() throws Exception {
                    try {
                        User user = IdentityLoginModule.this.getUserModule().findUserByUserName(IdentityLoginModule.this.getUsername());
                        if (user == null) {
                            throw new NoSuchUserException("UserModule returned null user object");
                        }
                        if (IdentityLoginModule.this.validateUserNameCase != null && IdentityLoginModule.this.validateUserNameCase.equalsIgnoreCase("true") && !IdentityLoginModule.this.getUsername().equals(user.getUserName())) {
                            return UserStatus.UNEXISTING;
                        }
                        boolean enabled = false;
                        try {
                            Object enabledS = IdentityLoginModule.this.getUserProfileModule().getProperty(user, "portal.user.enabled");
                            if (enabledS != null) {
                                enabled = new Boolean(enabledS.toString());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (!enabled) {
                            return UserStatus.DISABLE;
                        }
                        if (IdentityLoginModule.this.havingRole != null) {
                            boolean hasTheRole = false;
                            Set roles = IdentityLoginModule.this.getMembershipModule().getRoles(user);
                            for (Role role : roles) {
                                if (!IdentityLoginModule.this.havingRole.equals(role.getName())) continue;
                                hasTheRole = true;
                                break;
                            }
                            if (!hasTheRole) {
                                return UserStatus.NOTASSIGNEDTOROLE;
                            }
                        }
                        if (!user.validatePassword(inputPassword)) {
                            return UserStatus.WRONGPASSWORD;
                        }
                    }
                    catch (NoSuchUserException e1) {
                        return UserStatus.UNEXISTING;
                    }
                    catch (Exception e) {
                        throw new LoginException(e.toString());
                    }
                    return null;
                }
            });
            if (tmp != null) {
                result = tmp;
            }
        }
        catch (NamingException e1) {
            e1.printStackTrace();
        }
        return result;
    }

    protected Group[] getRoleSets() throws LoginException {
        try {
            TransactionManager tm = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            return (Group[])Transactions.required((TransactionManager)tm, (Transactions.Runnable)new Transactions.Runnable(){

                public Object run() throws Exception {
                    SimpleGroup rolesGroup = new SimpleGroup("Roles");
                    if (IdentityLoginModule.this.additionalRole != null) {
                        rolesGroup.addMember(IdentityLoginModule.this.createIdentity(IdentityLoginModule.this.additionalRole));
                    }
                    try {
                        User user = IdentityLoginModule.this.getUserModule().findUserByUserName(IdentityLoginModule.this.getUsername());
                        Set roles = IdentityLoginModule.this.getMembershipModule().getRoles(user);
                        for (Role role : roles) {
                            String roleName = role.getName();
                            try {
                                Principal p = IdentityLoginModule.this.createIdentity(roleName);
                                rolesGroup.addMember(p);
                            }
                            catch (Exception e) {
                                IdentityLoginModule.this.log.debug((Object)("Failed to create principal " + roleName), (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new LoginException(e.toString());
                    }
                    return new Group[]{rolesGroup};
                }
            });
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            throw new LoginException(cause.toString());
        }
    }

    protected Principal createIdentity(String username) throws Exception {
        return new UserPrincipal(username);
    }

    protected String getUsername() {
        if (this.userNameToLowerCase != null && this.userNameToLowerCase.equalsIgnoreCase("true")) {
            return super.getUsername().toLowerCase();
        }
        return super.getUsername();
    }

    protected String[] getUsernameAndPassword() throws LoginException {
        String[] names = super.getUsernameAndPassword();
        if (this.userNameToLowerCase != null && this.userNameToLowerCase.equalsIgnoreCase("true") && names[0] != null) {
            names[0] = names[0].toLowerCase();
        }
        return names;
    }
}

