/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.portal.common.transaction.Transactions;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.MembershipModule;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.identity.auth.UserPrincipal;
import org.jboss.security.auth.spi.LdapLoginModule;

public class SynchronizingLDAPLoginModule
extends LdapLoginModule {
    private static final Logger log = Logger.getLogger(SynchronizingLDAPLoginModule.class);
    protected String additionalRole;
    protected String defaultAssignedRole;
    protected String synchronizeIdentity;
    protected String synchronizeRoles;
    protected String userModuleJNDIName;
    protected String roleModuleJNDIName;
    protected String membershipModuleJNDIName;
    protected String userProfileModuleJNDIName;
    protected String preserveRoles;
    private UserModule userModule;
    private RoleModule roleModule;
    private MembershipModule membershipModule;
    private UserProfileModule userProfileModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.userModuleJNDIName = (String)options.get("userModuleJNDIName");
        this.roleModuleJNDIName = (String)options.get("roleModuleJNDIName");
        this.membershipModuleJNDIName = (String)options.get("membershipModuleJNDIName");
        this.userProfileModuleJNDIName = (String)options.get("userProfileModuleJNDIName");
        this.additionalRole = (String)options.get("additionalRole");
        this.synchronizeIdentity = (String)options.get("synchronizeIdentity");
        this.synchronizeRoles = (String)options.get("synchronizeRoles");
        this.defaultAssignedRole = (String)options.get("defaultAssignedRole");
        this.preserveRoles = (String)options.get("preserveRoles");
        log.trace((Object)("additionalRole = " + this.additionalRole));
        log.trace((Object)("userModuleJNDIName = " + this.userModuleJNDIName));
        log.trace((Object)("roleModuleJNDIName = " + this.roleModuleJNDIName));
        log.trace((Object)("membershipModuleJNDIName = " + this.membershipModuleJNDIName));
        log.trace((Object)("userProfileModuleJNDIName = " + this.userProfileModuleJNDIName));
        log.trace((Object)("synchronizeIdentity = " + this.synchronizeIdentity));
        log.trace((Object)("synchronizeRoles = " + this.synchronizeRoles));
        log.trace((Object)("defaultAssignedRole = " + this.defaultAssignedRole));
        log.trace((Object)("preserveRoles = " + this.preserveRoles));
    }

    protected UserModule getUserModule() throws Exception {
        if (this.userModule == null) {
            this.userModule = (UserModule)new InitialContext().lookup(this.userModuleJNDIName);
        }
        if (this.userModule == null) {
            throw new IdentityException("Cannot obtain UserModule using JNDI name:" + this.userModuleJNDIName);
        }
        return this.userModule;
    }

    protected RoleModule getRoleModule() throws Exception {
        if (this.roleModule == null) {
            this.roleModule = (RoleModule)new InitialContext().lookup(this.roleModuleJNDIName);
        }
        if (this.roleModule == null) {
            throw new IdentityException("Cannot obtain RoleModule using JNDI name:" + this.roleModuleJNDIName);
        }
        return this.roleModule;
    }

    protected MembershipModule getMembershipModule() throws Exception {
        if (this.membershipModule == null) {
            this.membershipModule = (MembershipModule)new InitialContext().lookup(this.membershipModuleJNDIName);
        }
        if (this.membershipModule == null) {
            throw new IdentityException("Cannot obtain MembershipModule using JNDI name:" + this.membershipModuleJNDIName);
        }
        return this.membershipModule;
    }

    protected UserProfileModule getUserProfileModule() throws Exception {
        if (this.userProfileModule == null) {
            this.userProfileModule = (UserProfileModule)new InitialContext().lookup(this.userProfileModuleJNDIName);
        }
        if (this.userProfileModule == null) {
            throw new IdentityException("Cannot obtain UserProfileModule using JNDI name:" + this.userProfileModuleJNDIName);
        }
        return this.userProfileModule;
    }

    protected boolean validatePassword(String string, String string1) {
        boolean validate = super.validatePassword(string, string1);
        if (validate && this.isSynchronizeIdentity()) {
            try {
                this.performSynchronization(this.getUsername(), string);
            }
            catch (Throwable e) {
                log.warn((Object)("Failed to sychronize identity of user: " + string), e);
            }
        }
        return validate;
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] rolesGroup = super.getRoleSets();
        if (this.additionalRole != null) {
            try {
                for (int i = 0; i < rolesGroup.length; ++i) {
                    Group group = rolesGroup[i];
                    if (!group.getName().equals("Roles")) continue;
                    group.addMember(this.createIdentity(this.additionalRole));
                }
            }
            catch (Exception e) {
                log.error((Object)"Error when adding additional role: ", (Throwable)e);
            }
        }
        return rolesGroup;
    }

    protected Principal createIdentity(String username) throws Exception {
        return new UserPrincipal(username);
    }

    private void performSynchronization(final String name, final String password) throws Exception {
        final Group[] group = super.getRoleSets();
        log.debug((Object)("$$Synchronizing user: " + name));
        if (log.isDebugEnabled()) {
            for (int i = 0; i < group.length; ++i) {
                Group group1 = group[i];
                log.debug((Object)("$$Role Group: " + group1.getName()));
                Enumeration xx = group1.members();
                while (xx.hasMoreElements()) {
                    Principal o = (Principal)xx.nextElement();
                    log.debug((Object)("$$Principal in group: " + o.getName() + "; " + ((Object)o).toString()));
                }
            }
        }
        try {
            TransactionManager tm = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            Transactions.required((TransactionManager)tm, (Transactions.Runnable)new Transactions.Runnable(){

                public Object run() throws Exception {
                    try {
                        User user = null;
                        try {
                            user = SynchronizingLDAPLoginModule.this.getUserModule().findUserByUserName(name);
                            if (!user.validatePassword(password)) {
                                user.updatePassword(password);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (user == null) {
                            user = SynchronizingLDAPLoginModule.this.getUserModule().createUser(name, password);
                            SynchronizingLDAPLoginModule.this.getUserProfileModule().setProperty(user, "portal.user.enabled", Boolean.TRUE);
                        }
                        HashSet<Role> rolesToAssign = new HashSet<Role>();
                        if (SynchronizingLDAPLoginModule.this.isSynchronizeRoles()) {
                            Group roleGroup = group[0];
                            Enumeration en = roleGroup.members();
                            while (en.hasMoreElements()) {
                                Principal p = (Principal)en.nextElement();
                                String roleName = p.getName();
                                log.debug((Object)("$$Processing role principal object related to current user: " + roleName));
                                Role role = null;
                                try {
                                    role = SynchronizingLDAPLoginModule.this.getRoleModule().findRoleByName(roleName);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                if (role == null) {
                                    try {
                                        role = SynchronizingLDAPLoginModule.this.getRoleModule().createRole(roleName, roleName);
                                    }
                                    catch (Throwable e) {
                                        log.warn((Object)("Error when trying to synchronize role: " + roleName), e);
                                        continue;
                                    }
                                }
                                rolesToAssign.add(role);
                            }
                        }
                        if (SynchronizingLDAPLoginModule.this.defaultAssignedRole != null) {
                            try {
                                rolesToAssign.add(SynchronizingLDAPLoginModule.this.getRoleModule().findRoleByName(SynchronizingLDAPLoginModule.this.defaultAssignedRole));
                            }
                            catch (Exception e) {
                                log.warn((Object)("Cannot find defaultAssignedRole: " + SynchronizingLDAPLoginModule.this.defaultAssignedRole), (Throwable)e);
                            }
                        }
                        if (rolesToAssign.size() > 0) {
                            Set presentRoles;
                            if ((SynchronizingLDAPLoginModule.this.isPreserveRoles() || !SynchronizingLDAPLoginModule.this.isSynchronizeRoles()) && (presentRoles = SynchronizingLDAPLoginModule.this.getMembershipModule().getRoles(user)) != null) {
                                rolesToAssign.addAll(presentRoles);
                            }
                            SynchronizingLDAPLoginModule.this.getMembershipModule().assignRoles(user, rolesToAssign);
                        }
                        return null;
                    }
                    catch (Exception e) {
                        throw new LoginException(e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            throw new LoginException(cause.toString());
        }
    }

    protected boolean isSynchronizeIdentity() {
        if (this.synchronizeIdentity != null && this.synchronizeIdentity.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected boolean isSynchronizeRoles() {
        if (this.synchronizeRoles != null && this.synchronizeRoles.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected boolean isPreserveRoles() {
        if (this.preserveRoles != null && this.preserveRoles.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

