/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.event;

import java.util.Iterator;
import java.util.Set;
import org.jboss.portal.identity.event.IdentityEvent;

public class MembershipChangedEvent
extends IdentityEvent {
    private final Set userIds;
    private final Set roleIds;
    private final String representation;

    public MembershipChangedEvent(Set userIds, Set roleIds) {
        if (userIds == null) {
            throw new IllegalArgumentException();
        }
        if (roleIds == null) {
            throw new IllegalArgumentException();
        }
        if (roleIds.size() > 1 && userIds.size() > 1) {
            throw new IllegalStateException("Either roleIds or userIds must contain only one element");
        }
        this.userIds = userIds;
        this.roleIds = roleIds;
        StringBuilder sb = new StringBuilder();
        sb.append("MembershipChangedEvent[userIds=");
        Iterator iterator = userIds.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (iterator.hasNext()) {
                sb.append(o.toString() + ", ");
                continue;
            }
            sb.append(o.toString());
        }
        this.representation = sb.toString();
    }

    public Set getUserIds() {
        return this.userIds;
    }

    public Set getRoleIds() {
        return this.roleIds;
    }

    public String toString() {
        return this.representation;
    }
}

