/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.ldap;

import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapContext;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.ldap.LDAPConnectionContext;
import org.jboss.portal.identity.ldap.LDAPRoleImpl;
import org.jboss.portal.identity.service.RoleModuleService;

public abstract class LDAPRoleModule
extends RoleModuleService {
    private static final Logger log = Logger.getLogger(LDAPRoleModule.class);
    private LDAPConnectionContext connectionContext;

    public void start() throws Exception {
        if (this.getConnectionJNDIName() == null) {
            throw new IdentityException("Cannot obtain ldap connection context JNDI name");
        }
        try {
            this.connectionContext = (LDAPConnectionContext)new InitialContext().lookup(this.getConnectionJNDIName());
        }
        catch (NamingException e) {
            log.error((Object)"Couldn't obtain connection context");
        }
        super.start();
    }

    public void updateDisplayName(LDAPRoleImpl ldapr, String name) throws IdentityException {
        String attributeName = this.getDisplayNameAttributeID();
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            BasicAttributes attrs = new BasicAttributes(true);
            BasicAttribute attr = new BasicAttribute(attributeName);
            attr.add(name);
            attrs.put(attr);
            ldapContext.modifyAttributes(ldapr.getDn(), 2, (Attributes)attrs);
            this.fireRoleUpdatedEvent(ldapr.getId(), ldapr.getName(), name);
        }
        catch (NamingException e) {
            throw new IdentityException("Cannot set role displayName value.", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
    }

    public LDAPRoleImpl createRoleInstance(Attributes attrs, String dn) throws IdentityException {
        LDAPRoleImpl ldapr = null;
        try {
            Attribute uida = attrs.get(this.getRidAttributeID());
            if (uida == null) {
                throw new IdentityException("LDAP entry doesn't contain proper attribute:" + this.getRidAttributeID());
            }
            Attribute display = attrs.get(this.getDisplayNameAttributeID());
            if (display == null) {
                throw new IdentityException("LDAP entry doesn't contain proper attribute:" + this.getDisplayNameAttributeID());
            }
            ldapr = new LDAPRoleImpl(dn, this.getIdentityContext(), dn, uida.get().toString(), display.get().toString());
            log.debug((Object)("role uid: " + ldapr.getId()));
            log.debug((Object)("role dn: " + ldapr.getDn()));
        }
        catch (NamingException e) {
            throw new IdentityException("Couldn't create LDAPRoleImpl object from ldap entry (SearchResult)", e);
        }
        return ldapr;
    }

    public Role findRoleByDN(String dn) throws IdentityException, IllegalArgumentException {
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            log.debug((Object)("findRoleByDN(): DN = " + dn));
            if (dn == null) {
                throw new IdentityException("Role dn canot be null");
            }
            Attributes attrs = ldapContext.getAttributes(dn);
            if (attrs == null) {
                throw new IdentityException("Can't find role entry with DN: " + dn);
            }
            LDAPRoleImpl lDAPRoleImpl = this.createRoleInstance(attrs, dn);
            return lDAPRoleImpl;
        }
        catch (NoSuchElementException e) {
            log.debug((Object)("No role found with dn: " + dn), (Throwable)e);
        }
        catch (NamingException e) {
            throw new IdentityException("Role search failed.", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        return null;
    }

    public abstract List searchRoles(String var1, Object[] var2) throws NamingException, IdentityException;

    protected String getRidAttributeID() throws IdentityException {
        String rid = this.getIdentityConfiguration().getValue("ridAttributeID");
        if (rid == null) {
            return "cn";
        }
        return rid;
    }

    protected LDAPConnectionContext getConnectionContext() throws IdentityException {
        if (this.connectionContext == null) {
            throw new IdentityException("No LDAPConnectionContext available");
        }
        return this.connectionContext;
    }

    protected String getContainerDN() throws IdentityException {
        String cont = this.getIdentityConfiguration().getValue("roleCtxDN");
        if (cont == null) {
            throw new IdentityException("Configuration option missing: roleCtxDN");
        }
        return cont;
    }

    protected String getDisplayNameAttributeID() throws IdentityException {
        String display = this.getIdentityConfiguration().getValue("roleDisplayNameAttributeID");
        if (display == null) {
            return this.getRidAttributeID();
        }
        return display;
    }

    protected int getSearchTimeLimit() throws IdentityException {
        int searchTimeout = 10000;
        String limit = this.getIdentityConfiguration().getValue("searchTimeLimit");
        if (limit != null) {
            try {
                searchTimeout = Integer.parseInt(limit);
            }
            catch (NumberFormatException e) {
                log.info((Object)("searchTimeLimitwrong value:" + e));
            }
        }
        return searchTimeout;
    }

    protected int getSearchScope() throws IdentityException {
        int searchScope = 1;
        String scope = this.getIdentityConfiguration().getValue("searchScope");
        if (scope != null) {
            if ("OBJECT_SCOPE".equalsIgnoreCase(scope)) {
                searchScope = 0;
            } else if ("ONELEVEL_SCOPE".equalsIgnoreCase(scope)) {
                searchScope = 1;
            } else if ("SUBTREE_SCOPE".equalsIgnoreCase(scope)) {
                searchScope = 2;
            }
        }
        return searchScope;
    }

    protected String getRoleCtxDN() throws IdentityException {
        String roleCtx = this.getIdentityConfiguration().getValue("roleCtxDN");
        if (roleCtx == null) {
            throw new IdentityException("Configuration option missing: roleCtxDN");
        }
        return roleCtx;
    }

    protected String getRoleSearchFilter() throws IdentityException {
        String searchFilter = this.getIdentityConfiguration().getValue("roleSearchFilter");
        if (searchFilter == null) {
            throw new IdentityException("roleSearchFilter missing in configuration");
        }
        return searchFilter;
    }

    public void setConnectionContext(LDAPConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }
}

