/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.metadata.config;

import java.io.InputStream;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.metadata.config.IdentityConfigurationMetaData;
import org.jboss.portal.identity.metadata.config.IdentityConfigurationMetaDataFactory;
import org.jboss.portal.identity.metadata.profile.ProfileMetaData;
import org.jboss.portal.identity.metadata.profile.ProfileMetaDataFactory;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

public abstract class ConfigurationParser {
    private static final Logger log = Logger.getLogger(ConfigurationParser.class);

    public static ProfileMetaData parseProfileConfiguration(String configFile) throws IdentityException {
        ProfileMetaData meta;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        try {
            log.info((Object)"Processing identity profile configuration");
            if (log.isDebugEnabled()) {
                log.debug((Object)("config file: " + configFile));
            }
            URL config = tcl.getResource(configFile);
            InputStream in = config.openStream();
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            ProfileMetaDataFactory factory = new ProfileMetaDataFactory();
            meta = (ProfileMetaData)unmarshaller.unmarshal(in, (ObjectModelFactory)factory, null);
            in.close();
        }
        catch (Exception e) {
            throw new IdentityException("Cannot parse identity profile configuration file", e);
        }
        return meta;
    }

    public static IdentityConfigurationMetaData parseIdentityConfiguration(String configFile) throws IdentityException {
        IdentityConfigurationMetaData meta;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        try {
            log.info((Object)"Processing portal identity configuration");
            log.debug((Object)("config file: " + configFile));
            URL config = tcl.getResource(configFile);
            InputStream in = config.openStream();
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            IdentityConfigurationMetaDataFactory factory = new IdentityConfigurationMetaDataFactory();
            meta = (IdentityConfigurationMetaData)unmarshaller.unmarshal(in, (ObjectModelFactory)factory, null);
            in.close();
        }
        catch (Exception e) {
            throw new IdentityException("Cannot parse identity configuration file", e);
        }
        return meta;
    }
}

