/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.service;

import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.MembershipModule;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.event.MembershipChangedEvent;
import org.jboss.portal.identity.info.ProfileInfo;
import org.jboss.portal.identity.service.IdentityModuleService;

public abstract class MembershipModuleService
extends IdentityModuleService
implements MembershipModule {
    private static final Logger log = Logger.getLogger(MembershipModuleService.class);
    private ProfileInfo profileInfo;

    protected MembershipModuleService() {
        super("Membership");
    }

    public ProfileInfo getProfileInfo() {
        return this.profileInfo;
    }

    public void setProfileInfo(ProfileInfo profileInfo) {
        this.profileInfo = profileInfo;
    }

    protected void fireMembershipChangedEvent(Set userIds, Set roleIds) throws IdentityException {
        MembershipChangedEvent event = new MembershipChangedEvent(userIds, roleIds);
        this.getIdentityEventBroadcaster().fireEvent(event);
    }

    protected void fireMembershipChangedEvent(User user, Set roles) throws IdentityException {
        HashSet<Object> roleIds = new HashSet<Object>();
        HashSet<Object> userIds = new HashSet<Object>();
        userIds.add(user.getId());
        for (Role role : roles) {
            roleIds.add(role.getId());
        }
        this.fireMembershipChangedEvent(userIds, roleIds);
    }

    protected void fireMembershipChangedEvent(Role role, Set users) throws IdentityException {
        HashSet<Object> roleIds = new HashSet<Object>();
        HashSet<Object> userIds = new HashSet<Object>();
        roleIds.add(role.getId());
        for (User user : users) {
            userIds.add(user.getId());
        }
        this.fireMembershipChangedEvent(userIds, roleIds);
    }
}

