/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent.config;

import java.util.Map;
import org.josso.agent.SSOAgent;
import org.josso.agent.config.ComponentKeeper;
import org.josso.agent.reverseproxy.ReverseProxyConfiguration;
import org.josso.gateway.SSOException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SpringComponentKeeperImpl
implements ComponentKeeper {
    private ApplicationContext context;

    public SpringComponentKeeperImpl(String resource) {
        GenericApplicationContext ctx = new GenericApplicationContext();
        ctx.setClassLoader(this.getClass().getClassLoader());
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        reader.loadBeanDefinitions((Resource)new ClassPathResource(resource, Thread.currentThread().getContextClassLoader()));
        ctx.refresh();
        this.context = ctx;
    }

    public SSOAgent fetchSSOAgent() throws Exception {
        Map agents = this.context.getBeansOfType(SSOAgent.class);
        if (agents.values().size() < 1) {
            throw new SSOException("No agent defined. Verify JOSSO Configuration");
        }
        if (agents.values().size() > 1) {
            throw new SSOException("Multiple agent definitions are not supported! Found : " + agents.values().size());
        }
        return (SSOAgent)agents.values().iterator().next();
    }

    public ReverseProxyConfiguration fetchReverseProxyConfiguration() throws Exception {
        return (ReverseProxyConfiguration)this.context.getBean("reverseProxyConfiguration");
    }

    public ApplicationContext getSpringContext() {
        return this.context;
    }
}

