/*
 * Decompiled with CFR 0.152.
 */
package org.josso.seam.console;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.http.Cookie;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;
import org.josso.agent.Lookup;
import org.josso.agent.SSOAgent;
import org.josso.gateway.identity.SSORole;
import org.josso.gateway.session.SSOSession;
import org.josso.gateway.session.exceptions.NoSuchSessionException;

@Name(value="jossoAuthenticator")
public class JossoAuthenticator {
    private static final long serialVersionUID = 1L;
    @Logger
    Log log;
    @In
    FacesContext facesContext;
    @In
    Identity identity;

    public void checkLogin() {
        boolean isLoggedIn = this.identity.isLoggedIn();
        if (isLoggedIn) {
            return;
        }
        this.authenticate();
    }

    public boolean authenticate() {
        Map map = this.facesContext.getExternalContext().getRequestCookieMap();
        String sessionId = null;
        if (map.containsKey("JOSSO_SESSIONID")) {
            sessionId = ((Cookie)map.get("JOSSO_SESSIONID")).getValue();
        }
        try {
            if (sessionId != null && !"".equals(sessionId)) {
                SSOAgent jossoAgent = Lookup.getInstance().lookupSSOAgent();
                SSOSession session = jossoAgent.getSSOSessionManager().getSession(null, sessionId);
                String username = session.getUsername();
                this.identity.setUsername(username);
                this.identity.setPassword(username);
                this.log.info((Object)("User " + username + " logged into Seam via JossoAuthenticator module."), new Object[0]);
                SSORole[] roles = jossoAgent.getSSOIdentityManager().findRolesBySSOSessionId(null, sessionId);
                for (int i = 0; i < roles.length; ++i) {
                    String role = roles[i].getName();
                    this.log.info((Object)("User " + username + " adding role " + role), new Object[0]);
                    this.identity.addRole(role);
                }
                return true;
            }
            this.log.error((Object)("No JOSSO session found: " + sessionId + ". User not authenticated."), new Object[0]);
        }
        catch (NoSuchSessionException e) {
            this.log.error((Object)("NoSuchSessionException : " + sessionId + ". User not authenticated."), new Object[0]);
        }
        catch (Exception e) {
            this.log.error((Object)(e.getMessage() + ". User not authenticated."), (Throwable)e, new Object[0]);
        }
        return false;
    }
}

