/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.session.service.store.db;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.session.exceptions.SSOSessionException;
import org.josso.gateway.session.service.store.db.DbSessionStore;

public class DataSourceSessionStore
extends DbSessionStore {
    private static final Log logger = LogFactory.getLog(DataSourceSessionStore.class);
    private String _dsJndiName;
    private DataSource _datasource;

    protected Connection getConnection() throws SQLException, SSOSessionException {
        Connection conn = this.getDataSource().getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    public void setDsJndiName(String dsJndiName) {
        this._dsJndiName = dsJndiName;
        this._datasource = null;
    }

    public String getDsJndiName() {
        return this._dsJndiName;
    }

    protected synchronized DataSource getDataSource() throws SSOSessionException {
        if (this._datasource == null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[getDatasource() : ]" + this._dsJndiName));
                }
                InitialContext ic = new InitialContext();
                this._datasource = (DataSource)ic.lookup(this._dsJndiName);
            }
            catch (NamingException ne) {
                logger.error((Object)"Error during DB connection lookup", (Throwable)ne);
                throw new SSOSessionException("Error During Lookup\n" + ne.getMessage());
            }
        }
        return this._datasource;
    }
}

